/*
 * Decompiled with CFR 0.152.
 */
package ldinsp.ldraw;

public enum LDrawPartOrigin {
    OFFICIAL("ofc", "official", "part loaded from a library tagged \"official\"", 0xFF00FF),
    UNOFFICIAL("uno", "unofficial", "part loaded from a library tagged \"unofficial\"", -275820545),
    SELF("self", "selfcontained", "part loaded from the specified file", 0xFFFFFF),
    UNRESOLVED("unrsv", "unresolved", "part is not yet being searched for", 0x7F7F7FFF),
    MISSING("miss", "missing", "part could not be found in the current context", -1358954241);

    public final String nameShort;
    public final String nameFull;
    public final String explanation;
    public final int rgbaCol;

    private LDrawPartOrigin(String ins, String inf, String iexpl, int icolor) {
        this.nameShort = ins;
        this.nameFull = inf;
        this.explanation = iexpl;
        this.rgbaCol = icolor;
    }

    public String toString() {
        return this.nameShort;
    }

    public static LDrawPartOrigin getByShortName(String chk) {
        LDrawPartOrigin[] lDrawPartOriginArray = LDrawPartOrigin.values();
        int n = lDrawPartOriginArray.length;
        int n2 = 0;
        while (n2 < n) {
            LDrawPartOrigin o = lDrawPartOriginArray[n2];
            if (o.nameShort.equals(chk)) {
                return o;
            }
            ++n2;
        }
        return MISSING;
    }

    public static LDrawPartOrigin getByFullName(String chk) {
        LDrawPartOrigin[] lDrawPartOriginArray = LDrawPartOrigin.values();
        int n = lDrawPartOriginArray.length;
        int n2 = 0;
        while (n2 < n) {
            LDrawPartOrigin o = lDrawPartOriginArray[n2];
            if (o.nameFull.equals(chk)) {
                return o;
            }
            ++n2;
        }
        return MISSING;
    }
}

