/*
 * Decompiled with CFR 0.152.
 */
package ldinsp.ldraw;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ldinsp.ldraw.LDrawLine;
import ldinsp.ldraw.LDrawLineFile;
import ldinsp.ldraw.LDrawLineOther;
import ldinsp.ldraw.LDrawLineStep;
import ldinsp.ldraw.LDrawPartOrigin;

public class LDrawPart {
    private static final Pattern VALID_FILENAME_PATTERN = Pattern.compile("^([a-z0-9\\.]+)(-[a-z0-9]+)? - (.*)", 2);
    public LDrawPartOrigin origin;
    public String loadedFromFilename;
    public String givenFilename;
    public String givenName;
    public String description;
    public String author;
    public String license;
    public boolean isCw;
    public ArrayList<LDrawLine> content = new ArrayList();
    public ArrayList<LDrawLine> headerKeys = new ArrayList();
    public ArrayList<LDrawLineStep> steps = new ArrayList();
    public LDrawPart owner;
    public ArrayList<LDrawPart> subParts;

    public String getSource() {
        StringBuilder s = new StringBuilder();
        LDrawPart.appendPart(s, this);
        if (this.subParts != null) {
            for (LDrawPart sb : this.subParts) {
                LDrawPart.appendPart(s, sb);
            }
        }
        return s.toString();
    }

    public LDrawPart copyWithoutSubs(LDrawPart newOwner, String newFilename, int lineNr) {
        LDrawPart copy = new LDrawPart();
        if (newOwner == null) {
            newOwner = copy;
        }
        copy.owner = newOwner;
        copy.givenFilename = newFilename;
        copy.origin = LDrawPartOrigin.SELF;
        copy.givenName = this.givenFilename == null || this.givenFilename.equals(this.givenName) ? newFilename : this.givenName;
        copy.description = this.description != null ? this.description : "";
        copy.author = this.author;
        copy.license = this.license;
        copy.isCw = this.isCw;
        copy.content.add(new LDrawLineFile(newOwner, lineNr++, "0 FILE " + newFilename, newFilename));
        copy.content.add(new LDrawLineOther(newOwner, lineNr++, "0 " + this.description));
        copy.content.add(new LDrawLineOther(newOwner, lineNr++, "0 Name: " + copy.givenName));
        int i = this.getFirstLineAfterName();
        while (i < this.content.size()) {
            copy.content.add(this.content.get(i).copy(newOwner, lineNr++));
            ++i;
        }
        return copy;
    }

    public String getBestFilename() {
        String filename = this.givenName;
        if (filename == null || filename.length() == 0) {
            filename = this.givenFilename;
        }
        if (filename == null || filename.length() == 0) {
            filename = this.loadedFromFilename;
        }
        return filename;
    }

    public void debugPrint(String message) {
        if (message != null) {
            System.out.println(message);
        }
        for (LDrawLine l : this.content) {
            System.out.printf("%4d: (%11s) %s\n", l.lineNr, l.headerKey == null ? "null" : l.headerKey.name(), l.source);
        }
    }

    public static Matcher getValidFilenameMatcher(String chkFilename) {
        if (chkFilename == null) {
            chkFilename = "";
        }
        return VALID_FILENAME_PATTERN.matcher(chkFilename);
    }

    public static String getBestGuessSetId(String chkFilename) {
        Matcher matcher = LDrawPart.getValidFilenameMatcher(chkFilename);
        if (!matcher.matches()) {
            return "";
        }
        String setId = matcher.group(1);
        String optQualStr = matcher.group(2);
        if (optQualStr != null && optQualStr.length() > 1) {
            setId = String.valueOf(setId) + "-" + optQualStr.substring(1);
        }
        return setId;
    }

    private static void appendPart(StringBuilder s, LDrawPart p) {
        for (LDrawLine l : p.content) {
            s.append(l.source);
            s.append("\n");
        }
    }

    private int getFirstLineAfterName() {
        int cnt = 0;
        if (this.content.size() > 0 && this.content.get((int)0).source.toLowerCase().startsWith("0 file ")) {
            ++cnt;
        }
        if (this.content.size() > cnt && this.content.get((int)cnt).source.startsWith("0 ")) {
            ++cnt;
        }
        if (this.content.size() > cnt && this.content.get((int)cnt).source.toLowerCase().startsWith("0 name: ")) {
            ++cnt;
        }
        return cnt;
    }
}

