/*
 * Decompiled with CFR 0.152.
 */
package ldinsp.ldraw;

import java.util.ArrayList;
import java.util.List;
import ldinsp.context.LDIContext;
import ldinsp.ldraw.LDrawLine;
import ldinsp.ldraw.LDrawLineFile;
import ldinsp.ldraw.LDrawLineHeaderKey;
import ldinsp.ldraw.LDrawLineOther;
import ldinsp.ldraw.LDrawLinePartRef;
import ldinsp.ldraw.LDrawPart;

public class LDrawEdit {
    public static final String OMR_LICENSE = "Redistributable under CCAL version 2.0 : see CAreadme.txt";

    public static int addGivenFilename(LDrawPart part, String newName) {
        if (part == null || LDrawEdit.isFile(part, 0)) {
            return 0;
        }
        part.content.add(0, new LDrawLineFile(part, 0, "0 FILE " + newName, newName));
        part.givenFilename = newName;
        LDrawEdit.renumberLines(part);
        return 1;
    }

    public static int setGivenName(LDrawPart part, String newName) {
        if (part == null) {
            return 0;
        }
        int dest = 0;
        if (LDrawEdit.isFile(part, dest)) {
            ++dest;
        }
        if (LDrawEdit.isDescriptionMeta(part, dest += LDrawEdit.skipAdditionalDescriptionMeta(part, dest))) {
            ++dest;
        }
        dest += LDrawEdit.skipAdditionalDescriptionMeta(part, dest);
        LDrawLineOther name = new LDrawLineOther(part.owner, dest, "0 Name: " + newName);
        if (!LDrawEdit.isName(part, dest)) {
            part.content.add(dest, name);
            LDrawEdit.renumberLines(part.owner);
        } else {
            part.content.set(dest, name);
        }
        part.givenName = newName;
        return 1;
    }

    public static int setAuthor(LDrawPart part, String newAuthor, boolean recursive, boolean overwriteExisting, boolean removeMultiple) {
        if (part == null) {
            return 0;
        }
        int cnt = LDrawEdit.doSetAuthor(part, newAuthor, overwriteExisting, removeMultiple);
        if (recursive && part.subParts != null) {
            for (LDrawPart sb : part.subParts) {
                cnt += LDrawEdit.doSetAuthor(sb, newAuthor, overwriteExisting, removeMultiple);
            }
        }
        LDrawEdit.renumberLines(part);
        return cnt;
    }

    public static int setDescription(LDrawPart part, String newDescription) {
        if (part == null) {
            return 0;
        }
        int dest = 0;
        if (LDrawEdit.isFile(part, dest)) {
            ++dest;
        }
        dest += LDrawEdit.skipAdditionalDescriptionMeta(part, dest);
        LDrawLineOther name = new LDrawLineOther(part.owner, dest, "0 " + newDescription);
        if (!LDrawEdit.isDescriptionMeta(part, dest)) {
            part.content.add(dest, name);
            LDrawEdit.renumberLines(part.owner);
        } else {
            part.content.set(dest, name);
        }
        part.description = newDescription;
        return 1;
    }

    public static int setLicense(LDrawPart part, String newLicense, boolean recursive, boolean overwriteExisting, boolean removeMultiple) {
        if (part == null) {
            return 0;
        }
        int cnt = LDrawEdit.doSetLicense(part, newLicense, overwriteExisting, removeMultiple);
        if (recursive && part.subParts != null) {
            for (LDrawPart sb : part.subParts) {
                cnt += LDrawEdit.doSetLicense(sb, newLicense, overwriteExisting, removeMultiple);
            }
        }
        LDrawEdit.renumberLines(part);
        return cnt;
    }

    public static int syncName(LDrawPart part, boolean recursive) {
        if (part == null) {
            return 0;
        }
        int cnt = LDrawEdit.doSyncName(part);
        if (recursive && part.subParts != null) {
            for (LDrawPart sb : part.subParts) {
                cnt += LDrawEdit.doSyncName(sb);
            }
        }
        return cnt;
    }

    public static int resolveMoved(LDrawPart part, LDIContext ctx, boolean recursive) {
        if (part == null) {
            return 0;
        }
        int cnt = LDrawEdit.doResolveMoved(part, ctx);
        if (recursive && part.subParts != null) {
            for (LDrawPart sb : part.subParts) {
                cnt += LDrawEdit.doResolveMoved(sb, ctx);
            }
        }
        return cnt;
    }

    public static int embed(LDrawPart part, List<LDrawPart> toEmbed, String ensureNamePrefix, LDIContext ctx) {
        if (part == null || toEmbed == null || toEmbed.size() == 0) {
            return 0;
        }
        if (part.owner != null) {
            part = part.owner;
        }
        if (part.subParts == null) {
            part.subParts = new ArrayList();
        }
        int cnt = 0;
        int lineNr = LDrawEdit.getLastLineNumber(part) + 1;
        for (LDrawPart p : toEmbed) {
            String fullname;
            String leadingPath = "";
            String filename = p.getBestFilename().replaceAll("/", "\\");
            int leadingPathEnd = filename.lastIndexOf(92);
            if (leadingPathEnd >= 0) {
                leadingPath = filename.substring(0, leadingPathEnd + 1);
                filename = filename.substring(leadingPathEnd + 1);
            }
            if (filename == null || filename.length() == 0) continue;
            if (ensureNamePrefix != null && ensureNamePrefix.length() > 0 && !filename.startsWith(ensureNamePrefix)) {
                filename = String.valueOf(ensureNamePrefix) + filename;
            }
            if (LDrawEdit.hasSubPartName(part, fullname = String.valueOf(leadingPath) + filename)) continue;
            LDrawPart copy = p.copyWithoutSubs(part, fullname, lineNr);
            part.subParts.add(copy);
            cnt += copy.content.size();
            lineNr += copy.content.size();
        }
        return cnt;
    }

    public static int remove(LDrawPart part, List<LDrawPart> toRemove) {
        if (part == null || part.subParts == null || toRemove == null || toRemove.size() == 0) {
            return 0;
        }
        int cnt = 0;
        for (LDrawPart r : toRemove) {
            if (!part.subParts.contains(r)) continue;
            part.subParts.remove(r);
            cnt += r.content.size() + r.content.size();
        }
        LDrawEdit.renumberLines(part);
        return cnt;
    }

    public static int removeRefs(LDrawPart part, List<String> toRemove, boolean recursive) {
        if (part == null || toRemove == null || toRemove.size() == 0) {
            return 0;
        }
        int cnt = LDrawEdit.doRemoveRefs(part, toRemove);
        if (recursive && part.subParts != null) {
            for (LDrawPart sb : part.subParts) {
                cnt += LDrawEdit.doRemoveRefs(sb, toRemove);
            }
        }
        LDrawEdit.renumberLines(part);
        return cnt;
    }

    public static int removeUnresolvableRefs(LDrawPart part, LDIContext ctx, boolean recursive) {
        if (part == null) {
            return 0;
        }
        int cnt = LDrawEdit.doRemoveUnresolvable(part, ctx);
        if (recursive && part.subParts != null) {
            for (LDrawPart sb : part.subParts) {
                cnt += LDrawEdit.doRemoveUnresolvable(sb, ctx);
            }
        }
        LDrawEdit.renumberLines(part);
        return cnt;
    }

    public static int exchangePartRef(LDrawPart part, String oldRefname, String newRefname, boolean recursive) {
        if (part == null || oldRefname == null || oldRefname.length() == 0 || newRefname == null || newRefname.length() == 0) {
            return 0;
        }
        int cnt = LDrawEdit.doExchangeRef(part, oldRefname, newRefname);
        if (recursive && part.subParts != null) {
            for (LDrawPart sb : part.subParts) {
                cnt += LDrawEdit.doExchangeRef(sb, oldRefname, newRefname);
            }
        }
        return cnt;
    }

    public static int exchangeColor(LDrawPart part, int oldCol, int newCol, boolean recursive) {
        if (part == null) {
            return 0;
        }
        int cnt = LDrawEdit.doExchangeColor(part, oldCol, newCol);
        if (recursive && part.subParts != null) {
            for (LDrawPart sb : part.subParts) {
                cnt += LDrawEdit.doExchangeColor(sb, oldCol, newCol);
            }
        }
        return cnt;
    }

    public static int exchangePartRefAndColor(LDrawPart part, String oldRefname, String newRefname, int oldCol, int newCol, boolean recursive) {
        if (part == null) {
            return 0;
        }
        int cnt = LDrawEdit.doExchangePartRefAndColor(part, oldRefname, newRefname, oldCol, newCol);
        if (recursive && part.subParts != null) {
            for (LDrawPart sb : part.subParts) {
                cnt += LDrawEdit.doExchangePartRefAndColor(sb, oldRefname, newRefname, oldCol, newCol);
            }
        }
        return cnt;
    }

    public static int renamePart(LDrawPart sub, String newSubname, boolean fixRefs) {
        String oldSubname = sub.givenFilename;
        if (sub == null || oldSubname == null || oldSubname.length() == 0 || newSubname == null || newSubname.length() == 0 || !LDrawEdit.isFile(sub, 0)) {
            return 0;
        }
        if (!(sub.content.get(0) instanceof LDrawLineFile)) {
            return 0;
        }
        LDrawLineFile fline = (LDrawLineFile)sub.content.get(0);
        int cnt = 1;
        sub.givenFilename = newSubname;
        LDrawLineFile fileLine = new LDrawLineFile(fline.owner, fline.lineNr, "0 FILE " + newSubname, newSubname);
        fileLine.headerKey = LDrawLineHeaderKey.FILE;
        sub.content.set(0, fileLine);
        if (fixRefs) {
            cnt += LDrawEdit.exchangePartRef(sub.owner, oldSubname, newSubname, true);
        }
        return cnt;
    }

    public static int removeLines(LDrawPart partWithSubs, List<LDrawLine> removeLines) {
        int cnt = 0;
        block0: for (LDrawLine r : removeLines) {
            if (partWithSubs.content.remove(r)) {
                ++cnt;
                continue;
            }
            if (partWithSubs.subParts == null) continue;
            for (LDrawPart sb : partWithSubs.subParts) {
                if (!sb.content.remove(r)) continue;
                ++cnt;
                continue block0;
            }
        }
        LDrawEdit.renumberLines(partWithSubs);
        return cnt;
    }

    public static int insertMainHeader(LDrawPart part) {
        part.content.add(0, new LDrawLineFile(part.owner, 0, "0 FILE main.ldr", "main.ldr"));
        part.description = "main";
        part.content.add(1, new LDrawLineOther(part.owner, 1, "0 " + part.description));
        part.givenName = "main.ldr";
        part.content.add(2, new LDrawLineFile(part.owner, 2, "0 Name: " + part.givenName, part.givenName));
        return 3;
    }

    public static int rewriteHeader(LDrawPart part, boolean renumberOwner) {
        if (part == null || part.content.size() == 0) {
            return 0;
        }
        ArrayList<LDrawLine> oldContent = new ArrayList<LDrawLine>(part.content);
        int nr = part.content.get((int)0).lineNr;
        int cnt = 3;
        part.content.clear();
        if (part.givenFilename != null && part.givenFilename.length() > 0) {
            part.content.add(new LDrawLineFile(part.owner, nr++, "0 FILE " + part.givenFilename, part.givenFilename));
            ++cnt;
        }
        if (part.description == null || part.description.length() == 0) {
            part.description = "generated";
        }
        part.content.add(new LDrawLineOther(part.owner, nr++, "0 " + part.description));
        if (part.givenName == null || part.givenName.length() == 0) {
            part.givenName = part.givenFilename != null && part.givenFilename.length() > 0 ? part.givenFilename : "givenName";
        }
        part.content.add(new LDrawLineFile(part.owner, nr++, "0 Name: " + part.givenName, part.givenName));
        if (part.author == null || part.author.length() == 0) {
            part.author = "unset author";
        }
        part.content.add(new LDrawLineFile(part.owner, nr++, "0 Author: " + part.author, part.author));
        for (LDrawLine line : oldContent) {
            if (line.headerKey != null) continue;
            part.content.add(line.copy(part.owner, nr++));
        }
        if (renumberOwner) {
            LDrawEdit.renumberLines(part);
        }
        return cnt;
    }

    private static int getLastLineNumber(LDrawPart part) {
        if (part.subParts != null && part.subParts.size() > 0) {
            part = part.subParts.get(part.subParts.size() - 1);
        }
        if (part.content.size() > 0) {
            return part.content.get((int)(part.content.size() - 1)).lineNr;
        }
        return 0;
    }

    private static boolean hasSubPartName(LDrawPart part, String name) {
        if (part == null || part.subParts == null) {
            return false;
        }
        for (LDrawPart sb : part.subParts) {
            if (!sb.givenFilename.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    private static void renumberLines(LDrawPart partWithSubs) {
        if (partWithSubs.owner != null) {
            partWithSubs = partWithSubs.owner;
        }
        int nr = 1;
        nr = LDrawEdit.doRenumber(partWithSubs, nr);
        if (partWithSubs.subParts != null) {
            for (LDrawPart sb : partWithSubs.subParts) {
                nr = LDrawEdit.doRenumber(sb, nr);
            }
        }
    }

    private static int doRenumber(LDrawPart part, int nr) {
        for (LDrawLine l : part.content) {
            l.lineNr = nr++;
        }
        return nr;
    }

    private static int doSetAuthor(LDrawPart part, String newAuthor, boolean overwriteExisting, boolean removeMultiple) {
        int cnt = 0;
        int i = 0;
        while (i < part.content.size()) {
            if (LDrawEdit.isAuthor(part, i)) {
                if (!overwriteExisting && !removeMultiple) {
                    return 0;
                }
                if (overwriteExisting || removeMultiple && cnt > 0) {
                    part.content.remove(i);
                } else {
                    ++i;
                }
                ++cnt;
                continue;
            }
            ++i;
        }
        if (!overwriteExisting && cnt > 0) {
            return cnt;
        }
        if (newAuthor == null || (newAuthor = newAuthor.trim()).length() == 0) {
            part.author = null;
            return cnt;
        }
        part.author = newAuthor;
        int dest = 0;
        if (LDrawEdit.isFile(part, dest)) {
            ++dest;
        }
        if (LDrawEdit.isDescriptionMeta(part, dest += LDrawEdit.skipAdditionalDescriptionMeta(part, dest))) {
            ++dest;
        }
        if (LDrawEdit.isName(part, dest += LDrawEdit.skipAdditionalDescriptionMeta(part, dest))) {
            ++dest;
        }
        String line = "0 Author: " + newAuthor;
        part.content.add(dest, new LDrawLineOther(part.owner, dest + 1, line));
        return ++cnt;
    }

    private static int doSetLicense(LDrawPart part, String newLicense, boolean overwriteExisting, boolean removeMultiple) {
        int cnt = 0;
        int i = 0;
        while (i < part.content.size()) {
            if (LDrawEdit.isLicense(part, i)) {
                if (!overwriteExisting && !removeMultiple) {
                    return 0;
                }
                if (overwriteExisting || removeMultiple && cnt > 0) {
                    part.content.remove(i);
                } else {
                    ++i;
                }
                ++cnt;
                continue;
            }
            ++i;
        }
        if (!overwriteExisting && cnt > 0) {
            return cnt;
        }
        if (newLicense == null || (newLicense = newLicense.trim()).length() == 0) {
            return cnt;
        }
        int dest = 0;
        if (LDrawEdit.isFile(part, dest)) {
            ++dest;
        }
        if (LDrawEdit.isDescriptionMeta(part, dest += LDrawEdit.skipAdditionalDescriptionMeta(part, dest))) {
            ++dest;
        }
        if (LDrawEdit.isName(part, dest += LDrawEdit.skipAdditionalDescriptionMeta(part, dest))) {
            ++dest;
        }
        dest += LDrawEdit.skipAdditionalDescriptionMeta(part, dest);
        while (LDrawEdit.isAuthor(part, dest)) {
            ++dest;
        }
        dest += LDrawEdit.skipAdditionalDescriptionMeta(part, dest);
        while (LDrawEdit.isLDrawOrg(part, dest)) {
            ++dest;
        }
        String line = "0 !LICENSE " + newLicense;
        part.content.add(dest, new LDrawLineOther(part.owner, dest + 1, line));
        return ++cnt;
    }

    private static int doSyncName(LDrawPart part) {
        String targetName = part.givenFilename;
        if (targetName == null || targetName.length() == 0) {
            targetName = part.loadedFromFilename;
        }
        if (targetName == null || targetName.length() == 0) {
            return 0;
        }
        int dest = 0;
        if (LDrawEdit.isFile(part, dest)) {
            ++dest;
        }
        if (LDrawEdit.isDescriptionMeta(part, dest)) {
            ++dest;
        }
        String line = "0 Name: " + part.givenFilename;
        LDrawLineOther nameLine = new LDrawLineOther(part.owner, 2, line);
        nameLine.headerKey = LDrawLineHeaderKey.NAME;
        if (LDrawEdit.isName(part, dest)) {
            part.content.set(2, nameLine);
        } else {
            part.content.add(2, nameLine);
        }
        return 1;
    }

    private static int doResolveMoved(LDrawPart part, LDIContext ctx) {
        int cnt = 0;
        int i = 0;
        while (i < part.content.size()) {
            LDrawLine line = part.content.get(i);
            if (line instanceof LDrawLinePartRef) {
                LDrawPart dest;
                LDrawLinePartRef ref = (LDrawLinePartRef)line;
                LDrawPart orig = ctx.getPart(null, ref.refname, null);
                if (orig != null && (dest = ctx.getMoveCleanedPart(orig)) != orig) {
                    String source = ref.getSourceForReplacedColRef(-1, dest.loadedFromFilename);
                    ref = new LDrawLinePartRef(ref.owner, ref.lineNr, source, ref.colId, ref.trans, ref.transSource, dest.loadedFromFilename);
                    part.content.set(i, ref);
                    ++cnt;
                }
            }
            ++i;
        }
        return cnt;
    }

    private static int doRemoveRefs(LDrawPart part, List<String> toRemove) {
        int cnt = 0;
        int i = part.content.size() - 1;
        while (i >= 0) {
            LDrawLine line = part.content.get(i);
            if (line instanceof LDrawLinePartRef) {
                LDrawLinePartRef ref = (LDrawLinePartRef)line;
                if (toRemove.contains(ref.refname)) {
                    part.content.remove(i);
                    ++cnt;
                }
            }
            --i;
        }
        return cnt;
    }

    private static int doRemoveUnresolvable(LDrawPart part, LDIContext ctx) {
        int cnt = 0;
        int i = part.content.size() - 1;
        while (i >= 0) {
            LDrawLine line = part.content.get(i);
            if (line instanceof LDrawLinePartRef) {
                LDrawLinePartRef ref = (LDrawLinePartRef)line;
                LDrawPart orig = ctx.getPart(ref.owner, ref.refname, null);
                if (orig == null) {
                    part.content.remove(i);
                    ++cnt;
                }
            }
            --i;
        }
        return cnt;
    }

    private static int doExchangeRef(LDrawPart part, String oldRefname, String newRefname) {
        int cnt = 0;
        int i = part.content.size() - 1;
        while (i >= 0) {
            LDrawLine line = part.content.get(i);
            if (line instanceof LDrawLinePartRef) {
                LDrawLinePartRef ref = (LDrawLinePartRef)line;
                if (oldRefname.equalsIgnoreCase(ref.refname)) {
                    String source = ref.getSourceForReplacedColRef(-1, newRefname);
                    ref = new LDrawLinePartRef(ref.owner, ref.lineNr, source, ref.colId, ref.trans, ref.transSource, newRefname);
                    part.content.set(i, ref);
                    ++cnt;
                }
            }
            --i;
        }
        return cnt;
    }

    private static int doExchangeColor(LDrawPart part, int oldCol, int newCol) {
        int cnt = 0;
        int i = part.content.size() - 1;
        while (i >= 0) {
            LDrawLine line = part.content.get(i);
            if (line instanceof LDrawLinePartRef) {
                LDrawLinePartRef ref = (LDrawLinePartRef)line;
                if (ref.colId == oldCol) {
                    String source = ref.getSourceForReplacedColRef(newCol, null);
                    ref = new LDrawLinePartRef(ref.owner, ref.lineNr, source, newCol, ref.trans, ref.transSource, ref.refname);
                    part.content.set(i, ref);
                    ++cnt;
                }
            }
            --i;
        }
        return cnt;
    }

    private static int doExchangePartRefAndColor(LDrawPart part, String oldRefname, String newRefname, int oldCol, int newCol) {
        int cnt = 0;
        int i = part.content.size() - 1;
        while (i >= 0) {
            LDrawLine line = part.content.get(i);
            if (line instanceof LDrawLinePartRef) {
                LDrawLinePartRef ref = (LDrawLinePartRef)line;
                if (!(oldRefname != null && !oldRefname.equalsIgnoreCase(ref.refname) || oldCol != -1 && ref.colId != oldCol)) {
                    String source = ref.getSourceForReplacedColRef(newCol, null);
                    ref = new LDrawLinePartRef(ref.owner, ref.lineNr, source, newCol, ref.trans, ref.transSource, ref.refname);
                    part.content.set(i, ref);
                    ++cnt;
                }
            }
            --i;
        }
        return cnt;
    }

    private static boolean isFile(LDrawPart part, int nr) {
        String loli;
        return nr < part.content.size() && (loli = part.content.get((int)nr).source.toLowerCase()).startsWith("0 file ");
    }

    private static int skipAdditionalDescriptionMeta(LDrawPart part, int nr) {
        while (nr < part.content.size()) {
            String li = part.content.get((int)nr).source;
            if (!li.startsWith("0 !")) break;
            ++nr;
        }
        return nr;
    }

    private static boolean isDescriptionMeta(LDrawPart part, int nr) {
        String li;
        return nr < part.content.size() && (li = part.content.get((int)nr).source).startsWith("0 ") && !li.startsWith("0 !");
    }

    private static boolean isName(LDrawPart part, int nr) {
        String loli;
        return nr < part.content.size() && (loli = part.content.get((int)nr).source.toLowerCase()).startsWith("0 name: ");
    }

    private static boolean isAuthor(LDrawPart part, int nr) {
        String loli;
        return nr < part.content.size() && (loli = part.content.get((int)nr).source.toLowerCase()).startsWith("0 author: ");
    }

    private static boolean isLDrawOrg(LDrawPart part, int nr) {
        String loli;
        return nr < part.content.size() && (loli = part.content.get((int)nr).source.toLowerCase()).startsWith("0 !ldraw_org ");
    }

    private static boolean isLicense(LDrawPart part, int nr) {
        String loli;
        return nr < part.content.size() && (loli = part.content.get((int)nr).source.toLowerCase()).startsWith("0 !license ");
    }
}

