/*
 * Decompiled with CFR 0.152.
 */
package ldinsp.gui.view;

import java.util.ArrayList;
import java.util.HashMap;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Task;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeItem;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.text.Text;
import javafx.util.Callback;
import javafx.util.StringConverter;
import ldinsp.check.LDICAll;
import ldinsp.check.LDICCollidingParts;
import ldinsp.check.LDICheckMessage;
import ldinsp.context.LDICColor;
import ldinsp.context.LDICColorHint;
import ldinsp.data.LDIData;
import ldinsp.gui.GuiHelper;
import ldinsp.gui.LDIGui;
import ldinsp.gui.NumberTextField;
import ldinsp.gui.view.LDIPartRender;
import ldinsp.gui.view.LDIPartRenderFilter;
import ldinsp.gui.view.LDIPartScene;
import ldinsp.gui.view.LDIPartSceneSettings;
import ldinsp.gui.view.LDIView;
import ldinsp.ldraw.LDrawLine;
import ldinsp.ldraw.LDrawLinePartRef;
import ldinsp.ldraw.LDrawPart;

public class LDIVRender
extends BorderPane
implements LDIView {
    private static final double BUTTON_CAM_VIEW_STEP = 5.0;
    private static final double BUTTON_CAM_ANGLE_STEP = 3.0;
    private static final double BUTTON_CAM_DIST_STEP = 50.0;
    private static final double BUTTON_OBJ_ANGLE_STEP = 15.0;
    private final LDIGui main;
    private final ComboBox<LinesConfig> drawLines;
    private final ComboBox<ColorConfig> ovwColor;
    private final ComboBox<LDICColor> colorSelect;
    private final NumberTextField stepFrom;
    private final NumberTextField stepTo;
    private final Text stepInfoLabel;
    private final Text infoLabel;
    private final LDIPartSceneSettings sceneSettings;
    private final LDIPartScene scene;
    private final HashMap<LDIData, LDIPartRender> cache;
    private LDIData data;
    private LDIPartRender dest;
    private boolean dataValid;
    private boolean isTabSelected;

    public LDIVRender(LDIGui imain) {
        this.main = imain;
        this.sceneSettings = new LDIPartSceneSettings();
        this.scene = new LDIPartScene(640, 480, this.sceneSettings);
        this.scene.objectScene.setFill((Paint)Color.LIGHTBLUE);
        this.cache = new HashMap();
        VBox controlPane = new VBox();
        controlPane.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        controlPane.setSpacing(10.0);
        controlPane.setMinSize(100.0, 70.0);
        this.setTop((Node)controlPane);
        HBox controlLine = new HBox();
        controlLine.setSpacing(10.0);
        controlLine.setAlignment(Pos.CENTER_LEFT);
        controlPane.getChildren().add((Object)controlLine);
        Button button = new Button("Reset View");
        button.setMaxHeight(Double.MAX_VALUE);
        button.setOnAction(event -> this.sceneSettings.resetView());
        controlLine.getChildren().add((Object)button);
        button = new Button("Auto View");
        button.setOnAction(event -> {
            if (this.dataValid) {
                this.scene.autoAdjustView();
            }
        });
        button.setMaxHeight(Double.MAX_VALUE);
        controlLine.getChildren().add((Object)button);
        button = new Button("Refresh");
        button.setOnAction(event -> {
            this.dataValid = false;
            this.refresh();
        });
        button.setMaxHeight(Double.MAX_VALUE);
        controlLine.getChildren().add((Object)button);
        button = new Button("Dismiss Cache");
        button.setOnAction(event -> this.contextChanged());
        button.setMaxHeight(Double.MAX_VALUE);
        controlLine.getChildren().add((Object)button);
        this.drawLines = new ComboBox();
        this.drawLines.getItems().addAll((Object[])LinesConfig.values());
        this.drawLines.getSelectionModel().select((Object)LinesConfig.DEFAULT);
        this.drawLines.setMaxHeight(Double.MAX_VALUE);
        this.drawLines.getSelectionModel().selectedItemProperty().addListener((obs, oldVal, newVal) -> {
            this.cache.clear();
            this.dataValid = false;
            if (this.data != null) {
                this.refresh();
            }
        });
        controlLine.getChildren().add(this.drawLines);
        CheckBox showAxes = new CheckBox("Axes");
        showAxes.setAllowIndeterminate(false);
        showAxes.setSelected(true);
        showAxes.setMaxHeight(Double.MAX_VALUE);
        controlLine.getChildren().add((Object)showAxes);
        controlLine.getChildren().add((Object)new Text("Cam.View"));
        button = new Button("a+");
        button.setOnAction(event -> {
            if (this.sceneSettings.camFieldView.get() <= 155.0) {
                this.sceneSettings.camFieldView.set(this.sceneSettings.camFieldView.get() + 5.0);
            }
        });
        button.setMaxHeight(Double.MAX_VALUE);
        controlLine.getChildren().add((Object)button);
        button = new Button("a-");
        button.setOnAction(event -> {
            if (this.sceneSettings.camFieldView.get() >= 15.0) {
                this.sceneSettings.camFieldView.set(this.sceneSettings.camFieldView.get() - 5.0);
            }
        });
        button.setMaxHeight(Double.MAX_VALUE);
        controlLine.getChildren().add((Object)button);
        controlLine = new HBox();
        controlLine.setSpacing(10.0);
        controlLine.setAlignment(Pos.CENTER_LEFT);
        controlPane.getChildren().add((Object)controlLine);
        controlLine.getChildren().add((Object)new Text("Cam.Ang."));
        button = new Button("x+");
        button.setOnAction(event -> this.sceneSettings.camAngleX.set(this.sceneSettings.camAngleX.get() + 3.0));
        button.setMaxHeight(Double.MAX_VALUE);
        controlLine.getChildren().add((Object)button);
        button = new Button("x-");
        button.setOnAction(event -> this.sceneSettings.camAngleX.set(this.sceneSettings.camAngleX.get() - 3.0));
        button.setMaxHeight(Double.MAX_VALUE);
        controlLine.getChildren().add((Object)button);
        button = new Button("y+");
        button.setOnAction(event -> this.sceneSettings.camAngleY.set(this.sceneSettings.camAngleY.get() + 3.0));
        button.setMaxHeight(Double.MAX_VALUE);
        controlLine.getChildren().add((Object)button);
        button = new Button("y-");
        button.setOnAction(event -> this.sceneSettings.camAngleY.set(this.sceneSettings.camAngleY.get() - 3.0));
        button.setMaxHeight(Double.MAX_VALUE);
        controlLine.getChildren().add((Object)button);
        button = new Button("z+");
        button.setOnAction(event -> this.sceneSettings.camAngleZ.set(this.sceneSettings.camAngleZ.get() + 3.0));
        button.setMaxHeight(Double.MAX_VALUE);
        controlLine.getChildren().add((Object)button);
        button = new Button("z-");
        button.setOnAction(event -> this.sceneSettings.camAngleZ.set(this.sceneSettings.camAngleZ.get() - 3.0));
        button.setMaxHeight(Double.MAX_VALUE);
        controlLine.getChildren().add((Object)button);
        controlLine.getChildren().add((Object)new Text("Cam.Pos."));
        button = new Button("x+");
        button.setOnAction(event -> this.sceneSettings.camDistX.set(this.sceneSettings.camDistX.get() + 50.0));
        button.setMaxHeight(Double.MAX_VALUE);
        controlLine.getChildren().add((Object)button);
        button = new Button("x-");
        button.setOnAction(event -> this.sceneSettings.camDistX.set(this.sceneSettings.camDistX.get() - 50.0));
        button.setMaxHeight(Double.MAX_VALUE);
        controlLine.getChildren().add((Object)button);
        button = new Button("y+");
        button.setOnAction(event -> this.sceneSettings.camDistY.set(this.sceneSettings.camDistY.get() + 50.0));
        button.setMaxHeight(Double.MAX_VALUE);
        controlLine.getChildren().add((Object)button);
        button = new Button("y-");
        button.setOnAction(event -> this.sceneSettings.camDistY.set(this.sceneSettings.camDistY.get() - 50.0));
        button.setMaxHeight(Double.MAX_VALUE);
        controlLine.getChildren().add((Object)button);
        button = new Button("z+");
        button.setOnAction(event -> this.sceneSettings.camDistZ.set(this.sceneSettings.camDistZ.get() + 50.0));
        button.setMaxHeight(Double.MAX_VALUE);
        controlLine.getChildren().add((Object)button);
        button = new Button("z-");
        button.setOnAction(event -> this.sceneSettings.camDistZ.set(this.sceneSettings.camDistZ.get() - 50.0));
        button.setMaxHeight(Double.MAX_VALUE);
        controlLine.getChildren().add((Object)button);
        controlLine = new HBox();
        controlLine.setSpacing(10.0);
        controlLine.setAlignment(Pos.CENTER_LEFT);
        controlPane.getChildren().add((Object)controlLine);
        controlLine.getChildren().add((Object)new Text("Obj.Ang."));
        button = new Button("x+");
        button.setOnAction(event -> this.sceneSettings.objAngleX.set(this.sceneSettings.objAngleX.get() + 15.0));
        button.setMaxHeight(Double.MAX_VALUE);
        controlLine.getChildren().add((Object)button);
        button = new Button("x-");
        button.setOnAction(event -> this.sceneSettings.objAngleX.set(this.sceneSettings.objAngleX.get() - 15.0));
        button.setMaxHeight(Double.MAX_VALUE);
        controlLine.getChildren().add((Object)button);
        button = new Button("y+");
        button.setOnAction(event -> this.sceneSettings.objAngleY.set(this.sceneSettings.objAngleY.get() + 15.0));
        button.setMaxHeight(Double.MAX_VALUE);
        controlLine.getChildren().add((Object)button);
        button = new Button("y-");
        button.setOnAction(event -> this.sceneSettings.objAngleY.set(this.sceneSettings.objAngleY.get() - 15.0));
        button.setMaxHeight(Double.MAX_VALUE);
        controlLine.getChildren().add((Object)button);
        button = new Button("z+");
        button.setOnAction(event -> this.sceneSettings.objAngleZ.set(this.sceneSettings.objAngleZ.get() + 15.0));
        button.setMaxHeight(Double.MAX_VALUE);
        controlLine.getChildren().add((Object)button);
        button = new Button("z-");
        button.setOnAction(event -> this.sceneSettings.objAngleZ.set(this.sceneSettings.objAngleZ.get() - 15.0));
        button.setMaxHeight(Double.MAX_VALUE);
        controlLine.getChildren().add((Object)button);
        controlLine.getChildren().add((Object)new Text("Color"));
        this.ovwColor = new ComboBox();
        this.ovwColor.getItems().addAll((Object[])ColorConfig.values());
        this.ovwColor.getSelectionModel().select((Object)ColorConfig.DEFAULT);
        this.ovwColor.setMaxHeight(Double.MAX_VALUE);
        this.ovwColor.getSelectionModel().selectedItemProperty().addListener((obs, oldVal, newVal) -> {
            this.cache.clear();
            this.dataValid = false;
            if (this.data != null) {
                this.refresh();
            }
        });
        controlLine.getChildren().add(this.ovwColor);
        this.colorSelect = new ComboBox();
        this.colorSelect.setMaxHeight(Double.MAX_VALUE);
        HBox.setHgrow(this.colorSelect, (Priority)Priority.ALWAYS);
        this.colorSelect.setConverter((StringConverter)new StringConverter<LDICColor>(){

            public String toString(LDICColor c) {
                return c != null ? String.valueOf(Integer.toString(c.id)) + " " + c.name : "";
            }

            public LDICColor fromString(String string) {
                return null;
            }
        });
        this.colorSelect.setCellFactory((Callback)new Callback<ListView<LDICColor>, ListCell<LDICColor>>(){

            public ListCell<LDICColor> call(ListView<LDICColor> p) {
                return new ListCell<LDICColor>(){
                    private final Circle colPreview = new Circle(8.0, (Paint)Color.WHITE);

                    protected void updateItem(LDICColor item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null) {
                            this.colPreview.setFill((Paint)GuiHelper.rgbaToColor(item.rgbaFace));
                            this.setGraphic((Node)this.colPreview);
                            this.setText(String.valueOf(Integer.toString(item.id)) + " " + item.name);
                            this.setTooltip(item.hints != null ? new Tooltip(LDICColorHint.hintsToString(item.hints)) : null);
                        } else {
                            this.setText("");
                            this.setGraphic(null);
                            this.setTooltip(null);
                        }
                    }
                };
            }
        });
        this.colorSelect.getSelectionModel().selectedItemProperty().addListener((obs, oldVal, newVal) -> {
            this.cache.clear();
            this.dataValid = false;
            if (this.data != null) {
                this.refresh();
            }
        });
        controlLine.getChildren().add(this.colorSelect);
        controlLine = new HBox();
        controlLine.setSpacing(10.0);
        controlLine.setAlignment(Pos.CENTER_LEFT);
        controlPane.getChildren().add((Object)controlLine);
        controlLine.getChildren().add((Object)new Text("Show steps"));
        this.stepFrom = new NumberTextField(1, 4);
        this.stepFrom.setPrefWidth(70.0);
        this.stepFrom.value.addListener((obs, oldVal, newVal) -> this.updateFromStep(newVal.intValue()));
        controlLine.getChildren().add((Object)this.stepFrom);
        controlLine.getChildren().add((Object)new Text("-"));
        this.stepTo = new NumberTextField(9999, 4);
        this.stepTo.setPrefWidth(70.0);
        this.stepTo.value.addListener((obs, oldVal, newVal) -> this.updateToStep(newVal.intValue()));
        controlLine.getChildren().add((Object)this.stepTo);
        this.stepInfoLabel = new Text();
        controlLine.getChildren().add((Object)this.stepInfoLabel);
        this.infoLabel = new Text();
        controlLine.getChildren().add((Object)this.infoLabel);
        showAxes.setOnAction(event -> this.scene.axesGroup.setVisible(showAxes.isSelected()));
        this.setCenter((Node)this.scene.objectScene);
    }

    @Override
    public void contextChanged() {
        this.colorSelect.getItems().clear();
        this.colorSelect.getItems().addAll(this.main.ctx.getColors());
        this.colorSelect.getSelectionModel().select(0);
        this.cache.clear();
        this.dataValid = false;
        if (this.isTabSelected) {
            this.refresh();
        }
    }

    @Override
    public void invalidateItem(TreeItem<LDIData> invalid) {
        LDIData invdata;
        if (invalid == null || (invdata = (LDIData)invalid.getValue()) == null) {
            return;
        }
        this.cache.remove(invdata);
        if (this.data == invdata) {
            this.dataValid = false;
        }
        if (this.isTabSelected) {
            this.refresh();
        }
    }

    @Override
    public void onTabSelection(boolean state) {
        if (!this.isTabSelected && state && !this.dataValid) {
            this.refresh();
        }
        this.isTabSelected = state;
    }

    @Override
    public void selUpdated(ObservableValue<? extends TreeItem<LDIData>> obs, TreeItem<LDIData> oldSel, TreeItem<LDIData> newSel, boolean active) {
        this.dataValid = false;
        this.data = newSel != null ? (LDIData)newSel.getValue() : null;
        if (this.isTabSelected) {
            this.refresh();
        }
    }

    private void refresh() {
        if (this.dataValid) {
            return;
        }
        this.dataValid = true;
        this.dest = null;
        this.scene.renderGroup.getChildren().clear();
        if (this.data == null || !this.data.isRenderable(this.main.ctx)) {
            this.stepInfoLabel.setText("");
            this.infoLabel.setText("");
            return;
        }
        LDIPartRender lbc = this.cache.get(this.data);
        if (lbc != null) {
            this.dest = lbc;
            this.updateVisibleSteps();
            this.scene.renderGroup.getChildren().add((Object)lbc.dest);
            return;
        }
        final LDrawPart part = this.data.getPart(this.main.ctx);
        if (part == null) {
            return;
        }
        final int colId = this.getBestRenderColor();
        int steps = part.steps.size() + 1;
        this.stepInfoLabel.setText(String.format("of %d steps", steps));
        this.infoLabel.setText(String.valueOf(this.data.getName()) + " (" + this.data.getDescription(this.main.ctx) + ") in color " + colId);
        final ColorConfig ccfg = (ColorConfig)((Object)this.ovwColor.getSelectionModel().getSelectedItem());
        this.main.runAndWait(ccfg == ColorConfig.COLL ? "Checking and building objects..." : "Building objects...", new Task<Void>(){

            protected Void call() {
                LDIPartRenderFilter filter;
                HashMap<LDrawLine, ArrayList<LDICheckMessage>> partErrors;
                switch (ccfg) {
                    case OVWRREC: {
                        partErrors = null;
                        filter = new LDIPartRenderFilter(){

                            @Override
                            public boolean isPartToShow(LDrawLinePartRef ref, String partName, int partColId, int parentColId) {
                                return true;
                            }

                            @Override
                            public void shownPartFinished(LDrawLinePartRef ref, String partName, int partColId, int pcol) {
                            }

                            @Override
                            public boolean isPrimToShow(LDrawLine line, int partColId, int parentColId) {
                                return true;
                            }

                            @Override
                            public int overwriteColor(LDrawLine line, int partColId, int parentColId) {
                                return colId;
                            }
                        };
                        break;
                    }
                    case FILTER: {
                        partErrors = null;
                        LDICColor selectedColor = (LDICColor)LDIVRender.this.colorSelect.getSelectionModel().getSelectedItem();
                        if (selectedColor != null) {
                            final int selCol = selectedColor.id;
                            filter = new LDIPartRenderFilter(){
                                private boolean show = false;
                                private LDrawLinePartRef switcher = null;

                                @Override
                                public boolean isPartToShow(LDrawLinePartRef ref, String partName, int partColId, int parentColId) {
                                    if (!this.show && partColId == selCol) {
                                        this.show = true;
                                        this.switcher = ref;
                                    }
                                    return true;
                                }

                                @Override
                                public void shownPartFinished(LDrawLinePartRef ref, String partName, int partColId, int pcol) {
                                    if (ref == this.switcher) {
                                        this.show = false;
                                        this.switcher = null;
                                    }
                                }

                                @Override
                                public boolean isPrimToShow(LDrawLine line, int partColId, int parentColId) {
                                    return this.show;
                                }

                                @Override
                                public int overwriteColor(LDrawLine line, int partColId, int parentColId) {
                                    return -1;
                                }
                            };
                            break;
                        }
                        filter = null;
                        break;
                    }
                    case CHECK: {
                        partErrors = new LDICAll(LDIVRender.this.main.ctx, part).getPartErrors();
                        filter = null;
                        break;
                    }
                    case COLL: {
                        partErrors = LDIVRender.this.nonNullErrors(new LDICCollidingParts(LDIVRender.this.main.ctx, part).getPartErrors());
                        filter = null;
                        break;
                    }
                    default: {
                        partErrors = null;
                        filter = null;
                    }
                }
                final LDIPartRender lb = LDIPartRender.buildPartAtOriginWithStat(LDIVRender.this.main.ctx, LDIVRender.this.data, colId, partErrors, filter, ((LinesConfig)((Object)LDIVRender.this.drawLines.getSelectionModel().getSelectedItem())).cnt, LDIVRender.this.main);
                if (lb != null) {
                    LDIVRender.this.cache.put(LDIVRender.this.data, lb);
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            (this).LDIVRender.this.dest = lb;
                            LDIVRender.this.updateVisibleSteps();
                            (this).LDIVRender.this.scene.renderGroup.getChildren().add((Object)lb.dest);
                        }
                    });
                }
                return null;
            }
        });
    }

    private HashMap<LDrawLine, ArrayList<LDICheckMessage>> nonNullErrors(HashMap<LDrawLine, ArrayList<LDICheckMessage>> test) {
        if (test != null) {
            return test;
        }
        return new HashMap<LDrawLine, ArrayList<LDICheckMessage>>();
    }

    private int getBestRenderColor() {
        LDICColor selectedColor;
        int colId = this.data.getColId();
        if ((this.ovwColor.getSelectionModel().getSelectedItem() == ColorConfig.OVWR || this.ovwColor.getSelectionModel().getSelectedItem() == ColorConfig.OVWRREC) && (selectedColor = (LDICColor)this.colorSelect.getSelectionModel().getSelectedItem()) != null) {
            colId = selectedColor.id;
        }
        if (colId == -1) {
            colId = 16;
        }
        return colId;
    }

    private void updateFromStep(int value) {
        if (value > this.stepTo.value.intValue()) {
            this.stepTo.value.set(value);
        }
        this.updateVisibleSteps();
    }

    private void updateToStep(int value) {
        if (value < this.stepFrom.value.intValue()) {
            this.stepFrom.value.set(value);
        }
        this.updateVisibleSteps();
    }

    private void updateVisibleSteps() {
        int stepCnt = this.dest.stepDests.size();
        int min = this.stepFrom.value.intValue() - 1;
        int max = this.stepTo.value.intValue() - 1;
        int i = 0;
        while (i < stepCnt) {
            this.dest.stepDests.get(i).setVisible(i >= min && i <= max);
            ++i;
        }
    }

    private static enum ColorConfig {
        ORIG("Original"),
        OVWR("Overwrite"),
        OVWRREC("Rec.-Ovw."),
        FILTER("Filter"),
        CHECK("OMR-Checks"),
        COLL("Collision");

        public static final ColorConfig DEFAULT;
        public final String name;

        static {
            DEFAULT = ORIG;
        }

        private ColorConfig(String in) {
            this.name = in;
        }

        public String toString() {
            return this.name;
        }
    }

    private static enum LinesConfig {
        NONE(0, "No Lines"),
        LESS(200, "First 200 L."),
        MORE(1000, "First 1.000 L."),
        MANY(5000, "First 5.000 L."),
        MASS(10000, "First 10.000 L."),
        ALL(-1, "All Lines");

        public static final LinesConfig DEFAULT;
        public final int cnt;
        public final String name;

        static {
            DEFAULT = MASS;
        }

        private LinesConfig(int ic, String in) {
            this.cnt = ic;
            this.name = in;
        }

        public String toString() {
            return this.name;
        }
    }
}

