/*
 * Decompiled with CFR 0.152.
 */
package ldinsp.gui.view;

import java.util.List;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Task;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeItem;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.TilePane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Text;
import ldinsp.data.LDIDPartList;
import ldinsp.data.LDIData;
import ldinsp.gui.LDIGui;
import ldinsp.gui.view.LDIPartRender;
import ldinsp.gui.view.LDIPartScene;
import ldinsp.gui.view.LDIPartSceneSettings;
import ldinsp.gui.view.LDIView;
import ldinsp.ldraw.LDrawPart;

public class LDIVPartGrid
extends BorderPane
implements LDIView {
    private static final double BUTTON_OBJ_ANGLE_STEP = 15.0;
    private static final int IMG_PREVIEW_WIDTH = 90;
    private static final int IMG_INTEGR_WIDTH = 90;
    private static final int BOX_WIDTH = 100;
    private final LDIGui main;
    private final LDIPartSceneSettings previewSet;
    private final LDIPartScene previewPartC;
    private final LDIPartScene previewPartU;
    private final TilePane destPane;
    private LDIData curListSource;
    private boolean isTabSelected;
    private boolean valid;

    public LDIVPartGrid(LDIGui imain) {
        this.main = imain;
        VBox controlPane = new VBox();
        controlPane.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        controlPane.setSpacing(10.0);
        controlPane.setMinSize(200.0, 100.0);
        this.setTop((Node)controlPane);
        HBox controlLineComp = new HBox();
        controlLineComp.setSpacing(10.0);
        controlLineComp.setAlignment(Pos.CENTER_LEFT);
        controlPane.getChildren().add((Object)controlLineComp);
        this.previewSet = new LDIPartSceneSettings();
        this.previewPartC = new LDIPartScene(90, 90, this.previewSet);
        this.previewPartC.axesGroup.setVisible(false);
        this.previewPartC.objectScene.setFill((Paint)Color.WHITE);
        controlLineComp.getChildren().add((Object)this.previewPartC.objectScene);
        this.previewPartU = new LDIPartScene(90, 90, this.previewSet);
        this.previewPartU.axesGroup.setVisible(false);
        this.previewPartU.objectScene.setFill((Paint)Color.WHITE);
        controlLineComp.getChildren().add((Object)this.previewPartU.objectScene);
        VBox controlLineRight = new VBox();
        controlLineRight.setSpacing(10.0);
        controlLineComp.getChildren().add((Object)controlLineRight);
        HBox controlLine = new HBox();
        controlLine.setSpacing(10.0);
        controlLineRight.getChildren().add((Object)controlLine);
        Button button = new Button("Reset View");
        button.setOnAction(event -> {
            this.previewSet.resetView();
            this.previewPartC.autoAdjustView();
        });
        button.setMaxHeight(Double.MAX_VALUE);
        controlLine.getChildren().add((Object)button);
        button = new Button("x+");
        button.setOnAction(event -> this.previewSet.objAngleX.set(this.previewSet.objAngleX.get() + 15.0));
        button.setMaxHeight(Double.MAX_VALUE);
        controlLine.getChildren().add((Object)button);
        button = new Button("x-");
        button.setOnAction(event -> this.previewSet.objAngleX.set(this.previewSet.objAngleX.get() - 15.0));
        button.setMaxHeight(Double.MAX_VALUE);
        controlLine.getChildren().add((Object)button);
        button = new Button("y+");
        button.setOnAction(event -> this.previewSet.objAngleY.set(this.previewSet.objAngleY.get() + 15.0));
        button.setMaxHeight(Double.MAX_VALUE);
        controlLine.getChildren().add((Object)button);
        button = new Button("y-");
        button.setOnAction(event -> this.previewSet.objAngleY.set(this.previewSet.objAngleY.get() - 15.0));
        button.setMaxHeight(Double.MAX_VALUE);
        controlLine.getChildren().add((Object)button);
        button = new Button("z+");
        button.setOnAction(event -> this.previewSet.objAngleZ.set(this.previewSet.objAngleZ.get() + 15.0));
        button.setMaxHeight(Double.MAX_VALUE);
        controlLine.getChildren().add((Object)button);
        button = new Button("z-");
        button.setOnAction(event -> this.previewSet.objAngleZ.set(this.previewSet.objAngleZ.get() - 15.0));
        button.setMaxHeight(Double.MAX_VALUE);
        controlLine.getChildren().add((Object)button);
        this.destPane = new TilePane(5.0, 5.0);
        ScrollPane scroller = new ScrollPane((Node)this.destPane);
        scroller.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        scroller.setVbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        scroller.setFitToWidth(true);
        this.setCenter((Node)scroller);
    }

    @Override
    public void contextChanged() {
        this.valid = false;
        if (this.isTabSelected) {
            this.rebuild();
        }
    }

    @Override
    public void invalidateItem(TreeItem<LDIData> invalid) {
        if (this.curListSource == null || this.curListSource != invalid) {
            return;
        }
        this.valid = false;
        if (this.isTabSelected) {
            this.rebuild();
        }
    }

    @Override
    public void onTabSelection(boolean state) {
        if (!this.isTabSelected && state && !this.valid) {
            this.rebuild();
        }
        this.isTabSelected = state;
    }

    @Override
    public void selUpdated(ObservableValue<? extends TreeItem<LDIData>> obs, TreeItem<LDIData> oldSel, TreeItem<LDIData> newSel, boolean active) {
        if (newSel == null) {
            this.curListSource = null;
        } else {
            LDIData nv = (LDIData)newSel.getValue();
            if (this.curListSource == nv) {
                return;
            }
            this.curListSource = nv;
        }
        this.valid = false;
        if (this.isTabSelected) {
            this.rebuild();
        }
    }

    private void rebuild() {
        this.valid = true;
        this.previewPartC.renderGroup.getChildren().clear();
        this.previewPartU.renderGroup.getChildren().clear();
        this.destPane.getChildren().clear();
        if (this.curListSource == null) {
            return;
        }
        LDIDPartList plist = this.curListSource.getPartList(this.main.ctx);
        if (plist == null) {
            return;
        }
        final List<? extends LDIData> list = plist.getSubElements(this.main.ctx);
        this.main.runAndWait("Building list...", new Task<Void>(){

            protected Void call() throws Exception {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        for (LDIData item : list) {
                            VBox node = new VBox();
                            node.setSpacing(3.0);
                            node.setPrefWidth(100.0);
                            LDrawPart part = item.getPart((this).LDIVPartGrid.this.main.ctx);
                            if (part != null) {
                                ImageView iv = new ImageView(LDIPartRender.renderImage(part, item.getColId(), 90, 90, (this).LDIVPartGrid.this.main.ctx, (this).LDIVPartGrid.this.main));
                                iv.setFitWidth(90.0);
                                iv.setFitHeight(90.0);
                                iv.setPreserveRatio(true);
                                node.setAlignment(Pos.TOP_CENTER);
                                node.getChildren().add((Object)iv);
                            } else {
                                Rectangle r = new Rectangle(90.0, 90.0);
                                r.setFill((Paint)Color.WHITE);
                                node.setAlignment(Pos.TOP_CENTER);
                                node.getChildren().add((Object)r);
                            }
                            node.getChildren().add((Object)new Text(String.valueOf(item.getAmount()) + "x"));
                            node.getChildren().add((Object)new Label(item.getName()));
                            String desc = item.getDescription((this).LDIVPartGrid.this.main.ctx);
                            node.getChildren().add((Object)new Label(desc));
                            String tip = String.valueOf(item.getAmount()) + "x\n" + item.getName() + "\n" + (desc != null ? desc : "");
                            int colId = item.getColId();
                            if (colId != -1) {
                                node.getChildren().add((Object)new Label("in " + (this).LDIVPartGrid.this.main.ctx.getColorById((int)colId).name + " (" + colId + ")"));
                                tip = String.valueOf(tip) + "\nin " + (this).LDIVPartGrid.this.main.ctx.getColorById((int)colId).name + " (" + colId + ")";
                            }
                            Button button = new Button();
                            button.setGraphic((Node)node);
                            button.setTooltip(new Tooltip(tip));
                            button.setOnAction(event -> LDIVPartGrid.this.selectPart(item, part));
                            (this).LDIVPartGrid.this.destPane.getChildren().add((Object)button);
                        }
                    }
                });
                return null;
            }
        });
    }

    private void selectPart(LDIData item, LDrawPart part) {
        this.previewPartC.renderGroup.getChildren().clear();
        this.previewPartU.renderGroup.getChildren().clear();
        if (part != null) {
            this.previewSet.resetView();
            LDIPartRender lbcCol = LDIPartRender.buildPartAtOrigin(this.main.ctx, part, item.getColId(), -1, this.main);
            this.previewPartC.renderGroup.getChildren().add((Object)lbcCol.dest);
            this.previewPartC.autoAdjustView();
            LDIPartRender lbcUni = LDIPartRender.buildPartAtOrigin(this.main.ctx, part, 16, -1, this.main);
            this.previewPartU.renderGroup.getChildren().add((Object)lbcUni.dest);
        }
    }
}

