/*
 * Decompiled with CFR 0.152.
 */
package ldinsp.gui.view;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeItem;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.text.Text;
import javafx.util.Callback;
import javafx.util.StringConverter;
import ldinsp.base.LDIWorker;
import ldinsp.context.LDICColor;
import ldinsp.context.LDICColorHint;
import ldinsp.data.LDIData;
import ldinsp.gui.GuiHelper;
import ldinsp.gui.LDIGui;
import ldinsp.gui.view.LDIView;
import ldinsp.ldraw.LDrawEdit;
import ldinsp.ldraw.LDrawFiles;
import ldinsp.ldraw.LDrawLinePartRef;
import ldinsp.ldraw.LDrawPart;
import ldinsp.ldraw.LDrawPartOrigin;

public class LDIVEdit
extends VBox
implements LDIView {
    private final LDIGui main;
    private final Button refreshButton;
    private final Button addClipboardSingle;
    private final Button addClipboardTrans;
    private final BorderPane noDetailPane;
    private final VBox partPane;
    private final Text resultText;
    private final TextField givenFilename;
    private final TextField givenName;
    private final TextField author;
    private final TextField description;
    private final TextField license;
    private final TextField inlinePrefixName;
    private final ObservableList<LDrawPart> clipboard;
    private final ListView<LDrawPart> clipboardView;
    private final HashSet<String> clipboardNames;
    private final ComboBox<LDICColor> fromColor;
    private final ComboBox<LDICColor> toColor;
    private boolean isTabSelected;
    private TreeItem<LDIData> item;
    private TreeItem<LDIData> changeableItem;
    private LDrawPart part;

    public LDIVEdit(LDIGui imain) {
        this.main = imain;
        this.clipboard = FXCollections.observableArrayList();
        this.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        this.setSpacing(10.0);
        HBox hbox = new HBox();
        hbox.setSpacing(10.0);
        this.getChildren().add((Object)hbox);
        VBox left = new VBox();
        left.setSpacing(10.0);
        hbox.getChildren().add((Object)left);
        HBox line = new HBox();
        line.setSpacing(10.0);
        line.setAlignment(Pos.CENTER_LEFT);
        left.getChildren().add((Object)line);
        this.refreshButton = new Button("Refresh item");
        this.refreshButton.setOnAction(event -> this.main.refreshItem(this.item));
        this.refreshButton.setMaxHeight(Double.MAX_VALUE);
        line.getChildren().add((Object)this.refreshButton);
        line.getChildren().add((Object)new Text("Refresh item (reload file, rescan directory...)"));
        line = new HBox();
        line.setSpacing(10.0);
        line.setAlignment(Pos.CENTER_LEFT);
        left.getChildren().add((Object)line);
        line.getChildren().add((Object)new Text("Clipboard"));
        this.addClipboardSingle = new Button("Add this element");
        this.addClipboardSingle.setOnAction(event -> this.addToClipboard(this.part, false));
        line.getChildren().add((Object)this.addClipboardSingle);
        this.addClipboardTrans = new Button("Add this element with all self-refs");
        this.addClipboardTrans.setOnAction(event -> this.addToClipboard(this.part, true));
        line.getChildren().add((Object)this.addClipboardTrans);
        Button button = new Button("Clear");
        this.clipboardNames = new HashSet();
        button.setOnAction(event -> {
            this.clipboard.clear();
            this.clipboardNames.clear();
        });
        line.getChildren().add((Object)button);
        this.clipboardView = new ListView(this.clipboard);
        this.clipboardView.setCellFactory(value -> new ListCell<LDrawPart>(){

            public void updateItem(LDrawPart listitem, boolean empty) {
                super.updateItem((Object)listitem, empty);
                if (empty || listitem == null) {
                    this.setText(null);
                } else {
                    this.setText(listitem.getBestFilename());
                }
            }
        });
        this.clipboardView.setEditable(false);
        this.clipboardView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.clipboardView.setPrefSize(100.0, 50.0);
        this.clipboardView.setMaxWidth(Double.MAX_VALUE);
        this.clipboardView.setMaxHeight(Double.MAX_VALUE);
        HBox.setHgrow(this.clipboardView, (Priority)Priority.ALWAYS);
        hbox.getChildren().add(this.clipboardView);
        button = new Button("Export\nas new\nfile");
        button.setOnAction(event -> this.exportClipboard());
        hbox.getChildren().add((Object)button);
        StackPane detailPane = new StackPane();
        VBox.setVgrow((Node)detailPane, (Priority)Priority.ALWAYS);
        this.getChildren().add((Object)detailPane);
        line = new HBox();
        line.setSpacing(10.0);
        line.setAlignment(Pos.CENTER_LEFT);
        this.getChildren().add((Object)line);
        this.noDetailPane = new BorderPane();
        detailPane.getChildren().add((Object)this.noDetailPane);
        this.noDetailPane.setCenter((Node)new Text("No item selected or no details available for selected item."));
        this.partPane = new VBox();
        detailPane.getChildren().add((Object)this.partPane);
        line = new HBox();
        line.setPadding(new Insets(0.0, 0.0, 0.0, 0.0));
        line.setAlignment(Pos.CENTER);
        line.setStyle("-fx-background-color: #F73F3F;");
        this.partPane.getChildren().add((Object)line);
        Text attention = new Text("Activating red buttons will modify your data, but changes need to be saved on Item pane!");
        line.getChildren().add((Object)attention);
        line = new HBox();
        line.setSpacing(10.0);
        line.setPadding(new Insets(10.0, 0.0, 10.0, 0.0));
        line.setAlignment(Pos.CENTER_LEFT);
        this.partPane.getChildren().add((Object)line);
        line.getChildren().add((Object)new Text("Result of last edit operation:"));
        this.resultText = new Text();
        line.getChildren().add((Object)this.resultText);
        line = new HBox();
        line.setSpacing(10.0);
        line.setPadding(new Insets(0.0, 0.0, 10.0, 0.0));
        line.setAlignment(Pos.CENTER_LEFT);
        this.partPane.getChildren().add((Object)line);
        line.getChildren().add((Object)new Text("Given filename"));
        this.givenFilename = new TextField();
        this.givenFilename.setPrefWidth(200.0);
        HBox.setHgrow((Node)this.givenFilename, (Priority)Priority.ALWAYS);
        line.getChildren().add((Object)this.givenFilename);
        CheckBox renameFixRefs = new CheckBox("Fix refs.");
        renameFixRefs.setSelected(true);
        line.getChildren().add((Object)renameFixRefs);
        button = new Button("Set");
        button.setStyle("-fx-base: #F73F3F;");
        button.setOnAction(event -> this.setGivenFilename(this.givenFilename.getText(), renameFixRefs.isSelected()));
        line.getChildren().add((Object)button);
        line = new HBox();
        line.setSpacing(10.0);
        line.setPadding(new Insets(0.0, 0.0, 10.0, 0.0));
        line.setAlignment(Pos.CENTER_LEFT);
        this.partPane.getChildren().add((Object)line);
        line.getChildren().add((Object)new Text("Given name"));
        this.givenName = new TextField();
        this.givenName.setPrefWidth(200.0);
        HBox.setHgrow((Node)this.givenName, (Priority)Priority.ALWAYS);
        line.getChildren().add((Object)this.givenName);
        button = new Button("Set");
        button.setStyle("-fx-base: #F73F3F;");
        button.setOnAction(event -> this.setGivenName(this.givenName.getText()));
        line.getChildren().add((Object)button);
        line = new HBox();
        line.setSpacing(10.0);
        line.setPadding(new Insets(0.0, 0.0, 10.0, 0.0));
        line.setAlignment(Pos.CENTER_LEFT);
        this.partPane.getChildren().add((Object)line);
        line.getChildren().add((Object)new Text("Author"));
        this.author = new TextField();
        this.author.setPrefWidth(200.0);
        HBox.setHgrow((Node)this.author, (Priority)Priority.ALWAYS);
        line.getChildren().add((Object)this.author);
        button = new Button("<<def");
        button.setOnAction(event -> {
            String defAuthor = this.main.ctx.getDefaultAuthor();
            if (defAuthor == null) {
                if (GuiHelper.yesNo(Alert.AlertType.CONFIRMATION, "Author not configured", "Default author is not configured yes", "Do you want to configure your workspace now?", false, false)) {
                    this.main.configContext();
                } else {
                    GuiHelper.fixPrimaryStage();
                }
                return;
            }
            this.author.setText(defAuthor);
        });
        line.getChildren().add((Object)button);
        CheckBox authorRecursive = new CheckBox("Recursive");
        authorRecursive.setSelected(true);
        line.getChildren().add((Object)authorRecursive);
        CheckBox authorOverwrite = new CheckBox("Ovr. existing");
        authorOverwrite.setSelected(true);
        line.getChildren().add((Object)authorOverwrite);
        button = new Button("Set");
        button.setStyle("-fx-base: #F73F3F;");
        button.setOnAction(event -> this.setAuthor(authorRecursive.isSelected(), authorOverwrite.isSelected()));
        line.getChildren().add((Object)button);
        line = new HBox();
        line.setSpacing(10.0);
        line.setPadding(new Insets(0.0, 0.0, 10.0, 0.0));
        line.setAlignment(Pos.CENTER_LEFT);
        this.partPane.getChildren().add((Object)line);
        line.getChildren().add((Object)new Text("Description"));
        this.description = new TextField();
        this.description.setPrefWidth(200.0);
        HBox.setHgrow((Node)this.description, (Priority)Priority.ALWAYS);
        line.getChildren().add((Object)this.description);
        button = new Button("Set");
        button.setStyle("-fx-base: #F73F3F;");
        button.setOnAction(event -> this.setDescription());
        line.getChildren().add((Object)button);
        line = new HBox();
        line.setSpacing(10.0);
        line.setPadding(new Insets(0.0, 0.0, 10.0, 0.0));
        line.setAlignment(Pos.CENTER_LEFT);
        this.partPane.getChildren().add((Object)line);
        line.getChildren().add((Object)new Text("License"));
        this.license = new TextField();
        this.license.setText("Redistributable under CCAL version 2.0 : see CAreadme.txt");
        this.license.setPrefWidth(200.0);
        HBox.setHgrow((Node)this.license, (Priority)Priority.ALWAYS);
        line.getChildren().add((Object)this.license);
        button = new Button("<<OMR");
        button.setOnAction(event -> this.license.setText("Redistributable under CCAL version 2.0 : see CAreadme.txt"));
        line.getChildren().add((Object)button);
        CheckBox licenseRecursive = new CheckBox("Recursive");
        licenseRecursive.setSelected(true);
        line.getChildren().add((Object)licenseRecursive);
        CheckBox licenseOverwrite = new CheckBox("Ovr. existing");
        licenseOverwrite.setSelected(true);
        line.getChildren().add((Object)licenseOverwrite);
        button = new Button("Set");
        button.setStyle("-fx-base: #F73F3F;");
        button.setOnAction(event -> this.setLicense(licenseRecursive.isSelected(), licenseOverwrite.isSelected()));
        line.getChildren().add((Object)button);
        line = new HBox();
        line.setSpacing(10.0);
        line.setPadding(new Insets(0.0, 0.0, 10.0, 0.0));
        line.setAlignment(Pos.CENTER_LEFT);
        this.partPane.getChildren().add((Object)line);
        line.getChildren().add((Object)new Text("Several"));
        CheckBox severalRecursive = new CheckBox("Recursive");
        severalRecursive.setSelected(true);
        line.getChildren().add((Object)severalRecursive);
        button = new Button("Sync given name to filename");
        button.setStyle("-fx-base: #F73F3F;");
        button.setOnAction(event -> this.syncNames(severalRecursive.isSelected()));
        line.getChildren().add((Object)button);
        button = new Button("Resolve ~moved part refs.");
        button.setStyle("-fx-base: #F73F3F;");
        button.setOnAction(event -> this.resolveMoved(severalRecursive.isSelected()));
        line.getChildren().add((Object)button);
        button = new Button("Remove unresolvable part refs.");
        button.setStyle("-fx-base: #F73F3F;");
        button.setOnAction(event -> this.removeUnresolvable(severalRecursive.isSelected()));
        line.getChildren().add((Object)button);
        line = new HBox();
        line.setSpacing(10.0);
        line.setPadding(new Insets(0.0, 0.0, 10.0, 0.0));
        line.setAlignment(Pos.CENTER_LEFT);
        this.partPane.getChildren().add((Object)line);
        line.getChildren().add((Object)new Text("Inline Parts"));
        button = new Button("Unofficial used");
        button.setStyle("-fx-base: #F73F3F;");
        button.setOnAction(event -> this.inlineParts(false));
        line.getChildren().add((Object)button);
        button = new Button("All used");
        button.setStyle("-fx-base: #F73F3F;");
        button.setOnAction(event -> this.inlineParts(true));
        line.getChildren().add((Object)button);
        button = new Button("Selected clipboard");
        button.setStyle("-fx-base: #F73F3F;");
        button.setOnAction(event -> this.inlineClipboard(false));
        line.getChildren().add((Object)button);
        button = new Button("All clipboard");
        button.setStyle("-fx-base: #F73F3F;");
        button.setOnAction(event -> this.inlineClipboard(true));
        line.getChildren().add((Object)button);
        line.getChildren().add((Object)new Text("Name prefix"));
        this.inlinePrefixName = new TextField();
        this.inlinePrefixName.setPrefWidth(80.0);
        HBox.setHgrow((Node)this.inlinePrefixName, (Priority)Priority.ALWAYS);
        line.getChildren().add((Object)this.inlinePrefixName);
        hbox = new HBox();
        hbox.setSpacing(10.0);
        this.partPane.getChildren().add((Object)hbox);
        left = new VBox();
        hbox.getChildren().add((Object)left);
        line = new HBox();
        line.setSpacing(10.0);
        line.setPadding(new Insets(0.0, 0.0, 10.0, 0.0));
        line.setAlignment(Pos.CENTER_LEFT);
        left.getChildren().add((Object)line);
        line.getChildren().add((Object)new Text("Exchange part ref."));
        TextField renameRefOld = new TextField();
        HBox.setHgrow((Node)renameRefOld, (Priority)Priority.ALWAYS);
        renameRefOld.setPrefWidth(100.0);
        renameRefOld.setTooltip(new Tooltip("include file ending"));
        line.getChildren().add((Object)renameRefOld);
        line.getChildren().add((Object)new Text("=>"));
        TextField renameRefNew = new TextField();
        HBox.setHgrow((Node)renameRefNew, (Priority)Priority.ALWAYS);
        renameRefNew.setPrefWidth(100.0);
        renameRefNew.setTooltip(new Tooltip("include file ending"));
        line.getChildren().add((Object)renameRefNew);
        CheckBox repartRecursive = new CheckBox("Recursive");
        repartRecursive.setSelected(true);
        line.getChildren().add((Object)repartRecursive);
        button = new Button("Ex. part");
        button.setStyle("-fx-base: #F73F3F;");
        button.setOnAction(event -> this.exchangePartRef(renameRefOld.getText(), renameRefNew.getText(), repartRecursive.isSelected()));
        line.getChildren().add((Object)button);
        CheckBox partFilter = new CheckBox("Filter");
        partFilter.setSelected(true);
        partFilter.setMinWidth(Double.NEGATIVE_INFINITY);
        line.getChildren().add((Object)partFilter);
        CheckBox partSet = new CheckBox("Set");
        partSet.setSelected(true);
        partSet.setMinWidth(Double.NEGATIVE_INFINITY);
        line.getChildren().add((Object)partSet);
        line = new HBox();
        line.setSpacing(10.0);
        line.setAlignment(Pos.CENTER_LEFT);
        left.getChildren().add((Object)line);
        line.getChildren().add((Object)new Text("Exchange color ref."));
        this.fromColor = new ComboBox();
        this.fromColor.setMaxHeight(Double.MAX_VALUE);
        this.fromColor.setConverter((StringConverter)new StringConverter<LDICColor>(){

            public String toString(LDICColor c) {
                return c != null ? String.valueOf(Integer.toString(c.id)) + " " + c.name : "";
            }

            public LDICColor fromString(String string) {
                return null;
            }
        });
        this.fromColor.setCellFactory((Callback)new Callback<ListView<LDICColor>, ListCell<LDICColor>>(){

            public ListCell<LDICColor> call(ListView<LDICColor> p) {
                return new ListCell<LDICColor>(){
                    private final Circle colPreview = new Circle(8.0, (Paint)Color.WHITE);

                    protected void updateItem(LDICColor colitem, boolean empty) {
                        super.updateItem((Object)colitem, empty);
                        if (colitem != null) {
                            this.colPreview.setFill((Paint)GuiHelper.rgbaToColor(colitem.rgbaFace));
                            this.setGraphic((Node)this.colPreview);
                            this.setText(String.valueOf(Integer.toString(colitem.id)) + " " + colitem.name);
                            this.setTooltip(colitem.hints != null ? new Tooltip(LDICColorHint.hintsToString(colitem.hints)) : null);
                        } else {
                            this.setText("");
                            this.setGraphic(null);
                            this.setTooltip(null);
                        }
                    }
                };
            }
        });
        line.getChildren().add(this.fromColor);
        line.getChildren().add((Object)new Text("=>"));
        this.toColor = new ComboBox();
        this.toColor.setMaxHeight(Double.MAX_VALUE);
        this.toColor.setConverter((StringConverter)new StringConverter<LDICColor>(){

            public String toString(LDICColor c) {
                return c != null ? String.valueOf(Integer.toString(c.id)) + " " + c.name : "";
            }

            public LDICColor fromString(String string) {
                return null;
            }
        });
        this.toColor.setCellFactory((Callback)new Callback<ListView<LDICColor>, ListCell<LDICColor>>(){

            public ListCell<LDICColor> call(ListView<LDICColor> p) {
                return new ListCell<LDICColor>(){
                    private final Circle colPreview = new Circle(8.0, (Paint)Color.WHITE);

                    protected void updateItem(LDICColor colitem, boolean empty) {
                        super.updateItem((Object)colitem, empty);
                        if (colitem != null) {
                            this.colPreview.setFill((Paint)GuiHelper.rgbaToColor(colitem.rgbaFace));
                            this.setGraphic((Node)this.colPreview);
                            this.setText(String.valueOf(Integer.toString(colitem.id)) + " " + colitem.name);
                            this.setTooltip(colitem.hints != null ? new Tooltip(LDICColorHint.hintsToString(colitem.hints)) : null);
                        } else {
                            this.setText("");
                            this.setGraphic(null);
                            this.setTooltip(null);
                        }
                    }
                };
            }
        });
        line.getChildren().add(this.toColor);
        CheckBox recolorRecursive = new CheckBox("Recursive");
        recolorRecursive.setSelected(true);
        recolorRecursive.setMinWidth(Double.NEGATIVE_INFINITY);
        line.getChildren().add((Object)recolorRecursive);
        button = new Button("Ex. color");
        button.setStyle("-fx-base: #F73F3F;");
        button.setOnAction(event -> this.exchangeColor(((LDICColor)this.fromColor.getSelectionModel().getSelectedItem()).id, ((LDICColor)this.toColor.getSelectionModel().getSelectedItem()).id, recolorRecursive.isSelected()));
        button.setMinWidth(Double.NEGATIVE_INFINITY);
        line.getChildren().add((Object)button);
        CheckBox colorFilter = new CheckBox("Filter");
        colorFilter.setSelected(true);
        colorFilter.setMinWidth(Double.NEGATIVE_INFINITY);
        line.getChildren().add((Object)colorFilter);
        CheckBox colorSet = new CheckBox("Set");
        colorSet.setSelected(true);
        colorSet.setMinWidth(Double.NEGATIVE_INFINITY);
        line.getChildren().add((Object)colorSet);
        button = new Button("Filtered set");
        button.setStyle("-fx-base: #F73F3F;");
        button.setOnAction(event -> this.exchangePartRefAndColor(partFilter.isSelected() ? renameRefOld.getText() : null, partSet.isSelected() ? renameRefNew.getText() : null, colorFilter.isSelected() ? ((LDICColor)this.fromColor.getSelectionModel().getSelectedItem()).id : -1, colorSet.isSelected() ? ((LDICColor)this.toColor.getSelectionModel().getSelectedItem()).id : -1, repartRecursive.isSelected() && recolorRecursive.isSelected()));
        button.setMaxHeight(Double.MAX_VALUE);
        button.setMinWidth(Double.NEGATIVE_INFINITY);
        hbox.getChildren().add((Object)button);
    }

    @Override
    public void contextChanged() {
        String defAuthor;
        if (this.author.getText().length() == 0 && (defAuthor = this.main.ctx.getDefaultAuthor()) != null) {
            this.author.setText(defAuthor);
        }
        this.fromColor.getItems().clear();
        this.fromColor.getItems().addAll(this.main.ctx.getColors());
        this.fromColor.getSelectionModel().select(0);
        this.toColor.getItems().clear();
        this.toColor.getItems().addAll(this.main.ctx.getColors());
        this.toColor.getSelectionModel().select(0);
        this.refresh();
    }

    @Override
    public void invalidateItem(TreeItem<LDIData> invalid) {
        this.refresh();
    }

    @Override
    public void onTabSelection(boolean state) {
        this.isTabSelected = state;
        this.refresh();
    }

    @Override
    public void selUpdated(ObservableValue<? extends TreeItem<LDIData>> obs, TreeItem<LDIData> oldSel, TreeItem<LDIData> newSel, boolean active) {
        this.item = newSel;
        this.refresh();
    }

    private void refresh() {
        String setId;
        LDIData data;
        this.changeableItem = null;
        this.part = null;
        this.resultText.setText("");
        if (!this.isTabSelected) {
            return;
        }
        if (this.item == null || (data = (LDIData)this.item.getValue()) == null || (this.part = data.getPart(this.main.ctx)) == null) {
            this.refreshButton.setDisable(true);
            this.addClipboardSingle.setDisable(true);
            this.addClipboardTrans.setDisable(true);
            this.noDetailPane.setVisible(true);
            this.partPane.setVisible(false);
            return;
        }
        this.refreshButton.setDisable(false);
        this.addClipboardSingle.setDisable(false);
        this.addClipboardTrans.setDisable(false);
        this.givenFilename.setText(this.part.givenFilename != null ? this.part.givenFilename : "");
        this.givenName.setText(this.part.givenName != null ? this.part.givenName : "");
        this.author.setText(this.part.author);
        this.description.setText(this.part.description);
        this.license.setText(this.part.license);
        String string = setId = this.part.givenFilename != null ? LDrawPart.getBestGuessSetId(this.part.givenFilename) : "";
        if (setId == null || setId.length() == 0) {
            this.inlinePrefixName.setText("");
        } else {
            this.inlinePrefixName.setText(String.valueOf(setId) + " - ");
        }
        this.noDetailPane.setVisible(false);
        this.partPane.setVisible(true);
        this.changeableItem = this.main.getChangeableFile(this.item);
        this.partPane.setDisable(this.changeableItem == null);
    }

    private void addToClipboard(LDrawPart toAdd, boolean transitive) {
        if (toAdd == null) {
            return;
        }
        String targetName = toAdd.getBestFilename();
        if (this.clipboardNames.contains(targetName)) {
            return;
        }
        this.clipboardNames.add(targetName);
        LDrawPart copy = toAdd.copyWithoutSubs(null, targetName, 1);
        this.clipboard.add((Object)copy);
        if (transitive) {
            LDIWorker w = new LDIWorker(){

                @Override
                public LDrawPart handlePartRef(LDrawLinePartRef ref, String partName, int colId, int pcol) {
                    if (LDIVEdit.this.clipboardNames.contains(partName)) {
                        return null;
                    }
                    LDrawPart res = LDIVEdit.this.main.ctx.getPart(ref.owner, partName, null);
                    if (res == null || res.origin != LDrawPartOrigin.SELF) {
                        return null;
                    }
                    LDIVEdit.this.addToClipboard(res, false);
                    return res;
                }
            };
            w.work(toAdd);
        }
    }

    private void exportClipboard() {
        File f = GuiHelper.showFileSaveDialog("Export clipboard as new mpd", "clip.mpd", true);
        if (f == null) {
            return;
        }
        LDrawPart exp = new LDrawPart();
        LDrawEdit.insertMainHeader(exp);
        LDrawEdit.embed(exp, this.clipboard, null, this.main.ctx);
        try {
            PrintWriter w = new PrintWriter(new FileWriter(f));
            LDrawFiles.writePart(exp, w);
            w.close();
        }
        catch (IOException e) {
            GuiHelper.alert(Alert.AlertType.ERROR, "LDInspector: export clipboard as new mpd failed", "Export clipboard as new mpd failed, because there was an I/O error", String.valueOf(e.getClass().getName()) + ": " + e.getMessage(), true);
            return;
        }
    }

    private void setGivenFilename(String newName, boolean fixRefs) {
        if (this.changeableItem == null || this.part == null) {
            return;
        }
        int cnt = LDrawEdit.renamePart(this.part, newName, fixRefs);
        this.main.setModified(this.changeableItem, true);
        this.resultText.setText("Lines changed to set given filename: " + cnt);
    }

    private void setGivenName(String newName) {
        if (this.changeableItem == null || this.part == null) {
            return;
        }
        int cnt = LDrawEdit.setGivenName(this.part, newName);
        this.main.setModified(this.changeableItem, true);
        this.resultText.setText("Lines changed to set given name: " + cnt);
    }

    private void setAuthor(boolean recursive, boolean overwrite) {
        if (this.changeableItem == null || this.part == null) {
            return;
        }
        int cnt = LDrawEdit.setAuthor(this.part, this.author.getText(), recursive, overwrite, false);
        this.main.setModified(this.changeableItem, true);
        this.resultText.setText("Lines changed to set author: " + cnt);
    }

    private void setDescription() {
        if (this.changeableItem == null || this.part == null) {
            return;
        }
        int cnt = LDrawEdit.setDescription(this.part, this.description.getText());
        this.main.setModified(this.changeableItem, true);
        this.resultText.setText("Lines changed to set license: " + cnt);
    }

    private void setLicense(boolean recursive, boolean overwrite) {
        if (this.changeableItem == null || this.part == null) {
            return;
        }
        int cnt = LDrawEdit.setLicense(this.part, this.license.getText(), recursive, overwrite, false);
        this.main.setModified(this.changeableItem, true);
        this.resultText.setText("Lines changed to set license: " + cnt);
    }

    private void syncNames(boolean recursive) {
        if (this.changeableItem == null || this.part == null) {
            return;
        }
        int cnt = LDrawEdit.syncName(this.part, recursive);
        this.main.setModified(this.changeableItem, true);
        this.resultText.setText("Lines changed to sync names: " + cnt);
    }

    private void resolveMoved(boolean recursive) {
        if (this.changeableItem == null || this.part == null) {
            return;
        }
        int cnt = LDrawEdit.resolveMoved(this.part, this.main.ctx, recursive);
        this.main.setModified(this.changeableItem, true);
        this.resultText.setText("Lines changed to resolve moved part refs: " + cnt);
    }

    private void removeUnresolvable(boolean recursive) {
        if (this.changeableItem == null || this.part == null) {
            return;
        }
        int cnt = LDrawEdit.removeUnresolvableRefs(this.part, this.main.ctx, recursive);
        this.main.setModified(this.changeableItem, true);
        this.resultText.setText("Lines changed to remove unresolvable part refs: " + cnt);
    }

    private void inlineParts(final boolean all) {
        final ArrayList<LDrawPart> toEmbed = new ArrayList<LDrawPart>();
        LDIWorker w = new LDIWorker(){
            private HashSet<String> checked = new HashSet();

            @Override
            public LDrawPart handlePartRef(LDrawLinePartRef ref, String partName, int colId, int pcol) {
                if (this.checked.contains(partName)) {
                    return null;
                }
                LDrawPart res = LDIVEdit.this.main.ctx.getPart(ref.owner, partName, null);
                this.checked.add(partName);
                if (res == null) {
                    return null;
                }
                if (all || res.origin == LDrawPartOrigin.UNOFFICIAL) {
                    toEmbed.add(res);
                }
                return res;
            }
        };
        w.work(this.part);
        int cnt = LDrawEdit.embed(this.part, toEmbed, this.inlinePrefixName.getText(), this.main.ctx);
        this.main.setModified(this.changeableItem, true);
        this.resultText.setText("Lines changed to inline parts: " + cnt);
    }

    private void inlineClipboard(boolean all) {
        int cnt = LDrawEdit.embed(this.part, (List<LDrawPart>)(all ? this.clipboard : this.clipboardView.getSelectionModel().getSelectedItems()), this.inlinePrefixName.getText(), this.main.ctx);
        this.main.setModified(this.changeableItem, true);
        this.resultText.setText("Lines changed to inline clipboard parts: " + cnt);
    }

    private void exchangePartRef(String oldRef, String newRef, boolean recursive) {
        if (this.changeableItem == null || this.part == null || oldRef == null || oldRef.length() == 0 || newRef == null || newRef.length() == 0) {
            return;
        }
        int cnt = LDrawEdit.exchangePartRef(this.part, oldRef, newRef, recursive);
        this.main.setModified(this.changeableItem, true);
        this.resultText.setText("Lines changed to exchange reference: " + cnt);
    }

    private void exchangeColor(int oldCol, int newCol, boolean recursive) {
        if (this.changeableItem == null || this.part == null) {
            return;
        }
        int cnt = LDrawEdit.exchangeColor(this.part, oldCol, newCol, recursive);
        this.main.setModified(this.changeableItem, true);
        this.resultText.setText("Lines changed to exchange color ref.: " + cnt);
    }

    private void exchangePartRefAndColor(String oldRef, String newRef, int oldCol, int newCol, boolean recursive) {
        if (this.changeableItem == null || this.part == null) {
            return;
        }
        int cnt = LDrawEdit.exchangePartRefAndColor(this.part, oldRef, newRef, oldCol, newCol, recursive);
        this.main.setModified(this.changeableItem, true);
        this.resultText.setText("Lines changed to exchange part and color refs.: " + cnt);
    }
}

