/*
 * Decompiled with CFR 0.152.
 */
package ldinsp.gui.view;

import java.util.List;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Task;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeItem;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import ldinsp.check.LDICAll;
import ldinsp.check.LDICPartList;
import ldinsp.check.LDICheck;
import ldinsp.check.LDICheckSolve;
import ldinsp.data.LDIDPartList;
import ldinsp.data.LDIData;
import ldinsp.gui.GuiHelper;
import ldinsp.gui.LDIGui;
import ldinsp.gui.view.LDIVText;
import ldinsp.ldraw.LDrawPart;

public class LDIVCheck
extends LDIVText {
    private final LDIGui main;
    private final CheckBox checkCollidingParts;
    private final Circle resIcon;
    private final Text resText;
    private final VBox doBox;
    private TreeItem<LDIData> item;
    private TreeItem<LDIData> changeableItem;
    private boolean dataValid;
    private boolean isTabSelected;

    public LDIVCheck(LDIGui imain) {
        this.main = imain;
        this.setFont(Font.font((String)"monospace"));
        this.checkCollidingParts = new CheckBox("Check Colliding Parts");
        this.checkCollidingParts.setAllowIndeterminate(false);
        this.checkCollidingParts.setSelected(false);
        this.checkCollidingParts.setMaxHeight(Double.MAX_VALUE);
        this.checkCollidingParts.setOnAction(event -> {
            this.dataValid = false;
            this.updateData();
        });
        this.addControl((Node)this.checkCollidingParts);
        this.resIcon = new Circle(8.0);
        this.addControl((Node)this.resIcon);
        this.resText = new Text();
        this.addControl((Node)this.resText);
        this.setClearDisable(true);
        this.setAutoscroll(false);
        VBox box = new VBox();
        box.setPadding(new Insets(0.0, 10.0, 0.0, 10.0));
        box.setSpacing(10.0);
        this.setRight((Node)box);
        Button button = new Button("Help");
        button.setOnAction(event -> GuiHelper.alertLargeContent(Alert.AlertType.INFORMATION, "Check Help", "LDInspector Check Help", "Several checks done here are to make models better or\nto check OMR-compliance. Some of them may be fixed\nautomatically (e.g. resolve moved parts), many of them\nneed intelligence support (e.g. naming of sub-parts), and\nsome require a \"real\" model change (e.g. mirrored parts).\n\nPlease also have a look at the Edit pane if you would like\nto change a file in several ways.", true));
        button.setMaxWidth(Double.MAX_VALUE);
        box.getChildren().add((Object)button);
        this.doBox = new VBox();
        this.doBox.setSpacing(10.0);
        box.getChildren().add((Object)this.doBox);
    }

    @Override
    public void onTabSelection(boolean state) {
        if (!this.isTabSelected && state) {
            this.updateData();
        }
        this.isTabSelected = state;
    }

    @Override
    public void selUpdated(ObservableValue<? extends TreeItem<LDIData>> obs, TreeItem<LDIData> oldSel, TreeItem<LDIData> newSel, boolean active) {
        this.item = newSel;
        this.dataValid = false;
        if (this.isTabSelected) {
            this.updateData();
        }
    }

    @Override
    public void invalidateItem(TreeItem<LDIData> invalid) {
        if (invalid != this.item) {
            return;
        }
        this.dataValid = false;
        if (this.isTabSelected) {
            this.updateData();
        }
    }

    private void updateData() {
        LDIData data;
        if (this.dataValid) {
            return;
        }
        this.clear();
        this.changeableItem = this.main.getChangeableFile(this.item);
        this.doBox.getChildren().clear();
        this.resIcon.setFill((Paint)Color.BLACK);
        this.dataValid = true;
        if (this.item == null || (data = (LDIData)this.item.getValue()) == null) {
            this.resText.setText("nothing selected");
            this.log("Please select item to check.");
            return;
        }
        final TreeItem<LDIData> check = this.item;
        this.main.runAndWait("Checking objects...", new Task<Void>(){

            protected Void call() {
                LDICheck c;
                StringBuilder sb = new StringBuilder();
                LDrawPart part = data.getPart(LDIVCheck.this.main.ctx);
                if (part != null) {
                    sb.append("Checking " + data.getName() + " as part\n");
                    c = new LDICAll(LDIVCheck.this.main.ctx, part, LDIVCheck.this.checkCollidingParts.isSelected());
                } else {
                    LDIDPartList pl = data.getPartList(LDIVCheck.this.main.ctx);
                    if (pl == null) {
                        Platform.runLater(() -> LDIVCheck.this.resText.setText("no part or part not found"));
                        return null;
                    }
                    sb.append("Checking " + data.getName() + " as list\n");
                    c = new LDICPartList(LDIVCheck.this.main.ctx, pl);
                }
                sb.append(c.getShortResult());
                sb.append("\n");
                sb.append(c.getLongResult());
                Platform.runLater(() -> {
                    if (check == LDIVCheck.this.item && LDIVCheck.this.item.getValue() == data) {
                        LDIVCheck.this.doBox.getChildren().clear();
                        LDIVCheck.this.setText(sb.toString());
                        LDIVCheck.this.resIcon.setFill((Paint)GuiHelper.rgbaToColor(lDICheck.getState().rgbaCol));
                        LDIVCheck.this.resText.setText(c.getState().toString());
                        List<LDICheckSolve> solver = c.getSolver();
                        if (solver != null) {
                            int help = 0;
                            int fix = 0;
                            for (LDICheckSolve s : solver) {
                                Button button = new Button(s.acronym);
                                button.setTooltip(new Tooltip(s.info));
                                button.setMaxWidth(Double.MAX_VALUE);
                                if (s.isFix()) {
                                    button.setStyle("-fx-base: #F73F3F;");
                                    button.setDisable(LDIVCheck.this.changeableItem == null);
                                    button.setOnAction(event -> {
                                        int cnt = s.fix();
                                        LDIVCheck.this.main.setModified(LDIVCheck.this.item, true);
                                        GuiHelper.alert(Alert.AlertType.INFORMATION, "Quick-Fix done", "Quick-Fix " + lDICheckSolve.acronym + " done", "Lines changed: " + cnt, true);
                                    });
                                    LDIVCheck.this.doBox.getChildren().add(help + fix++, (Object)button);
                                    continue;
                                }
                                button.setOnAction(event -> GuiHelper.alert(Alert.AlertType.INFORMATION, "Solve Help", "Solve Help " + lDICheckSolve.acronym, lDICheckSolve.info, true));
                                LDIVCheck.this.doBox.getChildren().add(help++, (Object)button);
                            }
                            if (fix > 0) {
                                LDIVCheck.this.doBox.getChildren().add(help, (Object)new Text("Quick-Fix"));
                            }
                            if (help > 0) {
                                LDIVCheck.this.doBox.getChildren().add(0, (Object)new Text("Quick-Help"));
                            }
                        }
                    }
                });
                return null;
            }
        });
    }
}

