/*
 * Decompiled with CFR 0.152.
 */
package ldinsp.gui;

import javafx.beans.property.SimpleIntegerProperty;
import javafx.event.EventHandler;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;

public class NumberTextField
extends TextField {
    public final SimpleIntegerProperty value = new SimpleIntegerProperty();
    private int maxVal;

    public NumberTextField(int initValue, int maxDigits) {
        if (maxDigits < 1 || maxDigits > 9) {
            maxDigits = 9;
        }
        String regex = "\\d{0," + maxDigits + "}";
        this.value.set(initValue);
        int i = 0;
        while (i < maxDigits) {
            this.maxVal = this.maxVal * 10 + 9;
            ++i;
        }
        this.setText(Integer.toString(initValue));
        this.value.addListener((obs, oldVal, newVal) -> this.setValue(newVal.intValue()));
        this.textProperty().addListener((obs, oldVal, newVal) -> {
            if (!newVal.matches(regex)) {
                this.setText((String)oldVal);
            } else {
                try {
                    int nvi = Integer.parseInt(newVal);
                    if (nvi >= 0 && nvi != this.value.intValue()) {
                        this.value.set(nvi);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        this.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent keyEvent) {
                int cv = NumberTextField.this.value.intValue();
                if (keyEvent.getCode() == KeyCode.DOWN) {
                    if (cv > 0) {
                        NumberTextField.this.setValue(NumberTextField.this.value.intValue() - 1);
                    }
                    keyEvent.consume();
                }
                if (keyEvent.getCode() == KeyCode.UP) {
                    if (cv < NumberTextField.this.maxVal) {
                        NumberTextField.this.setValue(NumberTextField.this.value.intValue() + 1);
                    }
                    keyEvent.consume();
                }
            }
        });
    }

    public void setValue(int newValue) {
        this.setText(Integer.toString(newValue));
        if (this.value.intValue() == newValue) {
            return;
        }
        this.value.set(newValue);
    }
}

