/*
 * Decompiled with CFR 0.152.
 */
package ldinsp.ext;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ldinsp.base.LDILogger;
import ldinsp.context.LDICColor;
import ldinsp.context.LDICColorHint;
import ldinsp.context.LDICColorHintSource;
import ldinsp.context.LDIContext;
import ldinsp.ext.LDIEABricklinkInventory;
import ldinsp.ext.LDIEABricklinkItem;
import ldinsp.ext.LDIEAImage;
import ldinsp.ext.LDIEAPart;
import ldinsp.ext.LDIEAWeblink;
import ldinsp.ext.LDIExternalActionResult;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class LDIBricklink {
    private static final Pattern VAR_ITEM_START = Pattern.compile(".*var(\\s+)_var_item(\\s+)=(\\s*)\\{.*");
    private static final Pattern VAR_ITEM_END = Pattern.compile(".*\\};.*");

    public static List<LDICColorHint> loadColorMappingFromWeb() throws IOException {
        String line;
        ArrayList<LDICColorHint> list = new ArrayList<LDICColorHint>();
        BufferedReader br = new BufferedReader(new InputStreamReader(LDIContext.loadWebResource("https://www.bricklink.com/catalogColors.asp?v=0")));
        while ((line = br.readLine()) != null) {
            if (!line.startsWith("<TABLE WIDTH=\"100%\" BORDER=\"0\" ")) continue;
            LDIBricklink.parseColorLine(line, list);
        }
        br.close();
        return list;
    }

    private static void parseColorLine(String line, ArrayList<LDICColorHint> list) {
        int end;
        int start = 0;
        while ((start = line.indexOf("<CENTER><TABLE", start)) != -1 && (end = line.indexOf("</TABLE>", start += 15)) != -1) {
            LDIBricklink.handleTable(line.substring(start, end), list);
            start = end + 8;
        }
    }

    private static void handleTable(String table, ArrayList<LDICColorHint> list) {
        int end;
        int start = 0;
        while ((start = table.indexOf("<TR", start)) != -1 && (end = table.indexOf("</TR>", start += 3)) != -1) {
            LDIBricklink.handleColor(table.substring(start, end), list);
            start = end + 4;
        }
    }

    private static void handleColor(String color, ArrayList<LDICColorHint> list) {
        int startColorId = color.indexOf("colorID=");
        if (startColorId == -1) {
            return;
        }
        int endColorId = color.indexOf(34, startColorId += 8);
        if (endColorId == -1 || endColorId > startColorId + 10) {
            return;
        }
        int id = -1;
        try {
            id = Integer.parseInt(color.substring(startColorId, endColorId));
        }
        catch (NumberFormatException e) {
            return;
        }
        int startColorName = color.indexOf(" SIZE=\"2\">", startColorId);
        if (startColorName == -1) {
            return;
        }
        int endColorName = color.indexOf("&nbsp;</TD>", startColorName += 10);
        if (endColorName == -1) {
            return;
        }
        String name = color.substring(startColorName, endColorName);
        list.add(new LDICColorHint(LDICColorHintSource.BRICKLINK, id, name));
    }

    public static List<LDIExternalActionResult> quickSearch(String key, boolean alwaysReload, LDIContext ctx, LDILogger logger) {
        Object p;
        ArrayList<LDIExternalActionResult> res;
        block9: {
            res = new ArrayList<LDIExternalActionResult>();
            JSONTokener t = new JSONTokener(ctx.loadCachedWebResource("blqs_" + key, "https://www.bricklink.com/ajax/clone/search/autocomplete.ajax?suggest_str=" + LDIBricklink.httpCleanup(key), alwaysReload, logger));
            JSONObject o = new JSONObject(t);
            p = o.get("products");
            if (p instanceof JSONArray) break block9;
            if (logger != null) {
                logger.log("Bricklink quick search: products returned are not an array");
            }
            return null;
        }
        try {
            boolean foundOne = false;
            JSONArray pa = (JSONArray)p;
            for (Object e : pa) {
                if (!(e instanceof JSONObject)) continue;
                foundOne = true;
                JSONObject eo = (JSONObject)e;
                int id = eo.getInt("id");
                String name = eo.getString("name");
                String img = eo.getString("imgString");
                String item = eo.getString("itemNo");
                int seq = eo.getInt("seq");
                LDIExternalActionResult ear = new LDIExternalActionResult(String.format("BL %d: %s-%d %s", id, item, seq, name));
                if (img != null && img.length() > 0) {
                    ear.actions.add(new LDIEAImage("https://www.bricklink.com/" + img));
                }
                if (item != null && item.length() > 0 && id > 0) {
                    ear.actions.add(new LDIEABricklinkItem(id));
                    ear.actions.add(new LDIEAWeblink("https://www.bricklink.com/v2/catalog/catalogitem.page?id=" + id));
                }
                res.add(ear);
            }
            if (!foundOne && logger != null) {
                logger.log("Bricklink quick search: result was empty");
            }
            return res;
        }
        catch (IOException | JSONException e) {
            ctx.dismissWebCache("blqs_" + key);
            if (logger != null) {
                logger.log("Bricklink quick search: exception: " + e.getClass().getName() + ": " + e.getMessage());
            }
            return null;
        }
    }

    public static List<LDIExternalActionResult> fullSearch(String key, boolean alwaysReload, LDIContext ctx, LDILogger logger) {
        boolean foundOne;
        JSONArray pa;
        ArrayList<LDIExternalActionResult> res;
        block16: {
            Object p;
            JSONObject o;
            block15: {
                block14: {
                    res = new ArrayList<LDIExternalActionResult>();
                    JSONTokener t = new JSONTokener(ctx.loadCachedWebResource("blfs_" + key, "https://www.bricklink.com/ajax/clone/search/searchproduct.ajax?q=" + LDIBricklink.httpCleanup(key), alwaysReload, logger));
                    o = new JSONObject(t);
                    p = o.get("result");
                    if (p instanceof JSONObject) break block14;
                    if (logger != null) {
                        logger.log("Bricklink full search: result returned is not an Object");
                    }
                    return null;
                }
                p = ((JSONObject)p).get("typeList");
                if (p instanceof JSONArray) break block15;
                if (logger != null) {
                    logger.log("Bricklink full search: result.typeList returned is not an Array");
                }
                return null;
            }
            pa = (JSONArray)p;
            foundOne = false;
            int i = 0;
            while (i < pa.length()) {
                String type;
                p = pa.get(i);
                if (p != null && p instanceof JSONObject && "S".equals(type = (o = (JSONObject)p).getString("type"))) {
                    pa = o.getJSONArray("items");
                    foundOne = true;
                    break;
                }
                ++i;
            }
            if (foundOne) break block16;
            if (logger != null) {
                logger.log("Bricklink full search: result had no type==S entry");
            }
            return null;
        }
        try {
            foundOne = false;
            for (Object e : pa) {
                if (!(e instanceof JSONObject)) continue;
                foundOne = true;
                JSONObject eo = (JSONObject)e;
                int id = eo.getInt("idItem");
                String name = eo.getString("strItemName");
                String item = eo.getString("strItemNo");
                LDIExternalActionResult ear = new LDIExternalActionResult(String.format("BL %d: %s %s", id, item, name));
                if (item != null && item.length() > 0 && id > 0) {
                    ear.actions.add(new LDIEABricklinkItem(id));
                }
                res.add(ear);
            }
            if (!foundOne && logger != null) {
                logger.log("Bricklink full search: result was empty");
            }
            return res;
        }
        catch (IOException | JSONException e) {
            ctx.dismissWebCache("blfs_" + key);
            if (logger != null) {
                logger.log("Bricklink full search: exception: " + e.getClass().getName() + ": " + e.getMessage());
            }
            return null;
        }
    }

    public static List<LDIExternalActionResult> getCatalogItem(int id, boolean alwaysReload, LDIContext ctx, LDILogger logger) {
        int year;
        StringBuffer varItem;
        ArrayList<LDIExternalActionResult> res;
        block13: {
            String line;
            res = new ArrayList<LDIExternalActionResult>();
            BufferedReader r = new BufferedReader(new InputStreamReader(ctx.loadCachedWebResource("blci_" + id, "https://www.bricklink.com/v2/catalog/catalogitem.page?id=" + id, alwaysReload, logger)));
            varItem = new StringBuffer();
            year = 0;
            boolean inVarItem = false;
            while ((line = r.readLine()) != null) {
                Matcher matcher;
                if (!inVarItem) {
                    String yearStr;
                    matcher = VAR_ITEM_START.matcher(line);
                    if (matcher.matches()) {
                        inVarItem = true;
                        continue;
                    }
                    if (year != 0 || !line.contains("Year Released:") || (yearStr = LDIBricklink.getDelimitedCleanedString(line, "itemYear=", "'")) == null) continue;
                    try {
                        year = Integer.parseInt(yearStr);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                matcher = VAR_ITEM_END.matcher(line);
                if (matcher.matches()) {
                    inVarItem = false;
                }
                varItem.append(line.trim());
            }
            r.close();
            if (varItem.length() != 0) break block13;
            if (logger != null) {
                logger.log("Bricklink catalog item: could not find varItem");
            }
            return null;
        }
        try {
            JSONTokener t = new JSONTokener("{" + varItem.toString() + "}");
            JSONObject o = new JSONObject(t);
            String typeName = o.getString("typeName");
            String itemNo = o.getString("itemno");
            String imgUrl = o.getString("strLegacyLargeImgUrl");
            LDIExternalActionResult ear = new LDIExternalActionResult(String.valueOf(typeName) + " " + itemNo + " (" + o.getString("itemnoBase") + "-" + o.getString("itemSeq") + ")" + (year > 0 ? " of " + year : "") + ": " + o.getString("strItemName"));
            if (imgUrl != null && imgUrl.length() > 0) {
                ear.actions.add(new LDIEAImage("https:" + imgUrl));
            }
            if (typeName != null && "Set".equals(typeName) && itemNo != null && "S".equals(o.getString("type")) && "A".equals(o.getString("invStatus"))) {
                ear.actions.add(new LDIEABricklinkInventory("S=" + itemNo));
            }
            res.add(ear);
            return res;
        }
        catch (IOException | JSONException e) {
            ctx.dismissWebCache("blci_" + id);
            if (logger != null) {
                logger.log("Bricklink catalog item: exception: " + e.getClass().getName() + ": " + e.getMessage());
            }
            return null;
        }
    }

    public static List<LDIExternalActionResult> getInventory(String itemNo, boolean onlyRegularItems, boolean alwaysReload, LDIContext ctx, LDILogger logger) {
        String items;
        ArrayList<LDIExternalActionResult> res;
        block10: {
            String line;
            res = new ArrayList<LDIExternalActionResult>();
            BufferedReader r = new BufferedReader(new InputStreamReader(ctx.loadCachedWebResource("bliv_" + itemNo, "https://www.bricklink.com/catalogItemInv.asp?" + itemNo, alwaysReload, logger)));
            items = null;
            while ((line = r.readLine()) != null) {
                if (!line.contains("TD COLSPAN=\"5\"")) continue;
                items = line;
                break;
            }
            r.close();
            if (items != null) break block10;
            if (logger != null) {
                logger.log("Bricklink inventory: could not find inventory");
            }
            return null;
        }
        try {
            int end;
            if (onlyRegularItems) {
                int startPos = items.indexOf("COLOR=\"#FFFFFF\"><B>Regular Items");
                if (startPos == -1) {
                    return res;
                }
                int endPos = items.indexOf("<TR BGCOLOR=\"#000000\">", startPos);
                if (endPos != -1) {
                    items = items.substring(startPos, endPos);
                }
            }
            int start = 0;
            while ((start = items.indexOf("IV_ITEM", start)) != -1 && (start = items.indexOf(62, start)) != -1 && (end = items.indexOf("</TR>", ++start)) != -1) {
                LDIBricklink.handlePart(items.substring(start, end), res, ctx, logger);
                start = end + 5;
            }
            return res;
        }
        catch (IOException e) {
            ctx.dismissWebCache("bliv_" + itemNo);
            if (logger != null) {
                logger.log("Bricklink inventory: exception: " + e.getClass().getName() + ": " + e.getMessage());
            }
            return null;
        }
    }

    private static void handlePart(String partDesc, ArrayList<LDIExternalActionResult> res, LDIContext ctx, LDILogger logger) {
        int amount;
        String amountStr;
        String part;
        int color;
        String itemWithColor;
        String desc;
        block12: {
            block11: {
                desc = LDIBricklink.getDelimitedCleanedString(partDesc, "<TD><B>", "</B>");
                itemWithColor = LDIBricklink.getDelimitedCleanedString(partDesc, "catalogitem.page?", "\"");
                color = 0;
                int colPos = itemWithColor.indexOf("&idColor=");
                if (colPos < 0) {
                    part = itemWithColor.substring(2);
                } else {
                    part = itemWithColor.substring(2, colPos);
                    try {
                        color = Integer.parseInt(itemWithColor.substring(colPos + 9));
                    }
                    catch (NumberFormatException e) {
                        if (logger == null) break block11;
                        logger.log("Bricklink part: unexpected color id in itemWithColor " + itemWithColor);
                    }
                }
            }
            amountStr = LDIBricklink.getDelimitedCleanedString(partDesc, "<TD ALIGN=\"RIGHT\">&nbsp;", "&nbsp;");
            amount = 1;
            try {
                amount = Integer.parseInt(amountStr);
            }
            catch (NumberFormatException e) {
                if (logger == null) break block12;
                logger.log("Bricklink part: unexpected amount " + amountStr);
            }
        }
        String img = LDIBricklink.getDelimitedCleanedString(partDesc, "SRC='", "'");
        String subCat = LDIBricklink.getDelimitedCleanedString(partDesc, "catalogItemInv.asp?", "\"");
        if (desc == null || desc.length() == 0 || itemWithColor == null || itemWithColor.length() == 0 || amountStr == null || amountStr.length() == 0) {
            if (logger != null) {
                logger.log("Bricklink part: no name/item/color/amount in line " + partDesc);
            }
            return;
        }
        LDIExternalActionResult ear = new LDIExternalActionResult(String.valueOf(amountStr) + "x " + part + (color != -1 ? " in " + color : "") + ": " + desc);
        res.add(ear);
        if (img != null && img.length() > 0) {
            ear.actions.add(new LDIEAImage(img));
        }
        if (subCat != null && subCat.length() > 0) {
            ear.actions.add(new LDIEABricklinkInventory(subCat));
        }
        if (part != null) {
            LDICColor col;
            int colId = color == 0 ? 16 : ((col = ctx.getColorByFirstHintId(color, LDICColorHintSource.BRICKLINK)) == null ? 16 : col.id);
            ear.actions.add(new LDIEAPart(String.valueOf(part) + ".dat", desc, colId, amount));
        }
    }

    private static String httpCleanup(String data) {
        data = data.replaceAll("\\+", "%2B");
        data = data.replaceAll("\\\\", "%5C");
        data = data.replaceAll("\\/", "%2F");
        data = data.replaceAll("\\&", "%26");
        data = data.replace(' ', '+');
        return data;
    }

    private static String getDelimitedCleanedString(String data, String before, String after) {
        int start = data.indexOf(before);
        if (start == -1) {
            return null;
        }
        int end = data.indexOf(after, start += before.length());
        if (end == -1) {
            return null;
        }
        return LDIBricklink.entityCleanup(data.substring(start, end).trim());
    }

    private static String entityCleanup(String data) {
        int pos = 0;
        while ((pos = data.indexOf("&#", pos)) != -1) {
            int len;
            if (data.charAt(pos + 4) == ';') {
                len = 2;
            } else if (data.charAt(pos + 5) == ';') {
                len = 3;
            } else {
                pos += 2;
                continue;
            }
            String nr = data.substring(pos + 2, pos + 2 + len);
            try {
                char c = (char)Integer.parseInt(nr);
                data = String.valueOf(data.substring(0, pos)) + c + data.substring(pos + len + 3);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return data;
    }
}

