/*
 * Decompiled with CFR 0.152.
 */
package ldinsp.data;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import ldinsp.base.LDILogger;
import ldinsp.context.LDIContext;
import ldinsp.data.LDIDExplicitItem;
import ldinsp.data.LDIDPartList;
import ldinsp.data.LDIData;
import ldinsp.data.LDIDataSaveable;
import ldinsp.ext.LDIPbgFiles;
import ldinsp.ext.LDIXmlFiles;
import ldinsp.ldraw.LDrawFiles;
import ldinsp.ldraw.LDrawPart;
import ldinsp.ldraw.LDrawPartOrigin;

public class LDIDFile
implements LDIDataSaveable {
    private String filename;
    private FType type = FType.UNLOADED;
    private LDILogger logger;
    private LDIData target;

    public static boolean canHandle(String filename) {
        return LDIDFile.getFType(filename.toLowerCase()) != FType.INVALID;
    }

    public LDIDFile() {
    }

    public LDIDFile(String ifilename, LDILogger ilogger) {
        this.filename = ifilename;
        this.logger = ilogger;
    }

    @Override
    public String getSaveString() {
        return this.filename;
    }

    @Override
    public boolean needsSubPartSaving() {
        return false;
    }

    @Override
    public void restoreFromSaveString(int colId, int amount, String data, LDILogger ilogger) {
        this.filename = data;
        this.logger = ilogger;
        this.refresh();
    }

    @Override
    public boolean restoreSubElements(List<LDIData> subs, LDILogger ilogger) {
        return false;
    }

    @Override
    public void refresh() {
        this.type = FType.UNLOADED;
        this.target = null;
    }

    @Override
    public boolean isRenameable() {
        return false;
    }

    @Override
    public void setName(String name) {
    }

    @Override
    public String getName() {
        return this.getLeafFilename();
    }

    @Override
    public String getDescription(LDIContext ctx) {
        if (this.type == FType.UNLOADED) {
            this.loadFile(ctx);
        }
        if (this.target != null) {
            return this.target.getDescription(ctx);
        }
        return null;
    }

    @Override
    public boolean isRenderable(LDIContext ctx) {
        if (this.type == FType.UNLOADED) {
            this.loadFile(ctx);
        }
        if (this.target != null) {
            return this.target.isRenderable(ctx);
        }
        return false;
    }

    @Override
    public LDrawPart getPart(LDIContext ctx) {
        if (this.type == FType.UNLOADED) {
            this.loadFile(ctx);
        }
        if (this.target != null) {
            return this.target.getPart(ctx);
        }
        return null;
    }

    @Override
    public LDIDPartList getPartList(LDIContext ctx) {
        if (this.type == FType.UNLOADED) {
            this.loadFile(ctx);
        }
        if (this.target != null) {
            if (this.target instanceof LDIDPartList) {
                return (LDIDPartList)this.target;
            }
            return this.target.getPartList(ctx);
        }
        return null;
    }

    @Override
    public boolean isAdjustable() {
        return false;
    }

    @Override
    public void setColId(int col) {
    }

    @Override
    public int getColId() {
        return -1;
    }

    @Override
    public void setAmount(int amount) {
    }

    @Override
    public int getAmount() {
        return 0;
    }

    @Override
    public LDrawPartOrigin getPartOrigin(LDIContext ctx) {
        if (this.type == FType.UNLOADED) {
            this.loadFile(ctx);
        }
        if (this.target != null) {
            return this.target.getPartOrigin(ctx);
        }
        return null;
    }

    @Override
    public boolean hasSubElements(LDIContext ctx) {
        return true;
    }

    @Override
    public List<? extends LDIData> getSubElements(LDIContext ctx) {
        if (this.type == FType.UNLOADED) {
            this.loadFile(ctx);
        }
        if (this.target != null) {
            return this.target.getSubElements(ctx);
        }
        return null;
    }

    public void rebuildWithoutRefresh() {
        this.target.refresh();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean reexport(LDIContext ctx, String targetFilename) {
        if (this.target == null) {
            this.logger.log("file to reexport was not loaded");
            return false;
        }
        if (targetFilename == null) {
            targetFilename = this.filename;
        }
        try {
            PrintWriter pw;
            switch (this.type) {
                case MPD: 
                case LDR: 
                case DAT: {
                    pw = new PrintWriter(new FileWriter(targetFilename));
                    LDrawPart part = this.target.getPart(ctx);
                    LDrawFiles.writePart(part, pw);
                    break;
                }
                case PBG: {
                    pw = new PrintWriter(new FileWriter(targetFilename));
                    LDIDPartList pl = this.target.getPartList(ctx);
                    LDIPbgFiles.writeList(pl, pw);
                    break;
                }
                case XML: {
                    pw = new PrintWriter(new FileWriter(targetFilename));
                    LDIDPartList pl = this.target.getPartList(ctx);
                    LDIXmlFiles.writeList(pl, pw, ctx, this.logger);
                    break;
                }
                default: {
                    this.logger.log("unknown file type to reexport");
                    return false;
                }
            }
            pw.close();
            return true;
        }
        catch (IOException e) {
            this.logger.log("error reexporting file " + targetFilename + ": " + e.getClass().getName() + ": " + e.getMessage());
            return false;
        }
    }

    private void loadFile(LDIContext ctx) {
        try {
            BufferedReader br = new BufferedReader(new FileReader(this.filename));
            String lowerCaseFilename = this.filename.toLowerCase();
            FType tmpType = LDIDFile.getFType(lowerCaseFilename);
            String name = this.getLeafFilename();
            switch (tmpType) {
                case MPD: 
                case LDR: 
                case DAT: {
                    this.target = new LDIDExplicitItem(name, LDrawFiles.parseDef(this.filename, br, LDrawPartOrigin.SELF, this.logger), -1, 1);
                    this.type = tmpType;
                    break;
                }
                case PBG: {
                    this.target = LDIPbgFiles.parseDef(name, br, this.logger);
                    this.type = FType.PBG;
                    break;
                }
                case XML: {
                    this.target = LDIXmlFiles.parseDef(name, br, ctx, this.logger);
                    this.type = FType.XML;
                    break;
                }
                default: {
                    this.type = FType.INVALID;
                }
            }
            br.close();
        }
        catch (IOException e) {
            this.logger.log("error loading file " + this.filename + ": " + e.getClass().getName() + ": " + e.getMessage());
            this.type = FType.INVALID;
        }
    }

    private String getLeafFilename() {
        int lastSlash = this.filename.lastIndexOf(47);
        if (lastSlash < 0) {
            return this.filename;
        }
        return this.filename.substring(lastSlash + 1);
    }

    private static FType getFType(String filename) {
        if (filename.endsWith(".mpd")) {
            return FType.MPD;
        }
        if (filename.endsWith(".ldr")) {
            return FType.LDR;
        }
        if (filename.endsWith(".dat")) {
            return FType.DAT;
        }
        if (filename.endsWith(".pbg")) {
            return FType.PBG;
        }
        if (filename.endsWith(".xml")) {
            return FType.XML;
        }
        return FType.INVALID;
    }

    public static enum FType {
        MPD,
        LDR,
        DAT,
        PBG,
        XML,
        INVALID,
        UNLOADED;

    }
}

