/*
 * Decompiled with CFR 0.152.
 */
package ldinsp.data;

import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import ldinsp.base.LDILogger;
import ldinsp.context.LDIContext;
import ldinsp.data.LDIDFile;
import ldinsp.data.LDIDPartList;
import ldinsp.data.LDIData;
import ldinsp.data.LDIDataSaveable;
import ldinsp.ldraw.LDrawPart;
import ldinsp.ldraw.LDrawPartOrigin;
import ldinsp.util.StringNumberComparator;

public class LDIDDirectory
implements LDIDataSaveable {
    private String dirname;
    private LDILogger logger;
    private ArrayList<LDIData> targets;
    private static final Comparator<LDIData> SORT_ALPHA = new Comparator<LDIData>(){

        @Override
        public int compare(LDIData o1, LDIData o2) {
            String cufn1 = o1.getName();
            String cufn2 = o2.getName();
            int pos = cufn1.lastIndexOf(47);
            if (pos > 0) {
                cufn1 = cufn1.substring(pos + 1);
            }
            if ((pos = cufn2.lastIndexOf(47)) > 0) {
                cufn2 = cufn2.substring(pos + 1);
            }
            return StringNumberComparator.compare(cufn1, cufn2);
        }
    };

    public LDIDDirectory() {
    }

    public LDIDDirectory(String idirname, LDILogger ilogger) {
        this.dirname = idirname;
        this.logger = ilogger;
    }

    @Override
    public String getSaveString() {
        return this.dirname;
    }

    @Override
    public boolean needsSubPartSaving() {
        return false;
    }

    @Override
    public void restoreFromSaveString(int colId, int amount, String data, LDILogger ilogger) {
        this.dirname = data;
        this.logger = ilogger;
        this.refresh();
    }

    @Override
    public boolean restoreSubElements(List<LDIData> subs, LDILogger ilogger) {
        return false;
    }

    @Override
    public void refresh() {
        this.targets = null;
    }

    @Override
    public boolean isRenameable() {
        return false;
    }

    @Override
    public void setName(String name) {
    }

    @Override
    public String getName() {
        return this.getReducedDirname();
    }

    @Override
    public String getDescription(LDIContext ctx) {
        return this.getReducedDirname();
    }

    @Override
    public boolean isRenderable(LDIContext ctx) {
        return false;
    }

    @Override
    public LDrawPart getPart(LDIContext ctx) {
        return null;
    }

    @Override
    public LDIDPartList getPartList(LDIContext ctx) {
        return null;
    }

    @Override
    public boolean isAdjustable() {
        return false;
    }

    @Override
    public void setColId(int col) {
    }

    @Override
    public int getColId() {
        return -1;
    }

    @Override
    public void setAmount(int amount) {
    }

    @Override
    public int getAmount() {
        return 0;
    }

    @Override
    public LDrawPartOrigin getPartOrigin(LDIContext ctx) {
        return null;
    }

    @Override
    public boolean hasSubElements(LDIContext ctx) {
        return true;
    }

    public List<LDIData> getSubElements(LDIContext ctx) {
        if (this.targets == null) {
            this.loadDir();
        }
        return this.targets;
    }

    private void loadDir() {
        File[] files;
        if (this.targets != null) {
            return;
        }
        this.targets = new ArrayList();
        File f = new File(this.dirname);
        ArrayList<LDIData> dta = new ArrayList<LDIData>();
        ArrayList<LDIData> fta = new ArrayList<LDIData>();
        if (f.isDirectory() && (files = f.listFiles()) != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File c = fileArray[n2];
                String fn = c.getAbsolutePath();
                if (!c.getName().startsWith(".")) {
                    if (c.isFile()) {
                        if (LDIDFile.canHandle(fn)) {
                            fta.add(new LDIDFile(fn, this.logger));
                        }
                    } else if (c.isDirectory()) {
                        dta.add(new LDIDDirectory(fn, this.logger));
                    }
                }
                ++n2;
            }
        }
        dta.sort(SORT_ALPHA);
        fta.sort(SORT_ALPHA);
        this.targets.addAll(dta);
        this.targets.addAll(fta);
    }

    private String getReducedDirname() {
        if (this.dirname.length() < 20) {
            return this.dirname;
        }
        int lastSlash = this.dirname.lastIndexOf(47);
        if (lastSlash < 0) {
            return this.dirname;
        }
        return "..." + this.dirname.substring(lastSlash);
    }
}

