/*
 * Decompiled with CFR 0.152.
 */
package ldinsp.context;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import ldinsp.base.LDILogger;
import ldinsp.context.LDICFile;
import ldinsp.ldraw.LDrawFiles;
import ldinsp.ldraw.LDrawPart;
import ldinsp.ldraw.LDrawPartOrigin;

public class LDICPDir
extends LDICFile {
    public static final String TYPE = "Directory";
    private final String base;

    public LDICPDir(String ibase, LDrawPartOrigin iorigin) {
        super(iorigin);
        this.base = ibase.endsWith("/") ? ibase : String.valueOf(ibase) + "/";
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public String getDest() {
        return this.base;
    }

    @Override
    LDrawPart loadPartFromFile(String name, LDILogger logger) throws IOException {
        File file = new File(String.valueOf(this.base) + "parts/" + name);
        if (!(file.isFile() || (file = new File(String.valueOf(this.base) + "p/" + name)).isFile() || (file = new File(String.valueOf(this.base) + name)).isFile())) {
            return null;
        }
        BufferedReader br = new BufferedReader(new FileReader(file));
        LDrawPart me = LDrawFiles.parseDef(file.getName(), br, this.origin, logger);
        br.close();
        return me;
    }

    @Override
    public void addAllPartHeaders(ArrayList<LDrawPart> list, LDILogger logger) {
        File[] files;
        File dir = new File(String.valueOf(this.base) + "parts/");
        if (!(dir.isDirectory() || (dir = new File(String.valueOf(this.base) + "p/")).isDirectory() || (dir = new File(this.base)).isDirectory())) {
            return;
        }
        File[] fileArray = files = dir.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            block5: {
                File file = fileArray[n2];
                if (!file.isDirectory()) {
                    try {
                        BufferedReader br = new BufferedReader(new FileReader(file));
                        LDrawPart me = LDrawFiles.parseDef(file.getName(), br, this.origin, logger, true);
                        br.close();
                        list.add(me);
                    }
                    catch (IOException e) {
                        if (logger == null) break block5;
                        logger.log("addAll-Dir had I/O exception: " + e.getClass().getName() + ": " + e.getMessage());
                    }
                }
            }
            ++n2;
        }
    }
}

