/*
 * Decompiled with CFR 0.152.
 */
package ldinsp.colldet;

import ldinsp.colldet.Tri;
import ldinsp.colldet.UnexpectedCaseException;
import ldinsp.ldraw.LDrawPoint;

class Line {
    private final LDrawPoint point;
    private final LDrawPoint direction;
    private static final double TOL = 1.0E-4;

    protected Line(Tri face1, Tri face2) throws UnexpectedCaseException {
        double nz;
        double ny;
        double nx;
        LDrawPoint normalFace1 = face1.normal;
        LDrawPoint normalFace2 = face2.normal;
        LDrawPoint cross = normalFace1.cross(normalFace2);
        if (cross.length() < 1.0E-4) {
            throw new UnexpectedCaseException("faces are coplanar");
        }
        double d1 = -normalFace1.dot(face1.v1);
        double d2 = -normalFace2.dot(face2.v1);
        if (Math.abs(cross.x) > 1.0E-4) {
            nx = 0.0;
            ny = (d2 * normalFace1.z - d1 * normalFace2.z) / cross.x;
            nz = (d1 * normalFace2.y - d2 * normalFace1.y) / cross.x;
        } else if (Math.abs(cross.y) > 1.0E-4) {
            nx = (d1 * normalFace2.z - d2 * normalFace1.z) / cross.y;
            ny = 0.0;
            nz = (d2 * normalFace1.x - d1 * normalFace2.x) / cross.y;
        } else {
            nx = (d2 * normalFace1.y - d1 * normalFace2.y) / cross.z;
            ny = (d1 * normalFace2.x - d2 * normalFace1.x) / cross.z;
            nz = 0.0;
        }
        this.point = new LDrawPoint(nx, ny, nz);
        this.direction = cross.normalize();
    }

    protected Line(LDrawPoint idirection, LDrawPoint ipoint) {
        this.direction = idirection;
        this.point = ipoint;
        idirection.normalize();
    }

    protected double computePointToPointDistance(LDrawPoint otherPoint) {
        double distance = otherPoint.distance(this.point);
        LDrawPoint vec = otherPoint.subtract(this.point).normalize();
        if (vec.dot(this.direction) < 0.0) {
            return -distance;
        }
        return distance;
    }

    protected LDrawPoint computeLineIntersection(Line otherLine) {
        double t;
        LDrawPoint linePoint = otherLine.point;
        LDrawPoint lineDirection = otherLine.direction;
        if (Math.abs(this.direction.y * lineDirection.x - this.direction.x * lineDirection.y) > 1.0E-4) {
            t = (-this.point.y * lineDirection.x + linePoint.y * lineDirection.x + lineDirection.y * this.point.x - lineDirection.y * linePoint.x) / (this.direction.y * lineDirection.x - this.direction.x * lineDirection.y);
        } else if (Math.abs(-this.direction.x * lineDirection.z + this.direction.z * lineDirection.x) > 1.0E-4) {
            t = -(-lineDirection.z * this.point.x + lineDirection.z * linePoint.x + lineDirection.x * this.point.z - lineDirection.x * linePoint.z) / (-this.direction.x * lineDirection.z + this.direction.z * lineDirection.x);
        } else if (Math.abs(-this.direction.z * lineDirection.y + this.direction.y * lineDirection.z) > 1.0E-4) {
            t = (this.point.z * lineDirection.y - linePoint.z * lineDirection.y - lineDirection.z * this.point.y + lineDirection.z * linePoint.y) / (-this.direction.z * lineDirection.y + this.direction.y * lineDirection.z);
        } else {
            return null;
        }
        return new LDrawPoint(this.point.x + this.direction.x * t, this.point.y + this.direction.y * t, this.point.z + this.direction.z * t);
    }
}

