/*
 * Decompiled with CFR 0.152.
 */
package ldinsp.check;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import ldinsp.base.LDIWorker;
import ldinsp.check.LDICheck;
import ldinsp.check.LDICheckMessage;
import ldinsp.check.LDICheckSolve;
import ldinsp.check.LDICheckSolveHint;
import ldinsp.check.LDICheckState;
import ldinsp.context.LDIContext;
import ldinsp.ldraw.LDrawLine;
import ldinsp.ldraw.LDrawLinePartRef;
import ldinsp.ldraw.LDrawPart;

public class LDICMirroredParts
extends LDICheck {
    private static final int LINES_PER_PART = 3;
    private LDICheckState resState = LDICheckState.OK;
    private String resShort;
    private String resLong;
    private HashMap<LDrawLine, ArrayList<LDICheckMessage>> partErrors;
    private ArrayList<LDICheckSolve> solver;

    public LDICMirroredParts(LDIContext ctx, LDrawPart part) {
        if (this.isDat(part)) {
            this.resState = LDICheckState.IGN;
            this.resShort = " ign : file ends with .dat and is therefore not checked for mirrored parts\n";
            this.resLong = "";
            return;
        }
        StringBuffer lrsb = new StringBuffer();
        this.checkPart(ctx, part, lrsb);
        if (part.subParts != null) {
            for (LDrawPart sb : part.subParts) {
                if (this.isDat(sb)) continue;
                this.checkPart(ctx, sb, lrsb);
            }
        }
        if (this.resState == LDICheckState.OK) {
            this.resShort = "  ok : no mirrored parts\n";
        } else {
            this.resShort = "error: contains mirrored parts\n";
            this.solver = new ArrayList();
            this.solver.add(new LDICheckSolveHint("Mirrored", "Replace mirrored parts by un-mirrored ones"));
        }
        this.resLong = lrsb.toString();
    }

    @Override
    public LDICheckState getState() {
        return this.resState;
    }

    @Override
    public String getShortResult() {
        return this.resShort;
    }

    @Override
    public String getLongResult() {
        return this.resLong;
    }

    @Override
    public List<LDICheckSolve> getSolver() {
        return this.solver;
    }

    @Override
    public HashMap<LDrawLine, ArrayList<LDICheckMessage>> getPartErrors() {
        return this.partErrors;
    }

    private boolean isDat(LDrawPart part) {
        return part.loadedFromFilename != null && part.loadedFromFilename.toLowerCase().endsWith(".dat") || part.givenFilename != null && part.givenFilename.toLowerCase().endsWith(".dat");
    }

    private void checkPart(LDIContext ctx, LDrawPart part, StringBuffer lrsb) {
        final HashMap mirrored = new HashMap();
        LDIWorker w = new LDIWorker(){

            @Override
            public LDrawPart handlePartRef(LDrawLinePartRef ref, String partName, int colId, int pcol) {
                if (ref.trans.det < 0.0) {
                    ArrayList<Integer> list = (ArrayList<Integer>)mirrored.get(partName);
                    if (list == null) {
                        list = new ArrayList<Integer>();
                        mirrored.put(partName, list);
                    }
                    list.add(ref.lineNr);
                    LDICMirroredParts.this.partErrors = LDICMirroredParts.addPartError(LDICMirroredParts.this.partErrors, ref, "mirrored", 4);
                }
                return null;
            }
        };
        w.work(part);
        if (mirrored.size() > 0) {
            this.resState = LDICheckState.ERROR;
            for (String partName : mirrored.keySet()) {
                ArrayList list = (ArrayList)mirrored.get(partName);
                lrsb.append("part " + partName + " reference in " + part.getBestFilename() + " is mirrored ");
                if (list.size() == 1) {
                    lrsb.append("in line " + (Integer)list.get(0) + "\n");
                    continue;
                }
                list.sort((o1, o2) -> o1.compareTo((Integer)o2));
                lrsb.append("in lines: ");
                lrsb.append((Integer)list.get(0));
                int i = 1;
                while (i < list.size() && i < 3) {
                    lrsb.append(", " + (Integer)list.get(i));
                    ++i;
                }
                if (list.size() > 3) {
                    lrsb.append(", and another " + (list.size() - 3) + " more lines\n");
                    continue;
                }
                lrsb.append("\n");
            }
        }
    }
}

