/*
 * Decompiled with CFR 0.152.
 */
package ldinsp.check;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import ldinsp.check.LDICheck;
import ldinsp.check.LDICheckMessage;
import ldinsp.check.LDICheckSolve;
import ldinsp.check.LDICheckSolveFix;
import ldinsp.check.LDICheckState;
import ldinsp.context.LDIContext;
import ldinsp.ldraw.LDrawEdit;
import ldinsp.ldraw.LDrawLine;
import ldinsp.ldraw.LDrawLineOther;
import ldinsp.ldraw.LDrawPart;

public class LDICDispensableMeta
extends LDICheck {
    private static final int LINES_PER_PART = 3;
    private LDICheckState resState = LDICheckState.OK;
    private String resShort;
    private String resLong;
    private ArrayList<LDICheckSolve> solver;

    public LDICDispensableMeta(LDIContext ctx, final LDrawPart part) {
        final ArrayList<LDrawLine> remove = new ArrayList<LDrawLine>();
        HashMap<String, ArrayList<Integer>> disp = new HashMap<String, ArrayList<Integer>>();
        this.checkPart(part, remove, disp);
        if (part.subParts != null) {
            for (LDrawPart sb : part.subParts) {
                this.checkPart(sb, remove, disp);
            }
        }
        if (this.resState == LDICheckState.OK) {
            this.resShort = "  ok : no dispensable meta lines found\n";
        } else {
            this.resShort = " hint: maybe at least one meta line is dispensable\n";
            this.solver = new ArrayList();
            this.solver.add(new LDICheckSolveFix("Disp.Meta", "Remove dispensable meta lines"){

                @Override
                public int fix() {
                    return LDrawEdit.removeLines(part, remove);
                }
            });
        }
        if (disp.size() > 0) {
            this.resState = LDICheckState.HINT;
            StringBuffer lrsb = new StringBuffer();
            for (String meta : disp.keySet()) {
                ArrayList<Integer> list = disp.get(meta);
                lrsb.append("hint: perhaps meta " + meta + " is dispensable ");
                if (list.size() == 1) {
                    lrsb.append("in line " + list.get(0) + "\n");
                    continue;
                }
                list.sort((o1, o2) -> o1.compareTo((Integer)o2));
                lrsb.append("in lines: ");
                lrsb.append(list.get(0));
                int i = 1;
                while (i < list.size() && i < 3) {
                    lrsb.append(", " + list.get(i));
                    ++i;
                }
                if (list.size() > 3) {
                    lrsb.append(", and another " + (list.size() - 3) + " more lines\n");
                    continue;
                }
                lrsb.append("\n");
            }
            this.resLong = lrsb.toString();
        } else {
            this.resLong = "";
        }
    }

    @Override
    public LDICheckState getState() {
        return this.resState;
    }

    @Override
    public String getShortResult() {
        return this.resShort;
    }

    @Override
    public String getLongResult() {
        return this.resLong;
    }

    @Override
    public List<LDICheckSolve> getSolver() {
        return this.solver;
    }

    @Override
    public HashMap<LDrawLine, ArrayList<LDICheckMessage>> getPartErrors() {
        return null;
    }

    private void checkPart(LDrawPart part, ArrayList<LDrawLine> remove, HashMap<String, ArrayList<Integer>> disp) {
        int startIndex = 0;
        if (LDICDispensableMeta.isFile(part, startIndex)) {
            ++startIndex;
        }
        boolean allowMeta = false;
        int i = startIndex;
        while (i < part.content.size()) {
            allowMeta = this.checkLine(part.content.get(i), allowMeta, remove, disp);
            ++i;
        }
    }

    private boolean checkLine(LDrawLine l, boolean allowMeta, ArrayList<LDrawLine> remove, HashMap<String, ArrayList<Integer>> disp) {
        int firstSpace;
        if (l.source.length() == 0) {
            return allowMeta;
        }
        if (!l.source.startsWith("0 ") || !(l instanceof LDrawLineOther)) {
            return true;
        }
        String meta = l.source.substring(2).trim();
        if (!allowMeta) {
            if (!meta.startsWith("!")) {
                return true;
            }
        } else {
            allowMeta = true;
            String lcmeta = meta.toLowerCase();
            if (lcmeta.startsWith("name: ") || lcmeta.startsWith("author: ") || lcmeta.startsWith("unofficial ") || lcmeta.startsWith("//") || lcmeta.startsWith("!") || lcmeta.startsWith("nofile")) {
                return true;
            }
        }
        if ((firstSpace = meta.indexOf(32)) > 0 && firstSpace < 20) {
            meta = meta.substring(0, firstSpace);
        } else if (meta.length() > 20) {
            meta = meta.substring(0, 20);
        }
        ArrayList<Integer> list = disp.get(meta);
        if (list == null) {
            list = new ArrayList();
            disp.put(meta, list);
        }
        list.add(l.lineNr);
        remove.add(l);
        return allowMeta;
    }

    private static boolean isFile(LDrawPart part, int nr) {
        String loli;
        return nr < part.content.size() && (loli = part.content.get((int)nr).source.toLowerCase()).startsWith("0 file ");
    }
}

