/*
 * Decompiled with CFR 0.152.
 */
package ldinsp.check;

import java.util.ArrayList;
import java.util.List;
import ldinsp.base.LDIWorker;
import ldinsp.check.LDICheck;
import ldinsp.check.LDICheckSolve;
import ldinsp.check.LDICheckSolveHint;
import ldinsp.check.LDICheckState;
import ldinsp.context.LDIContext;
import ldinsp.ldraw.LDrawLineBfcCmd;
import ldinsp.ldraw.LDrawLineLine;
import ldinsp.ldraw.LDrawLinePartRef;
import ldinsp.ldraw.LDrawLineQuad;
import ldinsp.ldraw.LDrawLineTri;
import ldinsp.ldraw.LDrawPart;
import ldinsp.ldraw.LDrawPoint;

public class LDICBfcs
extends LDICheck {
    private LDICheckState resState = LDICheckState.OK;
    private String resShort;
    private String resLong;
    private ArrayList<LDICheckSolve> solver;

    public LDICBfcs(LDIContext ctx, LDrawPart part) {
        StringBuffer lrsb = new StringBuffer();
        this.checkPart(ctx, part, lrsb);
        if (part.subParts != null) {
            for (LDrawPart sb : part.subParts) {
                this.checkPart(ctx, sb, lrsb);
            }
        }
        if (this.resState == LDICheckState.OK) {
            this.resShort = "  ok : all BFC commands are valid\n";
        } else {
            this.resShort = "error: at least one BFC command is invalid\n";
            this.solver = new ArrayList();
            this.solver.add(new LDICheckSolveHint("BFC", "BFC errors are not solveable automatically with LDInspector"));
        }
        this.resLong = lrsb.toString();
    }

    @Override
    public LDICheckState getState() {
        return this.resState;
    }

    @Override
    public String getShortResult() {
        return this.resShort;
    }

    @Override
    public String getLongResult() {
        return this.resLong;
    }

    @Override
    public List<LDICheckSolve> getSolver() {
        return this.solver;
    }

    private void checkPart(LDIContext ctx, LDrawPart part, final StringBuffer lrsb) {
        final boolean isDat = part.loadedFromFilename != null && part.loadedFromFilename.toLowerCase().endsWith(".dat") || part.givenFilename != null && part.givenFilename.toLowerCase().endsWith(".dat");
        LDIWorker w = new LDIWorker(){

            @Override
            public void handleInvertNext(LDrawLineBfcCmd cmd) {
                super.handleInvertNext(cmd);
                if (!isDat) {
                    LDICBfcs.this.resState = LDICheckState.ERROR;
                    lrsb.append("BFC INVERTNEXT is only allowed inside .dat files\n");
                }
            }

            @Override
            public void handleLine(LDrawLineLine line, LDrawPoint t1, LDrawPoint t2, int colId, int pcol) {
                if (this.getInvertNext()) {
                    LDICBfcs.this.resState = LDICheckState.ERROR;
                    lrsb.append("BFC INVERTNEXT is only not allowed before drawLine statement\n");
                }
            }

            @Override
            public void handleTri(LDrawLineTri tri, LDrawPoint t1, LDrawPoint t2, LDrawPoint t3, int colId, int pcol) {
                if (this.getInvertNext()) {
                    LDICBfcs.this.resState = LDICheckState.ERROR;
                    lrsb.append("BFC INVERTNEXT is only not allowed before drawTri statement\n");
                }
            }

            @Override
            public void handleQuad(LDrawLineQuad quad, LDrawPoint t1, LDrawPoint t2, LDrawPoint t3, LDrawPoint t4, int colId, int pcol) {
                if (this.getInvertNext()) {
                    LDICBfcs.this.resState = LDICheckState.ERROR;
                    lrsb.append("BFC INVERTNEXT is only not allowed before drawQuad statement\n");
                }
            }

            @Override
            public LDrawPart handlePartRef(LDrawLinePartRef ref, String partName, int colId, int pcol) {
                return null;
            }
        };
        w.work(part);
    }
}

