/*
 * Decompiled with CFR 0.152.
 */
package ldinsp.tools;

import ldinsp.LDInspector;
import ldinsp.base.LDILogger;
import ldinsp.check.LDICAll;
import ldinsp.context.LDICColor;
import ldinsp.context.LDIContext;
import ldinsp.data.LDIDFile;
import ldinsp.ldraw.LDrawPart;

public class LDITFileChecker
implements LDILogger {
    private LDIContext ctx;

    public static void checkFiles(String[] filenames) {
        if (filenames == null || filenames.length == 0) {
            System.out.println("LDITFileChecker/LDInspector version: " + LDInspector.version);
            System.out.println("LDITFileChecker: please specify file(s) to check");
            return;
        }
        LDITFileChecker me = new LDITFileChecker();
        me.doCheckFiles(filenames);
    }

    @Override
    public void log(String text) {
        System.out.println(text);
    }

    private void doCheckFiles(String[] filenames) {
        LDrawPart wsp = LDIContext.loadDefaultContextFile();
        this.ctx = null;
        if (wsp != null) {
            this.ctx = LDIContext.load(wsp, null);
        }
        if (this.ctx == null) {
            this.ctx = new LDIContext();
            this.ctx.addReplaceAllColors(LDICColor.getPredefinedColors());
        }
        String[] stringArray = filenames;
        int n = filenames.length;
        int n2 = 0;
        while (n2 < n) {
            String f = stringArray[n2];
            LDIDFile data = new LDIDFile(f, this);
            LDrawPart part = data.getPart(this.ctx);
            if (part != null) {
                LDICAll c = new LDICAll(this.ctx, part);
                System.out.println(c.getShortResult());
                System.out.println(c.getLongResult());
            }
            ++n2;
        }
    }
}

