/*
 * Decompiled with CFR 0.152.
 */
package ldinsp.ldraw;

public class LDrawPoint {
    public final double x;
    public final double y;
    public final double z;

    public LDrawPoint(double ix, double iy, double iz) {
        this.x = ix;
        this.y = iy;
        this.z = iz;
    }

    public LDrawPoint subtract(LDrawPoint o) {
        return new LDrawPoint(this.x - o.x, this.y - o.y, this.z - o.z);
    }

    public LDrawPoint cross(LDrawPoint o) {
        return new LDrawPoint(this.y * o.z - this.z * o.y, this.z * o.x - this.x * o.z, this.x * o.y - this.y * o.x);
    }

    public double dot(LDrawPoint o) {
        return this.x * o.x + this.y * o.y + this.z * o.z;
    }

    public LDrawPoint midTo(LDrawPoint o) {
        return new LDrawPoint((this.x + o.x) / 2.0, (this.y + o.y) / 2.0, (this.z + o.z) / 2.0);
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public double distance(LDrawPoint o) {
        double dx = this.x - o.x;
        double dy = this.y - o.y;
        double dz = this.z - o.z;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public LDrawPoint normalize() {
        double len = this.length();
        return new LDrawPoint(this.x / len, this.y / len, this.z / len);
    }

    public double angle(LDrawPoint o) {
        double vDot = this.dot(o) / (this.length() * o.length());
        if (vDot < -1.0) {
            vDot = -1.0;
        }
        if (vDot > 1.0) {
            vDot = 1.0;
        }
        return Math.acos(vDot);
    }

    public double get(int ind) {
        switch (ind) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
        }
        throw new IllegalArgumentException("index " + ind);
    }
}

