/*
 * Decompiled with CFR 0.152.
 */
package ldinsp.gui.view;

import java.util.ArrayList;
import java.util.HashSet;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.TreeItem;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import ldinsp.base.LDIWorkerRefWalk;
import ldinsp.data.LDIData;
import ldinsp.gui.LDIGui;
import ldinsp.gui.view.LDIVText;
import ldinsp.ldraw.LDrawPart;
import ldinsp.util.StringNumberComparator;

public class LDIVTUsedFiles
extends LDIVText {
    private final LDIGui main;
    private final Text statistics;
    private LDIData data;
    private boolean dataValid;
    private boolean isTabSelected;

    public LDIVTUsedFiles(LDIGui imain) {
        this.main = imain;
        this.setFont(Font.font((String)"monospace"));
        this.setClearDisable(true);
        this.setAutoscroll(false);
        this.addControl((Node)new Text("Count"));
        this.statistics = new Text("99999");
        this.addControl((Node)this.statistics);
    }

    @Override
    public void onTabSelection(boolean state) {
        if (!this.isTabSelected && state) {
            this.updateData();
        }
        this.isTabSelected = state;
    }

    @Override
    public void selUpdated(ObservableValue<? extends TreeItem<LDIData>> obs, TreeItem<LDIData> oldSel, TreeItem<LDIData> newSel, boolean active) {
        this.data = null;
        this.clear();
        if (newSel != null) {
            this.data = (LDIData)newSel.getValue();
            this.dataValid = false;
            if (this.isTabSelected) {
                this.updateData();
            }
        }
    }

    private void updateData() {
        if (this.dataValid) {
            return;
        }
        this.clear();
        this.dataValid = true;
        if (this.data == null) {
            this.statistics.setText("");
            return;
        }
        final LDrawPart part = this.data.getPart(this.main.ctx);
        if (part == null) {
            this.statistics.setText("");
            return;
        }
        final HashSet names = new HashSet();
        LDIWorkerRefWalk w = new LDIWorkerRefWalk(){

            @Override
            public LDrawPart usePart(String partName) {
                if (names.contains(partName)) {
                    return null;
                }
                names.add(partName);
                LDrawPart dest = null;
                if (part.subParts != null) {
                    for (LDrawPart sp : part.subParts) {
                        if (!sp.givenFilename.equalsIgnoreCase(partName)) continue;
                        dest = sp;
                        break;
                    }
                }
                if (dest == null) {
                    dest = LDIVTUsedFiles.this.main.ctx.getPart(part.owner, partName, LDIVTUsedFiles.this.main);
                }
                return dest;
            }
        };
        w.work(part);
        ArrayList usedParts = new ArrayList(names);
        usedParts.sort((o1, o2) -> StringNumberComparator.compare(o1, o2));
        this.statistics.setText(Integer.toString(usedParts.size()));
        for (String p : usedParts) {
            this.append(String.valueOf(p) + "\n");
        }
    }
}

