/*
 * Decompiled with CFR 0.152.
 */
package ldinsp.gui.view;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeItem;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.text.Text;
import javafx.util.Callback;
import javafx.util.StringConverter;
import ldinsp.base.LDILogger;
import ldinsp.context.LDICColor;
import ldinsp.context.LDICColorHint;
import ldinsp.context.LDIContext;
import ldinsp.data.LDIDFile;
import ldinsp.data.LDIDPartList;
import ldinsp.data.LDIData;
import ldinsp.ext.LDIObjExport;
import ldinsp.ext.LDIPartExport;
import ldinsp.gui.GuiHelper;
import ldinsp.gui.LDIGui;
import ldinsp.gui.view.LDIView;
import ldinsp.ldraw.LDrawLine;
import ldinsp.ldraw.LDrawPart;

public class LDIVItem
extends VBox
implements LDIView {
    private final LDIGui main;
    private final Button removeButton;
    private final Text removeText;
    private final Button refreshButton;
    private final HBox saveBox;
    private final TextField name;
    private final ComboBox<LDICColor> color;
    private final TextField amount;
    private final StackPane detailPane;
    private final BorderPane noDetailPane;
    private final VBox partPane;
    private final ComboBox<ExportType> exportType;
    private final Text partStatistics;
    private final TextArea header;
    private final VBox partListPane;
    private final Text partListStatistics;
    private final Button addPart;
    private final Button forceSortParts;
    private final Button exportAsPbg;
    private final Button exportAsXml;
    private boolean isTabSelected;
    private TreeItem<LDIData> item;
    private boolean inUpdate;

    public LDIVItem(LDIGui imain) {
        this.main = imain;
        this.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        this.setSpacing(10.0);
        HBox line = new HBox();
        line.setSpacing(10.0);
        line.setAlignment(Pos.CENTER_LEFT);
        this.getChildren().add((Object)line);
        this.removeButton = new Button("Remove item");
        this.removeButton.setOnAction(event -> this.main.removeItem(this.item));
        this.removeButton.setMaxHeight(Double.MAX_VALUE);
        line.getChildren().add((Object)this.removeButton);
        this.removeText = new Text();
        line.getChildren().add((Object)this.removeText);
        line = new HBox();
        line.setSpacing(10.0);
        line.setAlignment(Pos.CENTER_LEFT);
        this.getChildren().add((Object)line);
        this.refreshButton = new Button("Refresh item");
        this.refreshButton.setOnAction(event -> this.refreshItem());
        this.refreshButton.setMaxHeight(Double.MAX_VALUE);
        line.getChildren().add((Object)this.refreshButton);
        line.getChildren().add((Object)new Text("Refresh item (reload file, rescan directory...)"));
        this.saveBox = line = new HBox();
        line.setSpacing(10.0);
        line.setAlignment(Pos.CENTER_LEFT);
        this.getChildren().add((Object)line);
        Button button = new Button("Save item (overwrite)");
        button.setOnAction(event -> this.saveItem(false));
        button.setMaxHeight(Double.MAX_VALUE);
        button.setStyle("-fx-base: #F73F3F;");
        line.getChildren().add((Object)button);
        button = new Button("Save item as new file");
        button.setOnAction(event -> this.saveItem(true));
        button.setMaxHeight(Double.MAX_VALUE);
        button.setStyle("-fx-base: #F73F3F;");
        line.getChildren().add((Object)button);
        line.getChildren().add((Object)new Text("Save item after modification (see Edit or OMR-Check pane)"));
        line = new HBox();
        line.setSpacing(10.0);
        line.setAlignment(Pos.CENTER_LEFT);
        this.getChildren().add((Object)line);
        line.getChildren().add((Object)new Text("Name"));
        this.name = new TextField();
        this.name.setPrefWidth(200.0);
        this.name.textProperty().addListener((obs, oldVal, newVal) -> this.renameItem((String)newVal));
        HBox.setHgrow((Node)this.name, (Priority)Priority.ALWAYS);
        line.getChildren().add((Object)this.name);
        this.color = new ComboBox();
        this.color.setMaxHeight(Double.MAX_VALUE);
        this.color.setPrefWidth(200.0);
        HBox.setHgrow(this.color, (Priority)Priority.ALWAYS);
        this.color.setConverter((StringConverter)new StringConverter<LDICColor>(){

            public String toString(LDICColor c) {
                return c != null ? String.valueOf(Integer.toString(c.id)) + " " + c.name : "";
            }

            public LDICColor fromString(String string) {
                return null;
            }
        });
        this.color.setCellFactory((Callback)new Callback<ListView<LDICColor>, ListCell<LDICColor>>(){

            public ListCell<LDICColor> call(ListView<LDICColor> p) {
                return new ListCell<LDICColor>(){
                    private final Circle colPreview = new Circle(8.0, (Paint)Color.WHITE);

                    protected void updateItem(LDICColor colItem, boolean empty) {
                        super.updateItem((Object)colItem, empty);
                        if (colItem != null) {
                            this.colPreview.setFill((Paint)GuiHelper.rgbaToColor(colItem.rgbaFace));
                            this.setGraphic((Node)this.colPreview);
                            this.setText(String.valueOf(Integer.toString(colItem.id)) + " " + colItem.name);
                            this.setTooltip(colItem.hints != null ? new Tooltip(LDICColorHint.hintsToString(colItem.hints)) : null);
                        } else {
                            this.setText("");
                            this.setGraphic(null);
                            this.setTooltip(null);
                        }
                    }
                };
            }
        });
        this.color.getSelectionModel().selectedItemProperty().addListener((obs, oldVal, newVal) -> this.changeColor((LDICColor)newVal));
        line.getChildren().add(this.color);
        line.getChildren().add((Object)new Text("Amount"));
        this.amount = new TextField();
        this.amount.setPrefWidth(100.0);
        this.amount.textProperty().addListener((obs, oldVal, newVal) -> this.changeAmount((String)newVal));
        line.getChildren().add((Object)this.amount);
        this.detailPane = new StackPane();
        VBox.setVgrow((Node)this.detailPane, (Priority)Priority.ALWAYS);
        this.getChildren().add((Object)this.detailPane);
        line = new HBox();
        line.setSpacing(10.0);
        line.setAlignment(Pos.CENTER_LEFT);
        this.getChildren().add((Object)line);
        this.noDetailPane = new BorderPane();
        this.detailPane.getChildren().add((Object)this.noDetailPane);
        this.noDetailPane.setCenter((Node)new Text("No item selected or no details available for selected item."));
        this.partPane = new VBox();
        this.detailPane.getChildren().add((Object)this.partPane);
        line = new HBox();
        line.setSpacing(10.0);
        line.setPadding(new Insets(0.0, 0.0, 10.0, 0.0));
        line.setAlignment(Pos.CENTER_LEFT);
        this.partPane.getChildren().add((Object)line);
        line.getChildren().add((Object)new Text("File based export"));
        this.exportType = new ComboBox();
        this.exportType.getItems().addAll((Object[])ExportType.values());
        this.exportType.getSelectionModel().clearAndSelect(0);
        line.getChildren().add(this.exportType);
        button = new Button("Export");
        button.setOnAction(event -> this.exportObj());
        line.getChildren().add((Object)button);
        line = new HBox();
        line.setSpacing(10.0);
        line.setPadding(new Insets(0.0, 0.0, 10.0, 0.0));
        line.setAlignment(Pos.CENTER_LEFT);
        this.partPane.getChildren().add((Object)line);
        line.getChildren().add((Object)new Text("Header"));
        button = new Button("Copy to clipboard");
        button.setOnAction(event -> this.copyHeaderToClipboard());
        button.setMaxHeight(Double.MAX_VALUE);
        line.getChildren().add((Object)button);
        this.partStatistics = new Text("99999 lines in 9999 steps require 999 kb");
        line.getChildren().add((Object)this.partStatistics);
        this.header = new TextArea();
        this.header.setManaged(true);
        this.header.setEditable(false);
        this.header.setMaxHeight(Double.MAX_VALUE);
        VBox.setVgrow((Node)this.header, (Priority)Priority.ALWAYS);
        this.partPane.getChildren().add((Object)this.header);
        this.partListPane = new VBox();
        this.partListPane.setSpacing(10.0);
        VBox.setVgrow((Node)this.partListPane, (Priority)Priority.ALWAYS);
        this.detailPane.getChildren().add((Object)this.partListPane);
        line = new HBox();
        line.setSpacing(10.0);
        line.setAlignment(Pos.CENTER_LEFT);
        this.partListPane.getChildren().add((Object)line);
        line.getChildren().add((Object)new Text("This part list contains"));
        this.partListStatistics = new Text("9999 parts in 999 lots and 999 colors");
        line.getChildren().add((Object)this.partListStatistics);
        line = new HBox();
        line.setSpacing(10.0);
        line.setAlignment(Pos.CENTER_LEFT);
        this.partListPane.getChildren().add((Object)line);
        this.addPart = new Button("Add part");
        this.addPart.setOnAction(event -> this.addPartToPartList());
        line.getChildren().add((Object)this.addPart);
        line.getChildren().add((Object)new Text("Add a new, unnamed, uncolored part to the part list."));
        line = new HBox();
        line.setSpacing(10.0);
        line.setAlignment(Pos.CENTER_LEFT);
        this.partListPane.getChildren().add((Object)line);
        this.forceSortParts = new Button("Trigger part sort");
        this.forceSortParts.setOnAction(event -> this.forceSortPartsOfPartList());
        line.getChildren().add((Object)this.forceSortParts);
        line.getChildren().add((Object)new Text("After inserting new parts, it may be neccessary to trigger sorting."));
        line = new HBox();
        line.setSpacing(10.0);
        line.setAlignment(Pos.CENTER_LEFT);
        this.partListPane.getChildren().add((Object)line);
        this.exportAsPbg = new Button("Export as PBG");
        this.exportAsPbg.setOnAction(event -> this.exportPartListAsPbg());
        line.getChildren().add((Object)this.exportAsPbg);
        this.exportAsXml = new Button("Export as XML");
        this.exportAsXml.setOnAction(event -> this.exportPartListAsXml());
        line.getChildren().add((Object)this.exportAsXml);
        line.getChildren().add((Object)new Text("Export this part list for external processing."));
    }

    @Override
    public void contextChanged() {
        this.color.getItems().clear();
        this.color.getItems().addAll(this.main.ctx.getColors());
        this.color.getSelectionModel().select((Object)this.main.ctx.getColorById(0));
        this.refresh();
    }

    @Override
    public void invalidateItem(TreeItem<LDIData> invalid) {
    }

    @Override
    public void onTabSelection(boolean state) {
        if (!this.isTabSelected && state) {
            this.refresh();
        }
        this.isTabSelected = state;
    }

    @Override
    public void selUpdated(ObservableValue<? extends TreeItem<LDIData>> obs, TreeItem<LDIData> oldSel, TreeItem<LDIData> newSel, boolean active) {
        this.item = newSel;
        this.refresh();
    }

    private void refresh() {
        boolean editable;
        if (this.item == null) {
            this.partStatistics.setText("");
            this.removeButton.setDisable(true);
            this.removeText.setText("");
            this.refreshButton.setDisable(true);
            this.saveBox.setDisable(true);
            this.name.setEditable(false);
            this.name.setText("");
            this.color.setDisable(true);
            this.amount.setEditable(false);
            this.amount.setText("");
            this.noDetailPane.setVisible(true);
            this.partPane.setVisible(false);
            this.partListPane.setVisible(false);
            return;
        }
        this.refreshButton.setDisable(false);
        if (this.main.isRootItem(this.item)) {
            editable = true;
            this.removeText.setText("Remove this item from the current workspace.");
        } else if (this.main.getAsUnfixedPartList((TreeItem<LDIData>)this.item.getParent()) != null) {
            editable = true;
            this.removeText.setText("Remove this item from the parent part list.");
        } else {
            editable = false;
        }
        this.removeButton.setDisable(!editable);
        LDIData data = (LDIData)this.item.getValue();
        if (data == null) {
            this.saveBox.setDisable(true);
            this.partStatistics.setText("");
            this.name.setEditable(false);
            this.name.setText("");
            this.color.setDisable(true);
            this.amount.setEditable(false);
            this.amount.setText("");
            this.noDetailPane.setVisible(true);
            this.partPane.setVisible(false);
            this.partListPane.setVisible(false);
            return;
        }
        this.saveBox.setDisable(!(data instanceof LDIDFile));
        this.inUpdate = true;
        this.name.setEditable(editable && data.isRenameable());
        this.name.setText(data.getName());
        this.color.setDisable(!editable || !data.isAdjustable());
        this.color.getSelectionModel().clearSelection();
        LDICColor col = this.main.ctx.getColorById(data.getColId());
        if (col != null) {
            this.color.getSelectionModel().select((Object)col);
        } else {
            this.color.getSelectionModel().select(0);
        }
        this.amount.setEditable(editable && data.isAdjustable());
        this.amount.setText(Integer.toString(data.getAmount()));
        this.inUpdate = false;
        LDIDPartList pl = this.main.getAsPartList(this.item);
        if (pl != null) {
            this.noDetailPane.setVisible(false);
            this.partPane.setVisible(false);
            this.partListPane.setVisible(true);
            boolean fixed = pl.isFixed();
            this.addPart.setDisable(fixed);
            this.forceSortParts.setDisable(fixed);
            this.updateStatistics(pl);
            return;
        }
        this.partListPane.setVisible(false);
        LDrawPart part = data.getPart(this.main.ctx);
        if (part == null) {
            this.partListStatistics.setText("");
            this.noDetailPane.setVisible(true);
            this.partPane.setVisible(false);
            return;
        }
        this.noDetailPane.setVisible(false);
        this.partPane.setVisible(true);
        int size = 0;
        for (LDrawLine line : part.content) {
            size += line.source.length() + 1;
        }
        this.partStatistics.setText(String.format("%d lines in %d steps require %d kb", part.content.size(), part.steps.size() + 1, size + 511 >>> 10));
        this.header.setText("");
        for (LDrawLine line : part.content) {
            if (line.source == null) continue;
            if (!line.source.startsWith("0")) break;
            this.appendHeaderLine(line.source);
        }
    }

    private void refreshItem() {
        LDIData data = (LDIData)this.item.getValue();
        data.refresh();
        this.main.refreshItem(this.item);
    }

    private void saveItem(boolean askForDestination) {
        if (this.item == null) {
            return;
        }
        this.main.reexportChangedFile(this.item, askForDestination);
    }

    private void renameItem(String newVal) {
        if (this.item == null || newVal == null || newVal.length() == 0 || this.inUpdate) {
            return;
        }
        LDIData data = (LDIData)this.item.getValue();
        if (data == null) {
            return;
        }
        data.setName(newVal);
        this.main.refreshItem(this.item);
        this.refresh();
    }

    private void changeColor(LDICColor newValue) {
        int newCol;
        if (this.item == null || newValue == null || this.inUpdate) {
            return;
        }
        LDIData data = (LDIData)this.item.getValue();
        if (data == null) {
            return;
        }
        int oldCol = data.getColId();
        if (oldCol == (newCol = newValue.id)) {
            return;
        }
        data.setColId(newCol);
        this.main.refreshItem(this.item);
    }

    private void changeAmount(String newVal) {
        if (this.item == null || newVal == null || newVal.length() == 0 || this.inUpdate) {
            return;
        }
        LDIData data = (LDIData)this.item.getValue();
        if (data == null) {
            return;
        }
        try {
            int na = Integer.parseInt(newVal);
            data.setAmount(na);
            this.main.refreshItem(this.item);
            this.refresh();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void updateStatistics(LDIDPartList pl) {
        List<? extends LDIData> elems = pl.getSubElements(this.main.ctx);
        int parts = 0;
        HashSet<Integer> ucols = new HashSet<Integer>();
        for (LDIData lDIData : elems) {
            int ec;
            int ea = lDIData.getAmount();
            if (ea > 0) {
                parts += ea;
            }
            if ((ec = lDIData.getColId()) == -1 || ec == 16) continue;
            ucols.add(ec);
        }
        this.partListStatistics.setText(String.valueOf(parts) + " parts in " + elems.size() + " lots and " + ucols.size() + " colors");
    }

    private void exportObj() {
        ExportType type;
        LDrawPart part;
        if (this.item == null || (part = ((LDIData)this.item.getValue()).getPart(this.main.ctx)) == null || (type = (ExportType)((Object)this.exportType.getSelectionModel().getSelectedItem())) == null) {
            return;
        }
        File f = GuiHelper.showFileSaveDialog("Export " + type.toString(), type.defName, true);
        if (f == null) {
            return;
        }
        try {
            type.run(part, f, this.main.ctx, this.main);
        }
        catch (IOException e) {
            GuiHelper.alert(Alert.AlertType.ERROR, "LDInspector: save workspace failed", "Saving context failed, because there was an I/O error", String.valueOf(e.getClass().getName()) + ": " + e.getMessage(), true);
            return;
        }
    }

    private void appendHeaderLine(String text) {
        int caretPosition = this.header.caretPositionProperty().get();
        double scrollTop = this.header.getScrollTop();
        this.header.setText(String.valueOf(this.header.getText()) + text + "\n");
        this.header.positionCaret(caretPosition);
        this.header.setScrollTop(scrollTop);
    }

    private void copyHeaderToClipboard() {
        ClipboardContent c = new ClipboardContent();
        c.putString(this.header.getText());
        Clipboard.getSystemClipboard().setContent((Map)c);
    }

    private void addPartToPartList() {
        LDIDPartList pl = this.main.getAsUnfixedPartList(this.item);
        if (pl == null) {
            return;
        }
        pl.addEmptyPart();
        this.item.setExpanded(true);
        this.main.rebuildItem(this.item);
    }

    private void forceSortPartsOfPartList() {
        LDIDPartList pl = this.main.getAsUnfixedPartList(this.item);
        if (pl == null) {
            return;
        }
        pl.sortParts();
        this.main.rebuildItem(this.item);
    }

    private void exportPartListAsPbg() {
        LDIDPartList pl = this.main.getAsPartList(this.item);
        if (pl != null) {
            this.main.exportPartListAsPbg(pl);
        }
    }

    private void exportPartListAsXml() {
        LDIDPartList pl = this.main.getAsPartList(this.item);
        if (pl != null) {
            this.main.exportPartListAsXml(pl);
        }
    }

    private static enum ExportType {
        OBJ_PART_COMPLETE("Complete part to Wavefront OBJ", "part.obj"){

            @Override
            public void run(LDrawPart part, File f, LDIContext ctx, LDILogger logger) throws IOException {
                PrintWriter w = new PrintWriter(new FileWriter(f));
                LDIObjExport.writeObject(part, w, true, ctx, logger);
                w.close();
            }
        }
        ,
        OBJ_PART_ONLYFACES("Faces of part to Wavefront OBJ", "part.obj"){

            @Override
            public void run(LDrawPart part, File f, LDIContext ctx, LDILogger logger) throws IOException {
                PrintWriter w = new PrintWriter(new FileWriter(f));
                LDIObjExport.writeObject(part, w, false, ctx, logger);
                w.close();
            }
        }
        ,
        MTL_ALL("All colors to Wavefront OBJ material file", "ldraw.mtl"){

            @Override
            public void run(LDrawPart part, File f, LDIContext ctx, LDILogger logger) throws IOException {
                PrintWriter w = new PrintWriter(new FileWriter(f));
                LDIObjExport.writeMaterial(null, w, ctx, logger);
                w.close();
            }
        }
        ,
        MTL_PART("Used colors to Wavefront OBJ material file", "part.mtl"){

            @Override
            public void run(LDrawPart part, File f, LDIContext ctx, LDILogger logger) throws IOException {
                PrintWriter w = new PrintWriter(new FileWriter(f));
                LDIObjExport.writeMaterial(part, w, ctx, logger);
                w.close();
            }
        }
        ,
        ZIP_TRANS_PART("Part with all transitively used parts to ZIP", "part.zip"){

            @Override
            public void run(LDrawPart part, File f, LDIContext ctx, LDILogger logger) throws IOException {
                LDIPartExport.exportToZipTransitively(part, f, ctx, logger);
            }
        };

        public final String text;
        public final String defName;

        public abstract void run(LDrawPart var1, File var2, LDIContext var3, LDILogger var4) throws IOException;

        private ExportType(String itext, String idefName) {
            this.text = itext;
            this.defName = idefName;
        }

        public String toString() {
            return this.text;
        }
    }
}

