/*
 * Decompiled with CFR 0.152.
 */
package ldinsp.gui;

import java.io.File;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.TextArea;
import javafx.scene.paint.Color;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import ldinsp.util.ColorHelper;

public class GuiHelper {
    public static final ButtonType BT_YES = new ButtonType("Yes");
    public static final ButtonType BT_NO = new ButtonType("No");
    public static final ButtonType BT_CANCEL = new ButtonType("Cancel");
    private static final FileChooser fileChooser = new FileChooser();
    private static final DirectoryChooser dirChooser = new DirectoryChooser();
    private static Stage primaryStage;

    public static void setPrimaryStage(Stage nps) {
        primaryStage = nps;
    }

    public static void fixPrimaryStage() {
        if ("linux".equalsIgnoreCase(System.getProperty("os.name"))) {
            double height = primaryStage.getHeight();
            double width = primaryStage.getWidth();
            primaryStage.hide();
            primaryStage.show();
            primaryStage.setHeight(height);
            primaryStage.setWidth(width);
        }
    }

    public static File showFileOpenDialog(String title, boolean fixPrimary) {
        fileChooser.setTitle(title);
        File f = fileChooser.showOpenDialog((Window)primaryStage);
        if (fixPrimary) {
            GuiHelper.fixPrimaryStage();
        }
        return f;
    }

    public static List<File> showFileMultiOpenDialog(String title, boolean fixPrimary) {
        fileChooser.setTitle(title);
        List fs = fileChooser.showOpenMultipleDialog((Window)primaryStage);
        if (fixPrimary) {
            GuiHelper.fixPrimaryStage();
        }
        return fs;
    }

    public static File showFileSaveDialog(String title, String initialFilename, boolean fixPrimary) {
        fileChooser.setTitle(title);
        fileChooser.setInitialFileName(initialFilename);
        File f = fileChooser.showSaveDialog((Window)primaryStage);
        if (fixPrimary) {
            GuiHelper.fixPrimaryStage();
        }
        return f;
    }

    public static File showDirOpenDialog(String title, boolean fixPrimary) {
        dirChooser.setTitle(title);
        File f = dirChooser.showDialog((Window)primaryStage);
        if (fixPrimary) {
            GuiHelper.fixPrimaryStage();
        }
        return f;
    }

    public static Color rgbaToColor(int rgba) {
        return new Color(ColorHelper.getR(rgba), ColorHelper.getG(rgba), ColorHelper.getB(rgba), ColorHelper.getA(rgba));
    }

    public static boolean yesNo(Alert.AlertType type, String title, String header, String content, boolean defaultToYes, boolean fixPrimary) {
        boolean res;
        Alert alert = new Alert(type);
        alert.setResizable(true);
        alert.setTitle(title);
        alert.setHeaderText(header);
        alert.setContentText(content);
        alert.getButtonTypes().clear();
        alert.getButtonTypes().addAll((Object[])new ButtonType[]{BT_NO, BT_YES});
        Button button = (Button)alert.getDialogPane().lookupButton(BT_YES);
        button.setDefaultButton(defaultToYes);
        button = (Button)alert.getDialogPane().lookupButton(BT_NO);
        button.setDefaultButton(!defaultToYes);
        boolean bl = res = alert.showAndWait().get() == BT_YES;
        if (fixPrimary) {
            GuiHelper.fixPrimaryStage();
        }
        return res;
    }

    public static ButtonType yesNoCancel(Alert.AlertType type, String title, String header, String content, boolean fixPrimary) {
        Alert alert = new Alert(type);
        alert.setResizable(true);
        alert.setTitle(title);
        alert.setHeaderText(header);
        alert.setContentText(content);
        alert.getButtonTypes().clear();
        alert.getButtonTypes().addAll((Object[])new ButtonType[]{BT_CANCEL, BT_NO, BT_YES});
        Button button = (Button)alert.getDialogPane().lookupButton(BT_CANCEL);
        button.setDefaultButton(true);
        button = (Button)alert.getDialogPane().lookupButton(BT_NO);
        button.setDefaultButton(false);
        button = (Button)alert.getDialogPane().lookupButton(BT_YES);
        button.setDefaultButton(false);
        ButtonType res = (ButtonType)alert.showAndWait().get();
        if (fixPrimary) {
            GuiHelper.fixPrimaryStage();
        }
        return res;
    }

    public static void alert(Alert.AlertType type, String title, String header, String content, boolean fixPrimary) {
        Alert alert = new Alert(type);
        alert.setResizable(true);
        alert.setTitle(title);
        alert.setHeaderText(header);
        alert.setContentText(content);
        alert.getDialogPane().setMinHeight(Double.NEGATIVE_INFINITY);
        alert.showAndWait();
        if (fixPrimary) {
            GuiHelper.fixPrimaryStage();
        }
    }

    public static void alertLargeContent(Alert.AlertType type, String title, String header, String content, boolean fixPrimary) {
        Alert alert = new Alert(type);
        alert.setResizable(true);
        alert.setTitle(title);
        alert.setHeaderText(header);
        TextArea ta = new TextArea(content);
        ta.setEditable(false);
        alert.getDialogPane().setContent((Node)ta);
        alert.getDialogPane().setMinHeight(550.0);
        alert.showAndWait();
        if (fixPrimary) {
            GuiHelper.fixPrimaryStage();
        }
    }
}

