/*
 * Decompiled with CFR 0.152.
 */
package ldinsp.ext;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import ldinsp.base.LDILogger;
import ldinsp.base.LDIWorkerRefWalk;
import ldinsp.context.LDIContext;
import ldinsp.ldraw.LDrawPart;

public class LDIPartExport {
    public static void exportToZipTransitively(LDrawPart part, File f, LDIContext ctx, LDILogger logger) throws IOException {
        if (part == null || f == null) {
            return;
        }
        String mainFile = part.loadedFromFilename;
        if (mainFile == null) {
            mainFile = part.givenFilename;
        }
        if (mainFile == null) {
            mainFile = "part." + (part.subParts == null || part.subParts.size() == 0 ? "ldr" : "mpd");
        }
        ZipOutputStream zip = new ZipOutputStream(new FileOutputStream(f));
        LDIPartExport.addPartToZip(zip, part, mainFile);
        LDIPartExport.workPart(part, zip, ctx, logger);
        zip.close();
    }

    private static void addPartToZip(ZipOutputStream zip, LDrawPart part, String name) throws IOException {
        ZipEntry e = new ZipEntry(name);
        zip.putNextEntry(e);
        zip.write(part.getSource().getBytes("UTF-8"));
        zip.closeEntry();
    }

    private static void workPart(final LDrawPart part, final ZipOutputStream zip, final LDIContext ctx, final LDILogger logger) {
        final HashSet done = new HashSet();
        LDIWorkerRefWalk w = new LDIWorkerRefWalk(){

            @Override
            public LDrawPart usePart(String partName) {
                LDrawPart res;
                block5: {
                    if (done.contains(partName = partName.toLowerCase())) {
                        return null;
                    }
                    done.add(partName);
                    res = ctx.getPart(part.owner, partName, logger);
                    if (res == null) {
                        if (logger != null) {
                            logger.log("could not find named part " + partName);
                        }
                        return null;
                    }
                    try {
                        LDIPartExport.addPartToZip(zip, res, partName);
                    }
                    catch (IOException e) {
                        if (logger == null) break block5;
                        logger.log("write failed: " + e.getClass().getName() + ": " + e.getMessage());
                    }
                }
                return res;
            }
        };
        w.work(part);
    }
}

