/*
 * Decompiled with CFR 0.152.
 */
package ldinsp.ext;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import ldinsp.base.LDILogger;
import ldinsp.base.LDIWorker;
import ldinsp.context.LDICColor;
import ldinsp.context.LDIContext;
import ldinsp.ldraw.LDrawLineLine;
import ldinsp.ldraw.LDrawLinePartRef;
import ldinsp.ldraw.LDrawLineQuad;
import ldinsp.ldraw.LDrawLineTri;
import ldinsp.ldraw.LDrawPart;
import ldinsp.ldraw.LDrawPoint;
import ldinsp.util.ColorHelper;

public class LDIObjExport {
    public static void writeObject(LDrawPart part, final PrintWriter pw, final boolean writeLines, final LDIContext ctx, final LDILogger logger) throws IOException {
        if (part == null) {
            return;
        }
        LDIWorker w = new LDIWorker(){
            private int vertexCount;
            private String lastMtl = "";

            @Override
            public LDrawPart handlePartRef(LDrawLinePartRef ref, String partName, int colId, int pcol) {
                LDrawPart res = ctx.getPart(ref.owner, partName, logger);
                if (res == null && logger != null) {
                    logger.log("could not find named part " + partName);
                }
                return res;
            }

            @Override
            public void handleLine(LDrawLineLine line, LDrawPoint t1, LDrawPoint t2, int colId, int pcol) {
                if (!writeLines) {
                    return;
                }
                this.printMaterial(colId, pcol);
                this.printVertex(t1);
                this.printVertex(t2);
                this.printLine(-1, 0);
            }

            @Override
            public void handleTri(LDrawLineTri tri, LDrawPoint t1, LDrawPoint t2, LDrawPoint t3, int colId, int pcol) {
                this.printMaterial(colId, pcol);
                this.printVertex(t1);
                this.printVertex(t2);
                this.printVertex(t3);
                if (this.getFaceInvertion()) {
                    this.printFace(-2, 0, -1);
                } else {
                    this.printFace(-2, -1, 0);
                }
            }

            @Override
            public void handleQuad(LDrawLineQuad quad, LDrawPoint t1, LDrawPoint t2, LDrawPoint t3, LDrawPoint t4, int colId, int pcol) {
                this.printMaterial(colId, pcol);
                this.printVertex(t1);
                this.printVertex(t2);
                this.printVertex(t3);
                this.printVertex(t4);
                if (this.getFaceInvertion()) {
                    this.printFace(-3, -1, -2);
                    this.printFace(-1, -3, 0);
                } else {
                    this.printFace(-3, -2, -1);
                    this.printFace(-1, 0, -3);
                }
            }

            private void printMaterial(int colId, int pcol) {
                String type;
                if (colId == 24) {
                    type = "Edge";
                    colId = pcol;
                } else {
                    type = "Face";
                    if (colId == 16) {
                        colId = pcol;
                    }
                }
                String mtl = "LDraw" + type + colId;
                if (mtl.equals(this.lastMtl)) {
                    return;
                }
                pw.println("usemtl " + mtl);
                this.lastMtl = mtl;
            }

            private void printVertex(LDrawPoint t) {
                pw.println("v " + t.x + " " + t.y + " " + t.z);
                ++this.vertexCount;
            }

            private void printLine(int o1, int o2) {
                pw.println("l " + (this.vertexCount + o1) + " " + (this.vertexCount + o2));
            }

            private void printFace(int o1, int o2, int o3) {
                pw.println("f " + (this.vertexCount + o1) + " " + (this.vertexCount + o2) + " " + (this.vertexCount + o3));
            }
        };
        pw.println("mtllib ldraw.mtl");
        w.work(part);
    }

    public static void writeMaterial(LDrawPart part, PrintWriter pw, final LDIContext ctx, final LDILogger logger) throws IOException {
        final ArrayList<LDICColor> faces = new ArrayList<LDICColor>();
        final ArrayList<LDICColor> edges = new ArrayList<LDICColor>();
        if (part == null) {
            faces.addAll(ctx.getColors());
            edges.addAll(ctx.getColors());
        } else {
            LDIWorker w = new LDIWorker(){

                @Override
                public LDrawPart handlePartRef(LDrawLinePartRef ref, String partName, int colId, int pcol) {
                    LDrawPart rp = ctx.getPart(ref.owner, partName, logger);
                    if (rp == null && logger != null) {
                        logger.log("could not find named part " + partName);
                    }
                    return rp;
                }

                @Override
                public void handleLine(LDrawLineLine line, LDrawPoint t1, LDrawPoint t2, int colId, int pcol) {
                    this.addMaterial(colId, pcol);
                }

                @Override
                public void handleTri(LDrawLineTri tri, LDrawPoint t1, LDrawPoint t2, LDrawPoint t3, int colId, int pcol) {
                    this.addMaterial(colId, pcol);
                }

                @Override
                public void handleQuad(LDrawLineQuad quad, LDrawPoint t1, LDrawPoint t2, LDrawPoint t3, LDrawPoint t4, int colId, int pcol) {
                    this.addMaterial(colId, pcol);
                }

                private void addMaterial(int colId, int pcol) {
                    ArrayList target;
                    if (colId == 24) {
                        target = edges;
                        colId = pcol;
                    } else {
                        target = faces;
                        if (colId == 16) {
                            colId = pcol;
                        }
                    }
                    LDICColor col = ctx.getColorById(colId);
                    if (col == null) {
                        if (logger != null) {
                            logger.log("missing color for id " + colId);
                        }
                        return;
                    }
                    if (!target.contains(col)) {
                        target.add(col);
                    }
                }
            };
            w.work(part);
        }
        LDIObjExport.writeColorList(pw, true, faces);
        LDIObjExport.writeColorList(pw, false, edges);
    }

    private static void writeColorList(PrintWriter pw, boolean faceNotEdge, ArrayList<LDICColor> list) {
        String type = faceNotEdge ? "Face" : "Edge";
        for (LDICColor c : list) {
            pw.println("newmtl LDraw" + type + c.id);
            int rgba = faceNotEdge ? c.rgbaFace : c.rgbaEdge;
            double r = ColorHelper.getR(rgba);
            double g = ColorHelper.getG(rgba);
            double b = ColorHelper.getB(rgba);
            double a = ColorHelper.getA(rgba);
            pw.printf("Kd %f %f %f\n", r, g, b);
            if (a == 1.0) continue;
            pw.printf("d %f\n", a);
            pw.printf("Tr %f\n", 1.0 - a);
        }
    }
}

