/*
 * Decompiled with CFR 0.152.
 */
package ldinsp.context;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import ldinsp.context.LDICColorHintSource;

public class LDICColorHint {
    public final LDICColorHintSource source;
    public final int id;
    public final String name;
    public static final String HINT_SEP = " // ";

    public LDICColorHint(LDICColorHintSource isource, int iid, String iname) {
        this.source = isource;
        this.id = iid;
        this.name = iname;
    }

    public static String hintsToString(List<LDICColorHint> hints) {
        String res = "";
        if (hints != null) {
            LDICColorHintSource[] lDICColorHintSourceArray = LDICColorHintSource.values();
            int n = lDICColorHintSourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                LDICColorHintSource hs = lDICColorHintSourceArray[n2];
                String hint = LDICColorHint.hintsToString(hints, hs);
                if (hint != null && hint.length() > 0) {
                    if (res.length() > 0) {
                        res = String.valueOf(res) + HINT_SEP;
                    }
                    res = String.valueOf(res) + hint;
                }
                ++n2;
            }
        }
        return res;
    }

    public static String hintsToString(List<LDICColorHint> hints, LDICColorHintSource source) {
        String ids = "";
        String names = "";
        for (LDICColorHint hint : hints) {
            if (hint.source != source) continue;
            if (ids.length() > 0) {
                ids = String.valueOf(ids) + " / ";
                names = String.valueOf(names) + " / ";
            }
            ids = String.valueOf(ids) + hint.id;
            names = String.valueOf(names) + hint.name;
        }
        if (ids.length() == 0) {
            return null;
        }
        return String.valueOf(source.name()) + "ID " + ids + " - " + names;
    }

    public static List<LDICColorHint> getHintsFromString(String source) {
        if (source == null || source.length() == 0) {
            return null;
        }
        source = source.trim();
        ArrayList<LDICColorHint> res = new ArrayList<LDICColorHint>();
        if (source != null && source.length() > 0) {
            String[] stringArray = source.split(Pattern.quote(HINT_SEP));
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                if ((line = line.trim()).length() != 0) {
                    LDICColorHint.addHintsFromCompIdNameString(res, line);
                }
                ++n2;
            }
        }
        return res;
    }

    public static LDICColorHintSource getHintSource(String comp) {
        if (comp == null) {
            return null;
        }
        if (!(comp = comp.toUpperCase().trim()).endsWith("ID")) {
            return null;
        }
        comp = comp.substring(0, comp.length() - 2);
        LDICColorHintSource[] lDICColorHintSourceArray = LDICColorHintSource.values();
        int n = lDICColorHintSourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            LDICColorHintSource chk = lDICColorHintSourceArray[n2];
            if (chk.name().equals(comp)) {
                return chk;
            }
            ++n2;
        }
        return null;
    }

    public static void addHintsFromCompIdNameString(ArrayList<LDICColorHint> list, String source) {
        int pos = source.indexOf(32);
        if (pos < 3) {
            return;
        }
        LDICColorHintSource hs = LDICColorHint.getHintSource(source.substring(0, pos));
        if (hs == null) {
            return;
        }
        String hint = source.substring(pos + 1).trim();
        LDICColorHint.addHintsFromIdNameString(list, hs, hint);
    }

    public static void addHintsFromIdNameString(ArrayList<LDICColorHint> list, LDICColorHintSource hs, String hint) {
        int pos = hint.indexOf(" - ");
        if (pos < 0) {
            return;
        }
        String idStr = hint.substring(0, pos).trim();
        String nameStr = hint.substring(pos + 3).trim();
        String[] ids = idStr.split(Pattern.quote(" / "));
        String[] names = nameStr.split(Pattern.quote(" / "));
        int i = 0;
        while (i < ids.length) {
            block4: {
                int id = -1;
                try {
                    id = Integer.parseInt(ids[i]);
                }
                catch (NumberFormatException e) {
                    break block4;
                }
                String name = i >= names.length ? "" : names[i];
                list.add(new LDICColorHint(hs, id, name));
            }
            ++i;
        }
    }
}

