/*
 * Decompiled with CFR 0.152.
 */
package ldinsp.context;

import java.util.ArrayList;
import java.util.List;
import ldinsp.context.LDICColorHint;
import ldinsp.context.LDICColorHintSource;
import ldinsp.context.LDICColorProp;

public class LDICColor {
    private static ArrayList<LDICColor> INTERNAL;
    public final int id;
    public final int rgbaFace;
    public final int rgbaEdge;
    public final String name;
    public final LDICColorProp prop;
    public final List<LDICColorHint> hints;

    public LDICColor(int iid, int irgbaFace, int irgbaEdge, LDICColorProp iprop, String iname) {
        this.id = iid;
        this.rgbaFace = irgbaFace;
        this.rgbaEdge = irgbaEdge;
        this.name = iname;
        this.prop = iprop;
        this.hints = new ArrayList<LDICColorHint>();
    }

    public LDICColor(int iid, int irgbaFace, int irgbaEdge, LDICColorProp iprop, String iname, List<LDICColorHint> ihints) {
        this.id = iid;
        this.rgbaFace = irgbaFace;
        this.rgbaEdge = irgbaEdge;
        this.name = iname;
        this.prop = iprop;
        this.hints = new ArrayList<LDICColorHint>();
        if (ihints != null) {
            this.hints.addAll(ihints);
        }
    }

    public boolean equals(Object other) {
        if (!(other instanceof LDICColor)) {
            return false;
        }
        return this.id == ((LDICColor)other).id;
    }

    public LDICColorHint getFirstHint(LDICColorHintSource source) {
        if (this.hints == null || this.hints.size() == 0) {
            return null;
        }
        for (LDICColorHint hint : this.hints) {
            if (hint.source != source) continue;
            return hint;
        }
        return null;
    }

    public static List<LDICColor> getPredefinedColors() {
        if (INTERNAL != null) {
            return INTERNAL;
        }
        INTERNAL = new ArrayList();
        INTERNAL.add(new LDICColor(0, 455750911, -2139062017, LDICColorProp.SOLID, "Black", LDICColorHint.getHintsFromString("LEGOID 26 - Black // BRICKLINKID 11 - Black // REBRICKABLEID 0 - Black")));
        INTERNAL.add(new LDICColor(1, 509257983, 0x333333FF, LDICColorProp.SOLID, "Blue", LDICColorHint.getHintsFromString("LEGOID 23 - Bright Blue // BRICKLINKID 7 - Blue // REBRICKABLEID 1 - Blue")));
        INTERNAL.add(new LDICColor(2, 8727551, 0x333333FF, LDICColorProp.SOLID, "Green", LDICColorHint.getHintsFromString("LEGOID 28 - Dark Green // BRICKLINKID 6 - Green // REBRICKABLEID 2 - Green")));
        INTERNAL.add(new LDICColor(3, 110993407, 0x333333FF, LDICColorProp.SOLID, "Dark Turquoise", LDICColorHint.getHintsFromString("LEGOID 107 - Bright Bluish Green // BRICKLINKID 39 - Dark Turquoise // REBRICKABLEID 3 - Dark Turquoise")));
        INTERNAL.add(new LDICColor(4, -1275068161, 0x333333FF, LDICColorProp.SOLID, "Red", LDICColorHint.getHintsFromString("LEGOID 21 - Bright Red // BRICKLINKID 5 - Red // REBRICKABLEID 4 - Red")));
        INTERNAL.add(new LDICColor(5, -751460865, 0x333333FF, LDICColorProp.SOLID, "Dark Pink", LDICColorHint.getHintsFromString("LEGOID 22 / 221 - Medium Reddish Violet / Bright Purple // BRICKLINKID 47 - Dark Pink // REBRICKABLEID 5 - Dark Pink")));
        INTERNAL.add(new LDICColor(6, 1412637951, 0x1E1E1EFF, LDICColorProp.SOLID, "Brown", LDICColorHint.getHintsFromString("LEGOID 25 - Earth Orange // BRICKLINKID 8 - Brown // REBRICKABLEID 6 - Brown")));
        INTERNAL.add(new LDICColor(7, -1970106881, 0x333333FF, LDICColorProp.SOLID, "Light Grey", LDICColorHint.getHintsFromString("LEGOID 2 - Grey // BRICKLINKID 9 - Light Gray // REBRICKABLEID 7 - Light Gray")));
        INTERNAL.add(new LDICColor(8, 1415140863, 0x333333FF, LDICColorProp.SOLID, "Dark Grey", LDICColorHint.getHintsFromString("LEGOID 27 - Dark Grey // BRICKLINKID 10 - Dark Gray // REBRICKABLEID 8 - Dark Gray")));
        INTERNAL.add(new LDICColor(9, -1748248065, 0x333333FF, LDICColorProp.SOLID, "Light Blue", LDICColorHint.getHintsFromString("LEGOID 45 - Light Blue // BRICKLINKID 62 - Light Blue // REBRICKABLEID 9 - Light Blue")));
        INTERNAL.add(new LDICColor(10, 1487618559, 0x333333FF, LDICColorProp.SOLID, "Bright Green", LDICColorHint.getHintsFromString("LEGOID 37 - Bright Green // BRICKLINKID 36 - Bright Green // REBRICKABLEID 10 - Bright Green")));
        INTERNAL.add(new LDICColor(11, 0xAAA4FF, 0x333333FF, LDICColorProp.SOLID, "Light Turquoise", LDICColorHint.getHintsFromString("LEGOID 116 - Medium Bluish Green // BRICKLINKID 40 - Light Turquoise // REBRICKABLEID 11 - Light Turquoise")));
        INTERNAL.add(new LDICColor(12, -261266945, 0x333333FF, LDICColorProp.SOLID, "Salmon", LDICColorHint.getHintsFromString("LEGOID 101 - Medium Red // BRICKLINKID 25 - Salmon // REBRICKABLEID 12 - Salmon")));
        INTERNAL.add(new LDICColor(13, -156648449, 0x333333FF, LDICColorProp.SOLID, "Pink", LDICColorHint.getHintsFromString("LEGOID 9 - Light Reddish Violet // BRICKLINKID 23 - Pink // REBRICKABLEID 13 - Pink")));
        INTERNAL.add(new LDICColor(14, -87553281, 0x333333FF, LDICColorProp.SOLID, "Yellow", LDICColorHint.getHintsFromString("LEGOID 24 - Bright Yellow // BRICKLINKID 3 - Yellow // REBRICKABLEID 14 - Yellow")));
        INTERNAL.add(new LDICColor(15, -185273089, 0x333333FF, LDICColorProp.SOLID, "White", LDICColorHint.getHintsFromString("LEGOID 1 - White // BRICKLINKID 1 - White // REBRICKABLEID 15 - White")));
        INTERNAL.add(new LDICColor(16, -32513, 0x333333FF, LDICColorProp.SOLID, "Main Colour", LDICColorHint.getHintsFromString("")));
        INTERNAL.add(new LDICColor(17, -1378244353, 0x333333FF, LDICColorProp.SOLID, "Light Green", LDICColorHint.getHintsFromString("LEGOID 6 - Light Green // BRICKLINKID 38 - Light Green // REBRICKABLEID 17 - Light Green")));
        INTERNAL.add(new LDICColor(18, -2719745, 0x333333FF, LDICColorProp.SOLID, "Light Yellow", LDICColorHint.getHintsFromString("LEGOID 3 - Light Yellow // BRICKLINKID 33 - Light Yellow // REBRICKABLEID 18 - Light Yellow")));
        INTERNAL.add(new LDICColor(19, -1331662849, 0x333333FF, LDICColorProp.SOLID, "Tan", LDICColorHint.getHintsFromString("LEGOID 5 - Brick Yellow // BRICKLINKID 2 - Tan // REBRICKABLEID 19 - Tan")));
        INTERNAL.add(new LDICColor(20, -1346447617, 0x333333FF, LDICColorProp.SOLID, "Light Violet", LDICColorHint.getHintsFromString("LEGOID 39 - Light Bluish Violet // BRICKLINKID 44 - Light Violet // REBRICKABLEID 20 - Light Violet")));
        INTERNAL.add(new LDICColor(21, -520113936, -1191227920, LDICColorProp.SOLID, "Glow In Dark Opaque", LDICColorHint.getHintsFromString("LEGOID 294 - Phosphorescent Green // BRICKLINKID 46 - Glow In Dark Opaque // REBRICKABLEID 21 - Glow In Dark Opaque")));
        INTERNAL.add(new LDICColor(22, 1730118143, 0x333333FF, LDICColorProp.SOLID, "Purple", LDICColorHint.getHintsFromString("LEGOID 104 - Bright Violet // BRICKLINKID 24 - Purple // REBRICKABLEID 22 - Purple")));
        INTERNAL.add(new LDICColor(23, 238983935, 0x333333FF, LDICColorProp.SOLID, "Dark Blue Violet", LDICColorHint.getHintsFromString("LEGOID 196 - Dark Royal Blue // BRICKLINKID 109 - Dark Blue-Violet // REBRICKABLEID 23 - Dark Blue-Violet")));
        INTERNAL.add(new LDICColor(24, 0x7F7F7FFF, 0x333333FF, LDICColorProp.SOLID, "Edge Colour", LDICColorHint.getHintsFromString("")));
        INTERNAL.add(new LDICColor(25, -696704001, 0x333333FF, LDICColorProp.SOLID, "Orange", LDICColorHint.getHintsFromString("LEGOID 106 - Bright Orange // BRICKLINKID 4 - Orange // REBRICKABLEID 25 - Orange")));
        INTERNAL.add(new LDICColor(26, -1876986113, 0x333333FF, LDICColorProp.SOLID, "Magenta", LDICColorHint.getHintsFromString("LEGOID 124 - Bright Reddish Violet // BRICKLINKID 71 - Magenta // REBRICKABLEID 26 - Magenta")));
        INTERNAL.add(new LDICColor(27, -1513481985, 0x333333FF, LDICColorProp.SOLID, "Lime", LDICColorHint.getHintsFromString("LEGOID 119 - Bright Yellowish Green // BRICKLINKID 34 - Lime // REBRICKABLEID 27 - Lime")));
        INTERNAL.add(new LDICColor(28, -1988271361, 0x333333FF, LDICColorProp.SOLID, "Dark Tan", LDICColorHint.getHintsFromString("LEGOID 138 - Sand Yellow // BRICKLINKID 69 - Dark Tan // REBRICKABLEID 28 - Dark Tan")));
        INTERNAL.add(new LDICColor(29, -6369793, 0x333333FF, LDICColorProp.SOLID, "Bright Pink", LDICColorHint.getHintsFromString("LEGOID 222 - Light Purple // BRICKLINKID 104 - Bright Pink // REBRICKABLEID 29 - Bright Pink")));
        INTERNAL.add(new LDICColor(30, -1603356161, 0x333333FF, LDICColorProp.SOLID, "Medium Lavender", LDICColorHint.getHintsFromString("LEGOID 324 - Medium Lavender // BRICKLINKID 157 - Medium Lavender // REBRICKABLEID 30 - Medium Lavender")));
        INTERNAL.add(new LDICColor(31, -844833025, 0x333333FF, LDICColorProp.SOLID, "Lavender", LDICColorHint.getHintsFromString("LEGOID 325 - Lavender // BRICKLINKID 154 - Lavender // REBRICKABLEID 31 - Lavender")));
        INTERNAL.add(new LDICColor(33, 2138240, 735360, LDICColorProp.SOLID, "Trans Dark Blue", LDICColorHint.getHintsFromString("LEGOID 43 - Transparent Blue // BRICKLINKID 14 - Trans-Dark Blue // REBRICKABLEID 33 - Trans-Dark Blue")));
        INTERNAL.add(new LDICColor(34, 595083648, 391064448, LDICColorProp.SOLID, "Trans Green", LDICColorHint.getHintsFromString("LEGOID 48 - Transparent Green // BRICKLINKID 20 - Trans-Green // REBRICKABLEID 34 - Trans-Green")));
        INTERNAL.add(new LDICColor(35, 1457931904, 665786496, LDICColorProp.SOLID, "Trans Bright Green", LDICColorHint.getHintsFromString("LEGOID 311 / 227 - Transparent Bright Green / Transparent Bright Yellowish Green // BRICKLINKID 108 - Trans-Bright Green // REBRICKABLEID 35 - Trans-Bright Green")));
        INTERNAL.add(new LDICColor(36, -921040512, 1712129408, LDICColorProp.SOLID, "Trans Red", LDICColorHint.getHintsFromString("LEGOID 41 - Transparent Red // BRICKLINKID 17 - Trans-Red // REBRICKABLEID 36 - Trans-Red")));
        INTERNAL.add(new LDICColor(37, -546925184, -1188601984, LDICColorProp.SOLID, "Trans Dark Pink", LDICColorHint.getHintsFromString("LEGOID 113 - Transparent Medium Reddish Violet // BRICKLINKID 50 - Trans-Dark Pink // REBRICKABLEID 45 - Trans-Dark Pink")));
        INTERNAL.add(new LDICColor(38, -8385152, -1471086464, LDICColorProp.SOLID, "Trans Neon Orange", LDICColorHint.getHintsFromString("LEGOID 47 - Transparent Fluorescent Reddish Orange // BRICKLINKID 18 - Trans-Neon Orange // REBRICKABLEID 57 - Trans-Neon Orange")));
        INTERNAL.add(new LDICColor(39, -1042288512, 1874123904, LDICColorProp.SOLID, "Trans Very Light Blue", LDICColorHint.getHintsFromString("LEGOID 229 - Transparent Light Bluish Green // REBRICKABLEID 43 - Trans-Very Lt Blue")));
        INTERNAL.add(new LDICColor(40, 1667191424, 707273600, LDICColorProp.SOLID, "Trans Black", LDICColorHint.getHintsFromString("LEGOID 111 - Transparent Brown // BRICKLINKID 13 - Trans-Black // REBRICKABLEID 40 - Trans-Black")));
        INTERNAL.add(new LDICColor(41, 1436202880, 845313664, LDICColorProp.SOLID, "Trans Medium Blue", LDICColorHint.getHintsFromString("LEGOID 143 - Transparent Fluorescent Blue // BRICKLINKID 74 - Trans-Medium Blue // REBRICKABLEID 143 - Trans-Medium Blue")));
        INTERNAL.add(new LDICColor(42, -1057030016, 1939406976, LDICColorProp.SOLID, "Trans Neon Green", LDICColorHint.getHintsFromString("LEGOID 49 - Transparent Fluorescent Green // BRICKLINKID 16 - Trans-Neon Green // REBRICKABLEID 42 - Trans-Neon Green")));
        INTERNAL.add(new LDICColor(43, -1360400512, 1506926208, LDICColorProp.SOLID, "Trans Light Blue", LDICColorHint.getHintsFromString("LEGOID 42 - Transparent Light Blue // BRICKLINKID 15 - Trans-Light Blue // REBRICKABLEID 41 - Trans-Light Blue")));
        INTERNAL.add(new LDICColor(44, -1771004032, 1598252416, LDICColorProp.SOLID, "Trans Bright Reddish Lilac", LDICColorHint.getHintsFromString("LEGOID 236 - Transparent Bright Reddish Lilac // REBRICKABLEID 236 - Trans-Light Purple")));
        INTERNAL.add(new LDICColor(45, -57168768, -114009216, LDICColorProp.SOLID, "Trans Pink", LDICColorHint.getHintsFromString("LEGOID 230 - Transparent Bright Pink // BRICKLINKID 107 - Trans-Pink // REBRICKABLEID 230 - Trans-Pink")));
        INTERNAL.add(new LDICColor(46, -171102336, -1265497984, LDICColorProp.SOLID, "Trans Yellow", LDICColorHint.getHintsFromString("LEGOID 44 - Transparent Yellow // BRICKLINKID 19 - Trans-Yellow // REBRICKABLEID 46 - Trans-Yellow")));
        INTERNAL.add(new LDICColor(47, -50529152, -909522560, LDICColorProp.SOLID, "Trans Clear", LDICColorHint.getHintsFromString("LEGOID 40 - Transparent // BRICKLINKID 12 - Trans-Clear // REBRICKABLEID 47 - Trans-Clear")));
        INTERNAL.add(new LDICColor(52, -1515861120, 1684317824, LDICColorProp.SOLID, "Trans Purple", LDICColorHint.getHintsFromString("LEGOID 126 - Transparent Bright Bluish Violet // BRICKLINKID 51 - Trans-Purple // REBRICKABLEID 52 - Trans-Purple")));
        INTERNAL.add(new LDICColor(54, -625999744, 1969094784, LDICColorProp.SOLID, "Trans Neon Yellow", LDICColorHint.getHintsFromString("LEGOID 157 - Transparent Fluorescent Yellow // BRICKLINKID 121 - Trans-Neon Yellow // REBRICKABLEID 54 - Trans-Neon Yellow")));
        INTERNAL.add(new LDICColor(57, -259056512, -1638135168, LDICColorProp.SOLID, "Trans Orange", LDICColorHint.getHintsFromString("LEGOID 182 - Trans Bright Orange // BRICKLINKID 98 - Trans-Orange // REBRICKABLEID 182 - Trans-Orange")));
        INTERNAL.add(new LDICColor(60, 1683639551, 1717259775, LDICColorProp.CHROME, "Chrome Antique Brass", LDICColorHint.getHintsFromString("LEGOID 187 - Metallic Earth Orange // BRICKLINKID 57 - Chrome Antique Brass // REBRICKABLEID 60 - Chrome Antique Brass")));
        INTERNAL.add(new LDICColor(61, 1821818879, 1029933823, LDICColorProp.CHROME, "Chrome Blue", LDICColorHint.getHintsFromString("LEGOID 185 - Metallic Bright Blue // BRICKLINKID 52 - Chrome Blue // REBRICKABLEID 61 - Chrome Blue")));
        INTERNAL.add(new LDICColor(62, 1018393087, 577192447, LDICColorProp.CHROME, "Chrome Green", LDICColorHint.getHintsFromString("LEGOID 147 - Metallic Dark Green // BRICKLINKID 64 - Chrome Green // REBRICKABLEID 62 - Chrome Green")));
        INTERNAL.add(new LDICColor(63, -1437757697, 1663849215, LDICColorProp.CHROME, "Chrome Pink", LDICColorHint.getHintsFromString("BRICKLINKID 82 - Chrome Pink // REBRICKABLEID 63 - Chrome Pink")));
        INTERNAL.add(new LDICColor(64, 455750911, 1029666559, LDICColorProp.CHROME, "Chrome Black", LDICColorHint.getHintsFromString("BRICKLINKID 122 - Chrome Black // REBRICKABLEID 64 - Chrome Black")));
        INTERNAL.add(new LDICColor(65, -87553281, 0x333333FF, LDICColorProp.RUBBER, "Rubber Yellow", LDICColorHint.getHintsFromString("")));
        INTERNAL.add(new LDICColor(66, -171102336, -1265497984, LDICColorProp.RUBBER, "Rubber Trans Yellow", LDICColorHint.getHintsFromString("")));
        INTERNAL.add(new LDICColor(67, -50529152, -909522560, LDICColorProp.RUBBER, "Rubber Trans Clear", LDICColorHint.getHintsFromString("")));
        INTERNAL.add(new LDICColor(68, -37518337, 0x333333FF, LDICColorProp.SOLID, "Very Light Orange", LDICColorHint.getHintsFromString("LEGOID 36 - Light Yellowish Orange // BRICKLINKID 96 - Very Light Orange // REBRICKABLEID 68 - Very Light Orange")));
        INTERNAL.add(new LDICColor(69, -1978488577, 0x333333FF, LDICColorProp.SOLID, "Bright Reddish Lilac", LDICColorHint.getHintsFromString("LEGOID 198 - Bright Reddish Lilac // REBRICKABLEID 69 - Light Purple")));
        INTERNAL.add(new LDICColor(70, 1597049343, -2139062017, LDICColorProp.SOLID, "Reddish Brown", LDICColorHint.getHintsFromString("LEGOID 192 - Reddish Brown // BRICKLINKID 88 - Reddish Brown // REBRICKABLEID 70 - Reddish Brown")));
        INTERNAL.add(new LDICColor(71, -1768515841, 0x333333FF, LDICColorProp.SOLID, "Light Bluish Grey", LDICColorHint.getHintsFromString("LEGOID 194 - Medium Stone Grey // BRICKLINKID 86 - Light Bluish Gray // REBRICKABLEID 71 - Light Bluish Gray")));
        INTERNAL.add(new LDICColor(72, 0x646464FF, 0x333333FF, LDICColorProp.SOLID, "Dark Bluish Grey", LDICColorHint.getHintsFromString("LEGOID 199 - Dark Stone Grey // BRICKLINKID 85 - Dark Bluish Gray // REBRICKABLEID 72 - Dark Bluish Gray")));
        INTERNAL.add(new LDICColor(73, 1939261695, 0x333333FF, LDICColorProp.SOLID, "Medium Blue", LDICColorHint.getHintsFromString("LEGOID 102 - Medium Blue // BRICKLINKID 42 - Medium Blue // REBRICKABLEID 73 - Medium Blue")));
        INTERNAL.add(new LDICColor(74, 2143581695, 0x333333FF, LDICColorProp.SOLID, "Medium Green", LDICColorHint.getHintsFromString("LEGOID 29 - Medium Green // BRICKLINKID 37 - Medium Green // REBRICKABLEID 74 - Medium Green")));
        INTERNAL.add(new LDICColor(76, 1667195391, -1987606273, LDICColorProp.SOLID, "Speckle Dark Bluish Grey Silver", LDICColorHint.getHintsFromString("LEGOID 132 - Black Glitter // REBRICKABLEID 76 - Speckle DBGray-Silver")));
        INTERNAL.add(new LDICColor(77, -20131841, 0x333333FF, LDICColorProp.SOLID, "Light Pink", LDICColorHint.getHintsFromString("LEGOID 223 - Light Pink // BRICKLINKID 56 - Light Pink // REBRICKABLEID 77 - Light Pink")));
        INTERNAL.add(new LDICColor(78, -3566081, 0x333333FF, LDICColorProp.SOLID, "Light Flesh", LDICColorHint.getHintsFromString("LEGOID 283 - Light Nougat // BRICKLINKID 90 - Light Flesh // REBRICKABLEID 78 - Light Flesh")));
        INTERNAL.add(new LDICColor(79, -286331152, -1162167568, LDICColorProp.SOLID, "Milky White", LDICColorHint.getHintsFromString("LEGOID 20 - Nature // BRICKLINKID 60 - Milky White // REBRICKABLEID 79 - Milky White")));
        INTERNAL.add(new LDICColor(80, 0x767676FF, 0x333333FF, LDICColorProp.METAL, "Metallic Silver", LDICColorHint.getHintsFromString("LEGOID 298 / 336 - Cool Silver Drum Lacq / Silver Ink // BRICKLINKID 67 - Metallic Silver // REBRICKABLEID 80 - Metallic Silver")));
        INTERNAL.add(new LDICColor(81, 1786332415, 0x333333FF, LDICColorProp.METAL, "Metallic Green", LDICColorHint.getHintsFromString("LEGOID 200 - Lemon Metallic // BRICKLINKID 70 - Metallic Green // REBRICKABLEID 81 - Metallic Green")));
        INTERNAL.add(new LDICColor(82, -609471233, 0x333333FF, LDICColorProp.METAL, "Metallic Gold", LDICColorHint.getHintsFromString("LEGOID 299 / 335 - Warm Gold Drum Lacq / Gold Ink // BRICKLINKID 65 - Metallic Gold // REBRICKABLEID 82 - Metallic Gold")));
        INTERNAL.add(new LDICColor(83, 169027583, 0x333333FF, LDICColorProp.METAL, "Metallic Black", LDICColorHint.getHintsFromString("LEGOID 149 - Metallic Black // REBRICKABLEID 148 - Pearl Dark Gray")));
        INTERNAL.add(new LDICColor(84, -1434626561, 0x333333FF, LDICColorProp.SOLID, "Medium Dark Flesh", LDICColorHint.getHintsFromString("LEGOID 312 - Medium Nougat // BRICKLINKID 150 - Medium Dark Flesh // REBRICKABLEID 84 - Medium Dark Flesh")));
        INTERNAL.add(new LDICColor(85, 1142591999, 0x333333FF, LDICColorProp.SOLID, "Medium Lilac", LDICColorHint.getHintsFromString("LEGOID 268 - Medium Lilac // REBRICKABLEID 85 - Dark Purple")));
        INTERNAL.add(new LDICColor(86, -1386135297, 0x333333FF, LDICColorProp.SOLID, "Dark Flesh", LDICColorHint.getHintsFromString("LEGOID 128 - Dark Nougat // BRICKLINKID 91 - Dark Flesh // REBRICKABLEID 86 - Dark Flesh")));
        INTERNAL.add(new LDICColor(87, 1835949311, 0x333333FF, LDICColorProp.METAL, "Metallic Dark Grey", LDICColorHint.getHintsFromString("LEGOID 337 - Titanium // REBRICKABLEID 148 - Pearl Dark Gray")));
        INTERNAL.add(new LDICColor(89, 475572223, 0x333333FF, LDICColorProp.SOLID, "Blue Violet", LDICColorHint.getHintsFromString("LEGOID 195 - Medium Royal Blue // BRICKLINKID 97 - Blue-Violet // REBRICKABLEID 89 - Royal Blue")));
        INTERNAL.add(new LDICColor(92, -1149216001, 0x333333FF, LDICColorProp.SOLID, "Flesh", LDICColorHint.getHintsFromString("LEGOID 18 - Nougat // BRICKLINKID 28 - Flesh // REBRICKABLEID 92 - Flesh")));
        INTERNAL.add(new LDICColor(100, -105404929, 0x333333FF, LDICColorProp.SOLID, "Light Salmon", LDICColorHint.getHintsFromString("LEGOID 100 - Light Red // BRICKLINKID 26 - Light Salmon // REBRICKABLEID 100 - Light Salmon")));
        INTERNAL.add(new LDICColor(110, 642161407, 0x333333FF, LDICColorProp.SOLID, "Violet", LDICColorHint.getHintsFromString("LEGOID 110 - Bright Bluish Violet // BRICKLINKID 43 - Violet // REBRICKABLEID 110 - Violet")));
        INTERNAL.add(new LDICColor(112, 1214360831, 0x333333FF, LDICColorProp.SOLID, "Medium Violet", LDICColorHint.getHintsFromString("LEGOID 112 - Medium Bluish Violet // BRICKLINKID 73 - Medium Violet // REBRICKABLEID 112 / 1001 - Blue-Violet / Medium Violet")));
        INTERNAL.add(new LDICColor(114, -546925184, -1188601984, LDICColorProp.SOLID, "Glitter Trans Dark Pink", LDICColorHint.getHintsFromString("LEGOID 114 - Tr. Medium Reddish-Violet w. Glitter 2% // BRICKLINKID 100 - Glitter Trans-Dark Pink // REBRICKABLEID 114 - Glitter Trans-Dark Pink")));
        INTERNAL.add(new LDICColor(115, -1210833409, 0x333333FF, LDICColorProp.SOLID, "Medium Lime", LDICColorHint.getHintsFromString("LEGOID 115 - Medium Yellowish Green // BRICKLINKID 76 - Medium Lime // REBRICKABLEID 115 - Medium Lime")));
        INTERNAL.add(new LDICColor(117, -286331264, -1162167680, LDICColorProp.SOLID, "Glitter Trans Clear", LDICColorHint.getHintsFromString("LEGOID 117 - Transparent Glitter // BRICKLINKID 101 - Glitter Trans-Clear // REBRICKABLEID 117 - Glitter Trans-Clear")));
        INTERNAL.add(new LDICColor(118, -1663644417, 0x333333FF, LDICColorProp.SOLID, "Aqua", LDICColorHint.getHintsFromString("LEGOID 118 - Light Bluish Green // BRICKLINKID 41 - Aqua // REBRICKABLEID 118 - Aqua")));
        INTERNAL.add(new LDICColor(120, -555052289, 0x333333FF, LDICColorProp.SOLID, "Light Lime", LDICColorHint.getHintsFromString("LEGOID 120 - Light Yellowish Green // BRICKLINKID 35 - Light Lime // REBRICKABLEID 120 - Light Lime")));
        INTERNAL.add(new LDICColor(125, -106465281, 0x333333FF, LDICColorProp.SOLID, "Light Orange", LDICColorHint.getHintsFromString("LEGOID 125 - Light Orange // BRICKLINKID 32 - Light Orange // REBRICKABLEID 125 - Light Orange")));
        INTERNAL.add(new LDICColor(128, -1386135297, 0x333333FF, LDICColorProp.SOLID, "Dark Nougat", LDICColorHint.getHintsFromString("LEGOID 128 - Dark Nougat // REBRICKABLEID 366 - Earth Orange")));
        INTERNAL.add(new LDICColor(134, 1984773119, 0x333333FF, LDICColorProp.PEARLESCENT, "Copper", LDICColorHint.getHintsFromString("LEGOID 139 - Copper // BRICKLINKID 84 - Copper // REBRICKABLEID 134 - Copper")));
        INTERNAL.add(new LDICColor(135, -1600085761, 0x333333FF, LDICColorProp.PEARLESCENT, "Pearl Light Grey", LDICColorHint.getHintsFromString("LEGOID 179 / 296 / 131 / 315 - Silver Flip-flop / Cool Silver / Silver / Silver Metallic // BRICKLINKID 66 - Pearl Light Gray // REBRICKABLEID 135 - Pearl Light Gray")));
        INTERNAL.add(new LDICColor(137, 1534431487, 0x333333FF, LDICColorProp.PEARLESCENT, "Metal Blue", LDICColorHint.getHintsFromString("LEGOID 145 - Sand Blue Metallic // BRICKLINKID 78 - Metal Blue // REBRICKABLEID 137 - Metal Blue")));
        INTERNAL.add(new LDICColor(142, -559126785, 0x333333FF, LDICColorProp.PEARLESCENT, "Pearl Light Gold", LDICColorHint.getHintsFromString("LEGOID 127 - Gold // BRICKLINKID 61 - Pearl Light Gold // REBRICKABLEID 142 - Pearl Light Gold")));
        INTERNAL.add(new LDICColor(148, 1213024511, 0x333333FF, LDICColorProp.PEARLESCENT, "Pearl Dark Grey", LDICColorHint.getHintsFromString("LEGOID 148 - Metallic Dark Grey // BRICKLINKID 77 - Pearl Dark Gray // REBRICKABLEID 148 - Pearl Dark Gray")));
        INTERNAL.add(new LDICColor(150, -1734632961, 0x333333FF, LDICColorProp.PEARLESCENT, "Pearl Very Light Grey", LDICColorHint.getHintsFromString("LEGOID 150 - Metallic Light Grey // BRICKLINKID 119 - Pearl Very Light Gray // REBRICKABLEID 150 - Pearl Very Light Gray")));
        INTERNAL.add(new LDICColor(151, -926365441, 0x333333FF, LDICColorProp.SOLID, "Very Light Bluish Grey", LDICColorHint.getHintsFromString("LEGOID 208 - Light Stone Grey // BRICKLINKID 99 - Very Light Bluish Gray // REBRICKABLEID 151 - Very Light Bluish Gray")));
        INTERNAL.add(new LDICColor(178, -2089660417, 0x333333FF, LDICColorProp.PEARLESCENT, "Flat Dark Gold", LDICColorHint.getHintsFromString("LEGOID 147 - Metallic Sand Yellow // BRICKLINKID 81 - Flat Dark Gold // REBRICKABLEID 178 - Flat Dark Gold")));
        INTERNAL.add(new LDICColor(179, -1987606273, 0x333333FF, LDICColorProp.PEARLESCENT, "Flat Silver", LDICColorHint.getHintsFromString("LEGOID 131 - Silver // BRICKLINKID 95 - Flat Silver // REBRICKABLEID 179 - Flat Silver")));
        INTERNAL.add(new LDICColor(183, -151855105, 0x333333FF, LDICColorProp.PEARLESCENT, "Pearl White", LDICColorHint.getHintsFromString("LEGOID 183 - Metallic White // BRICKLINKID 83 - Pearl White // REBRICKABLEID 183 - Pearl White")));
        INTERNAL.add(new LDICColor(184, -704633089, 0x333333FF, LDICColorProp.METAL, "Metallic Bright Red", LDICColorHint.getHintsFromString("LEGOID 184 - Metallic Bright Red // REBRICKABLEID 4 - Red")));
        INTERNAL.add(new LDICColor(186, 9321727, 0x333333FF, LDICColorProp.METAL, "Metallic Dark Green", LDICColorHint.getHintsFromString("LEGOID 186 - Metallic Dark Green // REBRICKABLEID 2 - Green")));
        INTERNAL.add(new LDICColor(189, -1400748033, 0x333333FF, LDICColorProp.PEARLESCENT, "Reddish Gold", LDICColorHint.getHintsFromString("LEGOID 189 - Reddish Gold")));
        INTERNAL.add(new LDICColor(191, -55836417, 0x333333FF, LDICColorProp.SOLID, "Bright Light Orange", LDICColorHint.getHintsFromString("LEGOID 191 - Flame Yellowish Orange // BRICKLINKID 110 - Bright Light Orange // REBRICKABLEID 191 - Bright Light Orange")));
        INTERNAL.add(new LDICColor(212, -1648101377, 0x333333FF, LDICColorProp.SOLID, "Bright Light Blue", LDICColorHint.getHintsFromString("LEGOID 212 - Light Royal Blue // BRICKLINKID 105 - Bright Light Blue // REBRICKABLEID 212 - Bright Light Blue")));
        INTERNAL.add(new LDICColor(216, -2027218945, 0x333333FF, LDICColorProp.SOLID, "Rust", LDICColorHint.getHintsFromString("LEGOID 216 - Rust // BRICKLINKID 27 - Rust // REBRICKABLEID 216 - Rust")));
        INTERNAL.add(new LDICColor(218, -1906993153, 0x333333FF, LDICColorProp.SOLID, "Reddish Lilac", LDICColorHint.getHintsFromString("LEGOID 218 - Reddish Lilac // REBRICKABLEID 1007 - Reddish Lilac")));
        INTERNAL.add(new LDICColor(219, 1447992831, 0x333333FF, LDICColorProp.SOLID, "Lilac", LDICColorHint.getHintsFromString("LEGOID 219 - Lilac // REBRICKABLEID 1001 - Medium Violet")));
        INTERNAL.add(new LDICColor(226, -1282817, 0x333333FF, LDICColorProp.SOLID, "Bright Light Yellow", LDICColorHint.getHintsFromString("LEGOID 226 - Cool Yellow // BRICKLINKID 103 - Bright Light Yellow // REBRICKABLEID 226 - Bright Light Yellow")));
        INTERNAL.add(new LDICColor(231, -55087744, -91878784, LDICColorProp.SOLID, "Trans Bright Light Orange", LDICColorHint.getHintsFromString("LEGOID 231 - Transparent Flame Yellowish Orange // REBRICKABLEID 1004 - Trans Flame Yellowish Orange")));
        INTERNAL.add(new LDICColor(232, 2009716991, 0x333333FF, LDICColorProp.SOLID, "Sky Blue", LDICColorHint.getHintsFromString("LEGOID 232 - Dove Blue // BRICKLINKID 87 - Sky Blue // REBRICKABLEID 232 - Sky Blue")));
        INTERNAL.add(new LDICColor(234, -68644736, -137221248, LDICColorProp.SOLID, "Trans Fire Yellow", LDICColorHint.getHintsFromString("LEGOID 234 - Transparent Fire Yellow")));
        INTERNAL.add(new LDICColor(256, 455750911, -2139062017, LDICColorProp.RUBBER, "Rubber Black", LDICColorHint.getHintsFromString("REBRICKABLEID 0 - Black")));
        INTERNAL.add(new LDICColor(272, 422730495, 0x333333FF, LDICColorProp.SOLID, "Dark Blue", LDICColorHint.getHintsFromString("LEGOID 140 - Earth Blue // BRICKLINKID 63 - Dark Blue // REBRICKABLEID 272 - Dark Blue")));
        INTERNAL.add(new LDICColor(273, 509257983, 0x333333FF, LDICColorProp.RUBBER, "Rubber Blue", LDICColorHint.getHintsFromString("")));
        INTERNAL.add(new LDICColor(284, -1031690880, -1807257216, LDICColorProp.SOLID, "Trans Reddish Lilac", LDICColorHint.getHintsFromString("LEGOID 284 - Transparent Reddish Lilac // REBRICKABLEID 236 - Trans-Light Purple")));
        INTERNAL.add(new LDICColor(285, 2109903232, 1184193920, LDICColorProp.SOLID, "Trans Light Green", LDICColorHint.getHintsFromString("LEGOID 285 - Transparent Light Green // BRICKLINKID 221 - Trans-Light Green")));
        INTERNAL.add(new LDICColor(288, 4528895, -2139062017, LDICColorProp.SOLID, "Dark Green", LDICColorHint.getHintsFromString("LEGOID 141 - Earth Green // BRICKLINKID 80 - Dark Green // REBRICKABLEID 288 - Dark Green")));
        INTERNAL.add(new LDICColor(293, 1806427264, 612091520, LDICColorProp.SOLID, "Trans Light Blue Violet", LDICColorHint.getHintsFromString("LEGOID 293 - Transparent Light Royal Blue // REBRICKABLEID 1006 - Trans Light Royal Blue")));
        INTERNAL.add(new LDICColor(294, -1111052816, -1919061264, LDICColorProp.SOLID, "Glow In Dark Trans", LDICColorHint.getHintsFromString("LEGOID 50 - Phosphorescent White // BRICKLINKID 118 - Glow In Dark Trans // REBRICKABLEID 294 - Glow In Dark Trans")));
        INTERNAL.add(new LDICColor(295, -7027969, 0x333333FF, LDICColorProp.SOLID, "Flamingo Pink", LDICColorHint.getHintsFromString("LEGOID 295 - Flamingo Pink")));
        INTERNAL.add(new LDICColor(297, -1434505473, 0x333333FF, LDICColorProp.PEARLESCENT, "Pearl Gold", LDICColorHint.getHintsFromString("LEGOID 297 - Warm Gold // BRICKLINKID 115 - Pearl Gold // REBRICKABLEID 297 - Pearl Gold")));
        INTERNAL.add(new LDICColor(300, -1031842817, 0x333333FF, LDICColorProp.METAL, "Metallic Copper", LDICColorHint.getHintsFromString("LEGOID 300 / 334 - Copper Drum Lacq / Copper Ink")));
        INTERNAL.add(new LDICColor(302, -1360400512, 1506926208, LDICColorProp.SOLID, "Glitter Trans Light Blue", LDICColorHint.getHintsFromString("LEGOID 129 - Tr. Bright Bluish Violet w. Glitter 2% // BRICKLINKID 162 - Glitter Trans-Light Blue // REBRICKABLEID 1003 - Glitter Trans-Light Blue")));
        INTERNAL.add(new LDICColor(308, 891355391, -2139062017, LDICColorProp.SOLID, "Dark Brown", LDICColorHint.getHintsFromString("LEGOID 308 - Dark Brown // BRICKLINKID 120 - Dark Brown // REBRICKABLEID 308 - Dark Brown")));
        INTERNAL.add(new LDICColor(313, -1411776513, 0x333333FF, LDICColorProp.SOLID, "Maersk Blue", LDICColorHint.getHintsFromString("LEGOID 11 - Pastel Blue // BRICKLINKID 72 - Maersk Blue // REBRICKABLEID 313 - Maersk Blue")));
        INTERNAL.add(new LDICColor(320, 1912607487, 0x333333FF, LDICColorProp.SOLID, "Dark Red", LDICColorHint.getHintsFromString("LEGOID 154 - New Dark Red // BRICKLINKID 59 - Dark Red // REBRICKABLEID 320 - Dark Red")));
        INTERNAL.add(new LDICColor(321, 1184613375, 0x333333FF, LDICColorProp.SOLID, "Dark Azure", LDICColorHint.getHintsFromString("LEGOID 321 - Dark Azur // BRICKLINKID 153 - Dark Azure // REBRICKABLEID 321 - Dark Azure")));
        INTERNAL.add(new LDICColor(322, 1757668095, 0x333333FF, LDICColorProp.SOLID, "Medium Azure", LDICColorHint.getHintsFromString("LEGOID 322 - Medium Azur // BRICKLINKID 156 - Medium Azure // REBRICKABLEID 322 - Medium Azure")));
        INTERNAL.add(new LDICColor(323, -739054849, 0x333333FF, LDICColorProp.SOLID, "Light Aqua", LDICColorHint.getHintsFromString("LEGOID 323 - Aqua // BRICKLINKID 152 - Light Aqua // REBRICKABLEID 323 - Light Aqua")));
        INTERNAL.add(new LDICColor(324, -1275068161, 0x333333FF, LDICColorProp.RUBBER, "Rubber Red", LDICColorHint.getHintsFromString("")));
        INTERNAL.add(new LDICColor(326, -486958337, 0x333333FF, LDICColorProp.SOLID, "Yellowish Green", LDICColorHint.getHintsFromString("LEGOID 326 - Spring Yellowish Green // BRICKLINKID 158 - Yellowish Green")));
        INTERNAL.add(new LDICColor(329, -168568848, -522549776, LDICColorProp.SOLID, "Glow In Dark White", LDICColorHint.getHintsFromString("LEGOID 329 - White Glow // BRICKLINKID 159 - Glow In Dark White // REBRICKABLEID 1000 - Glow in Dark White")));
        INTERNAL.add(new LDICColor(330, 2004307711, 0x333333FF, LDICColorProp.SOLID, "Olive Green", LDICColorHint.getHintsFromString("LEGOID 330 - Olive Green // BRICKLINKID 155 - Olive Green // REBRICKABLEID 326 - Olive Green")));
        INTERNAL.add(new LDICColor(334, -540969217, -1030213889, LDICColorProp.CHROME, "Chrome Gold", LDICColorHint.getHintsFromString("LEGOID 310 - Metalized Gold // BRICKLINKID 21 - Chrome Gold // REBRICKABLEID 334 - Chrome Gold")));
        INTERNAL.add(new LDICColor(335, -2006950145, 0x333333FF, LDICColorProp.SOLID, "Sand Red", LDICColorHint.getHintsFromString("LEGOID 153 - Sand Red // BRICKLINKID 58 - Sand Red // REBRICKABLEID 335 - Sand Red")));
        INTERNAL.add(new LDICColor(339, -1057030016, 1939406976, LDICColorProp.SOLID, "Glitter Trans Neon Green", LDICColorHint.getHintsFromString("BRICKLINKID 163 - Glitter Trans-Neon Green // REBRICKABLEID 1002 - Glitter Trans-Neon Green")));
        INTERNAL.add(new LDICColor(350, -696704001, 0x333333FF, LDICColorProp.RUBBER, "Rubber Orange", LDICColorHint.getHintsFromString("")));
        INTERNAL.add(new LDICColor(351, -142233089, 0x333333FF, LDICColorProp.SOLID, "Medium Dark Pink", LDICColorHint.getHintsFromString("LEGOID 16 - Pink // BRICKLINKID 94 - Medium Dark Pink // REBRICKABLEID 351 - Medium Dark Pink")));
        INTERNAL.add(new LDICColor(353, -9603073, 0x333333FF, LDICColorProp.SOLID, "Coral", LDICColorHint.getHintsFromString("LEGOID 353 - Vibrant Coral // BRICKLINKID 220 - Coral // REBRICKABLEID 1050 - Coral")));
        INTERNAL.add(new LDICColor(366, -663933697, 0x333333FF, LDICColorProp.SOLID, "Earth Orange", LDICColorHint.getHintsFromString("LEGOID 12 - Light Orange Brown // BRICKLINKID 29 - Earth Orange // REBRICKABLEID 366 - Earth Orange")));
        INTERNAL.add(new LDICColor(373, 1969585663, 0x333333FF, LDICColorProp.SOLID, "Sand Purple", LDICColorHint.getHintsFromString("LEGOID 136 - Sand Violet // BRICKLINKID 54 - Sand Purple // REBRICKABLEID 373 - Sand Purple")));
        INTERNAL.add(new LDICColor(375, -1970106881, 0x333333FF, LDICColorProp.RUBBER, "Rubber Light Grey", LDICColorHint.getHintsFromString("")));
        INTERNAL.add(new LDICColor(378, 1888386303, 0x333333FF, LDICColorProp.SOLID, "Sand Green", LDICColorHint.getHintsFromString("LEGOID 151 - Sand Green // BRICKLINKID 48 - Sand Green // REBRICKABLEID 378 - Sand Green")));
        INTERNAL.add(new LDICColor(379, 1887542015, 0x333333FF, LDICColorProp.SOLID, "Sand Blue", LDICColorHint.getHintsFromString("LEGOID 135 - Sand Blue // BRICKLINKID 55 - Sand Blue // REBRICKABLEID 379 - Sand Blue")));
        INTERNAL.add(new LDICColor(383, -825307393, -1667457793, LDICColorProp.CHROME, "Chrome Silver", LDICColorHint.getHintsFromString("LEGOID 309 - Metalized Silver // BRICKLINKID 22 - Chrome Silver // REBRICKABLEID 383 - Chrome Silver")));
        INTERNAL.add(new LDICColor(406, 422730495, 0x333333FF, LDICColorProp.RUBBER, "Rubber Dark Blue", LDICColorHint.getHintsFromString("")));
        INTERNAL.add(new LDICColor(449, 1730118143, 0x333333FF, LDICColorProp.RUBBER, "Rubber Purple", LDICColorHint.getHintsFromString("")));
        INTERNAL.add(new LDICColor(450, -763935489, 0x333333FF, LDICColorProp.SOLID, "Fabuland Brown", LDICColorHint.getHintsFromString("LEGOID 4 - Brick Red // BRICKLINKID 106 - Fabuland Brown // REBRICKABLEID 450 - Fabuland Brown")));
        INTERNAL.add(new LDICColor(462, -175758081, 0x333333FF, LDICColorProp.SOLID, "Medium Orange", LDICColorHint.getHintsFromString("LEGOID 105 - Bright Yellowish Orange // BRICKLINKID 31 - Medium Orange // REBRICKABLEID 462 - Medium Orange")));
        INTERNAL.add(new LDICColor(484, -1857020673, 0x333333FF, LDICColorProp.SOLID, "Dark Orange", LDICColorHint.getHintsFromString("LEGOID 38 - Dark Orange // BRICKLINKID 68 - Dark Orange // REBRICKABLEID 484 - Dark Orange")));
        INTERNAL.add(new LDICColor(490, -1513481985, 0x333333FF, LDICColorProp.RUBBER, "Rubber Lime", LDICColorHint.getHintsFromString("")));
        INTERNAL.add(new LDICColor(493, 1701274111, 0x333333FF, LDICColorProp.METAL, "Magnet", LDICColorHint.getHintsFromString("LEGOID 109 - Black IR")));
        INTERNAL.add(new LDICColor(494, -791621377, 0x333333FF, LDICColorProp.METAL, "Electric Contact Alloy", LDICColorHint.getHintsFromString("")));
        INTERNAL.add(new LDICColor(495, -1367713281, 0x333333FF, LDICColorProp.METAL, "Electric Contact Copper", LDICColorHint.getHintsFromString("")));
        INTERNAL.add(new LDICColor(496, -1768515841, 0x333333FF, LDICColorProp.RUBBER, "Rubber Light Bluish Grey", LDICColorHint.getHintsFromString("")));
        INTERNAL.add(new LDICColor(503, -1129011713, 0x333333FF, LDICColorProp.SOLID, "Very Light Grey", LDICColorHint.getHintsFromString("LEGOID 103 - Light Grey // BRICKLINKID 49 - Very Light Gray // REBRICKABLEID 503 - Very Light Gray")));
        INTERNAL.add(new LDICColor(504, -1987606273, 0x333333FF, LDICColorProp.RUBBER, "Rubber Flat Silver", LDICColorHint.getHintsFromString("")));
        INTERNAL.add(new LDICColor(507, -90432257, 0x333333FF, LDICColorProp.SOLID, "Light Orange Brown", LDICColorHint.getHintsFromString("LEGOID 12 - Light Orange Brown")));
        INTERNAL.add(new LDICColor(508, -8383233, 0x333333FF, LDICColorProp.SOLID, "Fabuland Red", LDICColorHint.getHintsFromString("LEGOID 13 - Red Orange")));
        INTERNAL.add(new LDICColor(509, -813021185, 0x333333FF, LDICColorProp.SOLID, "Fabuland Orange", LDICColorHint.getHintsFromString("LEGOID 19 - Light Brown // BRICKLINKID 160 - Fabuland Orange")));
        INTERNAL.add(new LDICColor(510, 2029811967, 0x333333FF, LDICColorProp.SOLID, "Fabuland Pastel Green", LDICColorHint.getHintsFromString("LEGOID 14 - Pastel Green")));
        INTERNAL.add(new LDICColor(511, -185273089, 0x333333FF, LDICColorProp.RUBBER, "Rubber White", LDICColorHint.getHintsFromString("")));
        INTERNAL.add(new LDICColor(10002, 1487618559, 0x333333FF, LDICColorProp.RUBBER, "Rubber Bright Green", LDICColorHint.getHintsFromString("")));
        INTERNAL.add(new LDICColor(10026, -1876986113, 0x333333FF, LDICColorProp.RUBBER, "Rubber Magenta", LDICColorHint.getHintsFromString("")));
        INTERNAL.add(new LDICColor(10030, -1603356161, 0x333333FF, LDICColorProp.RUBBER, "Rubber Medium Lavender", LDICColorHint.getHintsFromString("")));
        INTERNAL.add(new LDICColor(10031, -844833025, 0x333333FF, LDICColorProp.RUBBER, "Rubber Lavender", LDICColorHint.getHintsFromString("")));
        INTERNAL.add(new LDICColor(10047, -240, -240, LDICColorProp.SOLID, "Trans Sticker", LDICColorHint.getHintsFromString("")));
        INTERNAL.add(new LDICColor(10070, 1597049343, -2139062017, LDICColorProp.RUBBER, "Rubber Reddish Brown", LDICColorHint.getHintsFromString("")));
        INTERNAL.add(new LDICColor(10226, -1282817, 0x333333FF, LDICColorProp.RUBBER, "Rubber Bright Light Yellow", LDICColorHint.getHintsFromString("")));
        INTERNAL.add(new LDICColor(10308, 891355391, -2139062017, LDICColorProp.RUBBER, "Rubber Dark Brown", LDICColorHint.getHintsFromString("")));
        INTERNAL.add(new LDICColor(10320, 1912607487, 0x333333FF, LDICColorProp.RUBBER, "Rubber Dark Red", LDICColorHint.getHintsFromString("")));
        INTERNAL.add(new LDICColor(10321, 1184613375, 0x333333FF, LDICColorProp.RUBBER, "Rubber Dark Azure", LDICColorHint.getHintsFromString("")));
        INTERNAL.add(new LDICColor(10322, 1757668095, 0x333333FF, LDICColorProp.RUBBER, "Rubber Medium Azure", LDICColorHint.getHintsFromString("")));
        INTERNAL.add(new LDICColor(10323, -739054849, 0x333333FF, LDICColorProp.RUBBER, "Rubber Light Aqua", LDICColorHint.getHintsFromString("")));
        INTERNAL.add(new LDICColor(10484, -1857020673, 0x333333FF, LDICColorProp.RUBBER, "Rubber Dark Orange", LDICColorHint.getHintsFromString("")));
        return INTERNAL;
    }
}

