/*
 * Decompiled with CFR 0.152.
 */
package ldinsp.colldet;

import ldinsp.colldet.Line;
import ldinsp.colldet.Tri;
import ldinsp.colldet.UnexpectedCaseException;
import ldinsp.ldraw.LDrawPoint;

class LineSeg {
    private final Line line;
    private int index;
    private double startDist;
    private double endDist;

    protected LineSeg(Line rline, Tri face, int sign1, int sign2, int sign3) throws UnexpectedCaseException {
        this.line = rline;
        this.index = 0;
        if (sign1 == 0) {
            this.setVertex(face.v1);
        } else if (sign2 == 0) {
            this.setVertex(face.v2);
        } else if (sign3 == 0) {
            this.setVertex(face.v3);
        }
        if ((sign1 ^ sign2) == -2) {
            this.setEdge(face.v1, face.v2);
        }
        if ((sign2 ^ sign3) == -2) {
            this.setEdge(face.v2, face.v3);
        }
        if ((sign1 ^ sign3) == -2) {
            this.setEdge(face.v3, face.v1);
        }
    }

    protected double getStartDistance() {
        return this.startDist;
    }

    protected double getEndDistance() {
        return this.endDist;
    }

    private void setVertex(LDrawPoint vertex) throws UnexpectedCaseException {
        double dist = this.line.computePointToPointDistance(vertex);
        if (this.index == 0) {
            this.startDist = dist;
            ++this.index;
        } else if (this.index == 1) {
            this.endDist = dist;
            ++this.index;
            if (this.startDist > this.endDist) {
                this.swapEnds();
            }
        } else {
            throw new UnexpectedCaseException("more than two vertices in segment.setVertex");
        }
    }

    private void setEdge(LDrawPoint vertex1, LDrawPoint vertex2) throws UnexpectedCaseException {
        LDrawPoint edgeDirection = vertex2.subtract(vertex1);
        Line edgeLine = new Line(edgeDirection, vertex1);
        LDrawPoint pos = this.line.computeLineIntersection(edgeLine);
        if (pos == null) {
            throw new UnexpectedCaseException("intersecting face vertices do not intersect");
        }
        double dist = this.line.computePointToPointDistance(pos);
        if (this.index == 0) {
            this.startDist = dist;
            ++this.index;
        } else if (this.index == 1) {
            this.endDist = dist;
            ++this.index;
            if (this.startDist > this.endDist) {
                this.swapEnds();
            }
        } else {
            throw new UnexpectedCaseException("more than two vertices in segment.setVertex");
        }
    }

    private void swapEnds() {
        double distTemp = this.startDist;
        this.startDist = this.endDist;
        this.endDist = distTemp;
    }
}

