/*
 * Decompiled with CFR 0.152.
 */
package ldinsp.colldet;

import ldinsp.ldraw.LDrawPoint;

class Bound {
    private double xMax;
    private double xMin;
    private double yMax;
    private double yMin;
    private double zMax;
    private double zMin;

    protected Bound() {
        this.zMax = -1.7976931348623157E308;
        this.yMax = -1.7976931348623157E308;
        this.xMax = -1.7976931348623157E308;
        this.zMin = Double.MAX_VALUE;
        this.yMin = Double.MAX_VALUE;
        this.xMin = Double.MAX_VALUE;
    }

    protected Bound(LDrawPoint p1, LDrawPoint p2, LDrawPoint p3) {
        this.xMax = this.xMin = p1.x;
        this.yMax = this.yMin = p1.y;
        this.zMax = this.zMin = p1.z;
        this.addVertex(p2);
        this.addVertex(p3);
    }

    protected void addBound(Bound o) {
        if (o.xMax > this.xMax) {
            this.xMax = o.xMax;
        }
        if (o.xMin < this.xMin) {
            this.xMin = o.xMin;
        }
        if (o.yMax > this.yMax) {
            this.yMax = o.yMax;
        }
        if (o.yMin < this.yMin) {
            this.yMin = o.yMin;
        }
        if (o.zMax > this.zMax) {
            this.zMax = o.zMax;
        }
        if (o.zMin < this.zMin) {
            this.zMin = o.zMin;
        }
    }

    protected void addVertex(LDrawPoint vertex) {
        if (vertex.x > this.xMax) {
            this.xMax = vertex.x;
        }
        if (vertex.x < this.xMin) {
            this.xMin = vertex.x;
        }
        if (vertex.y > this.yMax) {
            this.yMax = vertex.y;
        }
        if (vertex.y < this.yMin) {
            this.yMin = vertex.y;
        }
        if (vertex.z > this.zMax) {
            this.zMax = vertex.z;
        }
        if (vertex.z < this.zMin) {
            this.zMin = vertex.z;
        }
    }

    protected boolean overlap(Bound bound, double tolerance) {
        return this.xMin < bound.xMax - tolerance && this.xMax > bound.xMin + tolerance && this.yMin < bound.yMax - tolerance && this.yMax > bound.yMin + tolerance && this.zMin < bound.zMax - tolerance && this.zMax > bound.zMin + tolerance;
    }
}

