/*
 * Decompiled with CFR 0.152.
 */
package ldinsp.check;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import ldinsp.base.LDIWorker;
import ldinsp.check.LDICheck;
import ldinsp.check.LDICheckMessage;
import ldinsp.check.LDICheckSolve;
import ldinsp.check.LDICheckSolveHint;
import ldinsp.check.LDICheckState;
import ldinsp.context.LDICColor;
import ldinsp.context.LDIContext;
import ldinsp.ldraw.LDrawLine;
import ldinsp.ldraw.LDrawLinePartRef;
import ldinsp.ldraw.LDrawPart;

public class LDICRubberColor
extends LDICheck {
    private LDICheckState resState = LDICheckState.OK;
    private String resShort;
    private String resLong;
    private HashMap<LDrawLine, ArrayList<LDICheckMessage>> partErrors;
    private ArrayList<LDICheckSolve> solver;

    public LDICRubberColor(LDIContext ctx, LDrawPart part) {
        HashSet<String> checked = new HashSet<String>();
        StringBuffer lrsb = new StringBuffer();
        this.checkPart(ctx, part, checked, lrsb);
        if (part.subParts != null) {
            for (LDrawPart sb : part.subParts) {
                this.checkPart(ctx, sb, checked, lrsb);
            }
        }
        if (this.resState == LDICheckState.OK) {
            this.resShort = "  ok : all tires/hoses have rubber color\n";
        } else {
            this.resShort = " hint: at least one tire/hose may have non-rubber color\n";
            this.solver = new ArrayList();
            this.solver.add(new LDICheckSolveHint("Rubber", "Tires/hoses may habe rubber color"));
        }
        this.resLong = lrsb.toString();
    }

    @Override
    public LDICheckState getState() {
        return this.resState;
    }

    @Override
    public String getShortResult() {
        return this.resShort;
    }

    @Override
    public String getLongResult() {
        return this.resLong;
    }

    @Override
    public List<LDICheckSolve> getSolver() {
        return this.solver;
    }

    @Override
    public HashMap<LDrawLine, ArrayList<LDICheckMessage>> getPartErrors() {
        return this.partErrors;
    }

    private void checkPart(final LDIContext ctx, final LDrawPart part, final HashSet<String> checked, final StringBuffer lrsb) {
        LDIWorker w = new LDIWorker(){

            @Override
            public LDrawPart handlePartRef(LDrawLinePartRef ref, String partName, int colId, int pcol) {
                String lcd;
                LDrawPart res = ctx.getPart(part, partName, null);
                if (res == null) {
                    return null;
                }
                if (res.description != null && ((lcd = res.description.toLowerCase()).contains("tyre") || lcd.contains("tire") || lcd.contains("hose"))) {
                    LDICColor c = ctx.getColorById(colId == 16 ? pcol : colId);
                    if (!c.name.toLowerCase().contains("rubber")) {
                        if (!checked.contains(partName)) {
                            lrsb.append("hint: perhaps tire/hose used with non-rubber color " + c.id + " (" + c.name + ") for " + partName + " (" + res.description + ") in line " + ref.lineNr + "\n");
                            checked.add(partName);
                            LDICRubberColor.this.resState = LDICheckState.HINT;
                        }
                        LDICRubberColor.this.partErrors = LDICRubberColor.addPartError(LDICRubberColor.this.partErrors, ref, "perhaps rubber color is better", 1);
                    }
                }
                return null;
            }
        };
        w.work(part);
    }
}

