/*
 * Decompiled with CFR 0.152.
 */
package ldinsp.check;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import ldinsp.base.LDIWorker;
import ldinsp.check.LDICheck;
import ldinsp.check.LDICheckMessage;
import ldinsp.check.LDICheckSolve;
import ldinsp.check.LDICheckSolveFix;
import ldinsp.check.LDICheckState;
import ldinsp.context.LDIContext;
import ldinsp.ldraw.LDrawEdit;
import ldinsp.ldraw.LDrawLine;
import ldinsp.ldraw.LDrawLinePartRef;
import ldinsp.ldraw.LDrawPart;

public class LDICMovedParts
extends LDICheck {
    private LDICheckState resState = LDICheckState.OK;
    private String resShort;
    private String resLong;
    private HashMap<LDrawLine, ArrayList<LDICheckMessage>> partErrors;
    private ArrayList<LDICheckSolve> solver;

    public LDICMovedParts(final LDIContext ctx, final LDrawPart part) {
        HashSet<String> checked = new HashSet<String>();
        StringBuffer lrsb = new StringBuffer();
        this.checkPart(ctx, part, checked, lrsb);
        if (part.subParts != null) {
            for (LDrawPart sb : part.subParts) {
                this.checkPart(ctx, sb, checked, lrsb);
            }
        }
        if (this.resState == LDICheckState.OK) {
            this.resShort = "  ok : no moved parts\n";
        } else {
            this.resShort = " warn: contains moved parts\n";
            this.solver = new ArrayList();
            this.solver.add(new LDICheckSolveFix("Moved", "Resolve moved parts"){

                @Override
                public int fix() {
                    return LDrawEdit.resolveMoved(part, ctx, true);
                }
            });
        }
        this.resLong = lrsb.toString();
    }

    @Override
    public LDICheckState getState() {
        return this.resState;
    }

    @Override
    public String getShortResult() {
        return this.resShort;
    }

    @Override
    public String getLongResult() {
        return this.resLong;
    }

    @Override
    public List<LDICheckSolve> getSolver() {
        return this.solver;
    }

    @Override
    public HashMap<LDrawLine, ArrayList<LDICheckMessage>> getPartErrors() {
        return this.partErrors;
    }

    private void checkPart(final LDIContext ctx, LDrawPart part, final HashSet<String> checked, final StringBuffer lrsb) {
        LDIWorker w = new LDIWorker(){

            @Override
            public LDrawPart handlePartRef(LDrawLinePartRef ref, String partName, int colId, int pcol) {
                LDrawPart res = ctx.getPart(null, partName, null);
                if (res == null) {
                    return null;
                }
                if (!checked.contains(partName)) {
                    checked.add(partName);
                    String desc = res.description;
                    if (desc != null && desc.toLowerCase().startsWith("~moved to ")) {
                        LDICMovedParts.this.resState = LDICheckState.WARN;
                        lrsb.append("used part " + partName + " in line " + ref.lineNr + " has description " + res.description + "\n");
                        LDICMovedParts.this.partErrors = LDICMovedParts.addPartError(LDICMovedParts.this.partErrors, ref, "part " + partName + " is moved", 3);
                    }
                }
                return null;
            }
        };
        w.work(part);
    }
}

