/*
 * Decompiled with CFR 0.152.
 */
package ldinsp.check;

import java.util.ArrayList;
import java.util.List;
import ldinsp.check.LDICheck;
import ldinsp.check.LDICheckSolve;
import ldinsp.check.LDICheckSolveFix;
import ldinsp.check.LDICheckSolveHint;
import ldinsp.check.LDICheckState;
import ldinsp.context.LDIContext;
import ldinsp.ldraw.LDrawEdit;
import ldinsp.ldraw.LDrawLine;
import ldinsp.ldraw.LDrawPart;

public class LDICHeader
extends LDICheck {
    private LDICheckState resState = LDICheckState.OK;
    private String resShort;
    private String resLong;
    private ArrayList<LDICheckSolve> solver;

    public LDICHeader(LDIContext ctx, LDrawPart part) {
        StringBuffer lrsb = new StringBuffer();
        final ArrayList<LDrawPart> rewrite = new ArrayList<LDrawPart>();
        this.doCheckKeyHeaderLines(part, rewrite, lrsb);
        if (part.subParts != null) {
            for (LDrawPart sb : part.subParts) {
                this.doCheckKeyHeaderLines(sb, rewrite, lrsb);
            }
        }
        if (this.resState == LDICheckState.OK) {
            this.resShort = "  ok : all headers complete and in order\n";
        } else {
            this.resShort = this.resState == LDICheckState.WARN ? " warn: at least one (sub)part could have other header line order\n" : "error: at least one (sub)part has not all, invalid or out-of-order header lines\n";
            this.solver = new ArrayList();
            this.solver.add(new LDICheckSolveHint("Header", "Fix header lines"));
            if (ctx.getDefaultAuthor() != null) {
                this.solver.add(new LDICheckSolveFix("Header", "Rewrite header lines"){

                    @Override
                    public int fix() {
                        int cnt = 0;
                        int i = 0;
                        while (i < rewrite.size()) {
                            cnt += LDrawEdit.rewriteHeader((LDrawPart)rewrite.get(i), i + 1 == rewrite.size());
                            ++i;
                        }
                        return cnt;
                    }
                });
            }
        }
        this.resLong = lrsb.toString();
    }

    @Override
    public LDICheckState getState() {
        return this.resState;
    }

    @Override
    public String getShortResult() {
        return this.resShort;
    }

    @Override
    public String getLongResult() {
        return this.resLong;
    }

    @Override
    public List<LDICheckSolve> getSolver() {
        return this.solver;
    }

    private void doCheckKeyHeaderLines(LDrawPart part, ArrayList<LDrawPart> rewrite, StringBuffer lrsb) {
        boolean hadDescription = false;
        boolean hadName = false;
        boolean hadAuthor = false;
        boolean needsRewrite = false;
        boolean alreadyPrintedNonHeader = false;
        for (LDrawLine line : part.content) {
            if (line.source == null || line.source.length() == 0) continue;
            if (line.headerKey == null) {
                if (hadDescription) {
                    this.resState = this.resState.combine(LDICheckState.WARN);
                    if (!alreadyPrintedNonHeader) {
                        lrsb.append("warn: " + part.getBestFilename() + " in line " + line.lineNr + " has non-header line before header is complete\n");
                        alreadyPrintedNonHeader = true;
                    }
                } else {
                    this.resState = this.resState.combine(LDICheckState.ERROR);
                    if (!alreadyPrintedNonHeader) {
                        lrsb.append(String.valueOf(part.getBestFilename()) + " in line " + line.lineNr + " has non-header line before description\n");
                        alreadyPrintedNonHeader = true;
                    }
                }
                rewrite.add(part);
            } else {
                switch (line.headerKey) {
                    case FILE: {
                        break;
                    }
                    case DESCRIPTION: {
                        if (hadName || hadAuthor) {
                            this.resState = this.resState.combine(LDICheckState.WARN);
                            needsRewrite = true;
                            lrsb.append("warn: " + part.getBestFilename() + " has description in line " + line.lineNr + " after name/author\n");
                        }
                        hadDescription = true;
                        break;
                    }
                    case NAME: {
                        if (hadAuthor) {
                            this.resState = this.resState.combine(LDICheckState.WARN);
                            needsRewrite = true;
                            lrsb.append("warn: " + part.getBestFilename() + " has name in line " + line.lineNr + " after author\n");
                        }
                        hadName = true;
                        break;
                    }
                    case AUTHOR: {
                        hadAuthor = true;
                        break;
                    }
                    default: {
                        lrsb.append("internal error in LDICHeader check\n");
                        return;
                    }
                }
            }
            if (hadDescription && hadName && hadAuthor) break;
        }
        if (!(hadDescription && hadName && hadAuthor)) {
            this.resState = this.resState.combine(LDICheckState.ERROR);
            lrsb.append(String.valueOf(part.getBestFilename()) + " has not all description, name, author meta lines in header\n");
            needsRewrite = true;
        }
        if (needsRewrite) {
            rewrite.add(part);
        }
    }
}

