/*
 * Decompiled with CFR 0.152.
 */
package ldinsp.check;

import java.util.ArrayList;
import java.util.List;
import ldinsp.check.LDICheck;
import ldinsp.check.LDICheckSolve;
import ldinsp.check.LDICheckSolveFix;
import ldinsp.check.LDICheckSolveHint;
import ldinsp.check.LDICheckState;
import ldinsp.context.LDIContext;
import ldinsp.ldraw.LDrawEdit;
import ldinsp.ldraw.LDrawPart;

public class LDICFiletype
extends LDICheck {
    private LDICheckState resState = LDICheckState.OK;
    private String resShort;
    private String resLong;
    private ArrayList<LDICheckSolve> solver;

    public LDICFiletype(LDIContext ctx, final LDrawPart part) {
        boolean isSubPart;
        StringBuffer lrsb = new StringBuffer();
        this.solver = new ArrayList();
        final LDrawPart owner = part.owner;
        boolean hasSubParts = part.subParts != null && part.subParts.size() > 0;
        boolean bl = isSubPart = owner != part;
        if (owner.loadedFromFilename != null) {
            if (owner.loadedFromFilename.toLowerCase().endsWith(".mpd")) {
                if (part.givenFilename == null || part.givenFilename.length() == 0) {
                    this.resState = LDICheckState.WARN;
                    lrsb.append("owner part filename " + owner.loadedFromFilename + " ends with .mpd, but main model header has no FILE attribute\n");
                    this.solver.add(new LDICheckSolveFix("Insert FILE", "Insert FILE attribute in header"){

                        @Override
                        public int fix() {
                            String targetname = LDICFiletype.this.getLeafFilename(owner.loadedFromFilename);
                            int lastDot = targetname.lastIndexOf(46);
                            if (lastDot > 0 && lastDot >= targetname.length() - 4) {
                                targetname = targetname.substring(0, lastDot);
                            }
                            targetname = String.valueOf(targetname) + ".ldr";
                            return LDrawEdit.addGivenFilename(part, targetname);
                        }
                    });
                }
            } else if (hasSubParts || isSubPart) {
                this.resState = LDICheckState.ERROR;
                lrsb.append("owner part has sub parts but its filename does not ends with .mpd\n");
                this.solver.add(new LDICheckSolveHint("Rename file", "Please rename the file to have .mpd ending"));
            } else if (!this.isLdrOrDat(owner.loadedFromFilename)) {
                this.resState = LDICheckState.ERROR;
                lrsb.append("filename does not end with .ldr or .dat\n");
                this.solver.add(new LDICheckSolveHint("Rename file", "Please rename the file to have .mpd, .ldr or .dat ending"));
            }
        }
        if (part.givenFilename != null && !this.isLdrOrDat(part.givenFilename)) {
            this.resState = LDICheckState.ERROR;
            lrsb.append("given filename \"" + part.givenFilename + "\" does not end with .ldr or .dat\n");
            this.solver.add(new LDICheckSolveHint("Rename file", "Please rename the given filename to have .ldr or .dat ending"));
        }
        if (hasSubParts) {
            for (LDrawPart sb : part.subParts) {
                if (this.isLdrOrDat(sb.givenFilename)) continue;
                this.resState = LDICheckState.ERROR;
                lrsb.append("given filename \"" + sb.givenFilename + "\" of sub-part does not end with .ldr or .dat\n");
                this.solver.add(new LDICheckSolveHint("Rename file", "Please rename the given sub-part filename to have .ldr or .dat ending"));
            }
        }
        switch (this.resState) {
            case OK: {
                this.resShort = "  ok : filetypes valid\n";
                break;
            }
            case WARN: {
                this.resShort = " warn: filetypes or headers may be optimized\n";
                break;
            }
            case ERROR: {
                this.resShort = "error: filetypes invalid\n";
                break;
            }
            default: {
                this.resShort = "inter: internal error in LDICFiletype\n";
            }
        }
        if (this.solver.size() == 0) {
            this.solver = null;
        }
        this.resLong = lrsb.toString();
    }

    @Override
    public LDICheckState getState() {
        return this.resState;
    }

    @Override
    public String getShortResult() {
        return this.resShort;
    }

    @Override
    public String getLongResult() {
        return this.resLong;
    }

    @Override
    public List<LDICheckSolve> getSolver() {
        return this.solver;
    }

    private String getLeafFilename(String filename) {
        int lastSlash = filename.replace('\\', '/').lastIndexOf(47);
        if (lastSlash < 0) {
            return filename;
        }
        return filename.substring(lastSlash + 1);
    }

    private boolean isLdrOrDat(String filename) {
        String loli = filename.toLowerCase();
        return loli.endsWith(".ldr") || loli.endsWith(".dat");
    }
}

