/*
 * Decompiled with CFR 0.152.
 */
package ldinsp.check;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import ldinsp.base.LDIWorker;
import ldinsp.check.LDICheck;
import ldinsp.check.LDICheckMessage;
import ldinsp.check.LDICheckSolve;
import ldinsp.check.LDICheckSolveHint;
import ldinsp.check.LDICheckState;
import ldinsp.colldet.Object3D;
import ldinsp.context.LDIContext;
import ldinsp.ldraw.LDrawLine;
import ldinsp.ldraw.LDrawLinePartRef;
import ldinsp.ldraw.LDrawLineQuad;
import ldinsp.ldraw.LDrawLineTri;
import ldinsp.ldraw.LDrawMatrix;
import ldinsp.ldraw.LDrawPart;
import ldinsp.ldraw.LDrawPoint;

public class LDICCollidingParts
extends LDICheck {
    public static final double TEST_TOLERANCE = 0.1;
    private LDICheckState resState = LDICheckState.OK;
    private String resShort;
    private String resLong;
    private HashMap<LDrawLine, ArrayList<LDICheckMessage>> partErrors;
    private ArrayList<LDICheckSolve> solver;

    public LDICCollidingParts(LDIContext ctx, LDrawPart part) {
        if (this.isDat(part)) {
            this.resState = LDICheckState.IGN;
            this.resShort = " ign : file ends with .dat and is therefore not checked for colliding parts\n";
            this.resLong = "";
            return;
        }
        StringBuffer lrsb = new StringBuffer();
        HashMap<Object3D, LDrawLinePartRef> objMap = this.buildObjects(ctx, part, lrsb);
        ArrayList<Object3D> objs = new ArrayList<Object3D>(objMap.keySet());
        int i = 1;
        while (i < objs.size()) {
            Object3D o1 = objs.get(i);
            int j = 0;
            while (j < i) {
                Object3D o2 = objs.get(j);
                if (o1.countIntersectingFaces(o2, 0.1) > 0) {
                    LDrawLinePartRef r1 = objMap.get(o1);
                    LDrawLinePartRef r2 = objMap.get(o2);
                    if (r1.lineNr < r2.lineNr) {
                        LDrawLinePartRef tmp = r1;
                        r1 = r2;
                        r2 = tmp;
                    }
                    this.resState = LDICheckState.ERROR;
                    lrsb.append("part " + r1.refname + " in line " + r1.lineNr + " collides with part " + r2.refname + " in line " + r2.lineNr + "\n");
                    this.partErrors = LDICCollidingParts.addPartError(this.partErrors, r1, "collides", 4);
                    this.partErrors = LDICCollidingParts.addPartError(this.partErrors, r2, "collides", 4);
                }
                ++j;
            }
            ++i;
        }
        if (this.resState == LDICheckState.OK) {
            this.resShort = "  ok : no colliding parts\n";
        } else {
            this.resShort = "error: contains colliding parts\n";
            this.solver = new ArrayList();
            this.solver.add(new LDICheckSolveHint("Collision", "Check part placement"));
        }
        this.resLong = lrsb.toString();
    }

    @Override
    public LDICheckState getState() {
        return this.resState;
    }

    @Override
    public String getShortResult() {
        return this.resShort;
    }

    @Override
    public String getLongResult() {
        return this.resLong;
    }

    @Override
    public List<LDICheckSolve> getSolver() {
        return this.solver;
    }

    @Override
    public HashMap<LDrawLine, ArrayList<LDICheckMessage>> getPartErrors() {
        return this.partErrors;
    }

    private boolean isDat(LDrawPart part) {
        return part.loadedFromFilename != null && part.loadedFromFilename.toLowerCase().endsWith(".dat") || part.givenFilename != null && part.givenFilename.toLowerCase().endsWith(".dat");
    }

    private HashMap<Object3D, LDrawLinePartRef> buildObjects(final LDIContext ctx, LDrawPart part, final StringBuffer lrsb) {
        final HashMap<Object3D, LDrawLinePartRef> objMap = new HashMap<Object3D, LDrawLinePartRef>();
        LDIWorker w = new LDIWorker(){
            private Object3D obj = new Object3D();
            private HashSet<String> missing = new HashSet();
            private boolean curInDat;
            private LDrawLinePartRef nextRef;

            @Override
            public void work(LDrawPart wpart, LDrawMatrix m, int colId) {
                boolean oldDat = this.curInDat;
                LDrawLinePartRef ref = this.nextRef;
                this.curInDat = LDICCollidingParts.this.isDat(wpart);
                super.work(wpart, m, colId);
                if (!oldDat && this.curInDat) {
                    objMap.put(this.obj, ref);
                    this.obj = new Object3D();
                }
                this.curInDat = oldDat;
            }

            @Override
            public LDrawPart handlePartRef(LDrawLinePartRef ref, String partName, int colId, int pcol) {
                LDrawPart res = ctx.getPart(ref.owner, partName, null);
                if (res == null) {
                    if (!this.missing.contains(partName)) {
                        lrsb.append("part " + partName + " is missing, missing content not checked\n");
                        this.missing.add(partName);
                    }
                    return null;
                }
                this.nextRef = ref;
                return res;
            }

            @Override
            public void handleTri(LDrawLineTri tri, LDrawPoint t1, LDrawPoint t2, LDrawPoint t3, int colId, int pcol) {
                if (this.getFaceInvertion()) {
                    this.obj.addTri(t3, t1, t2);
                } else {
                    this.obj.addTri(t1, t2, t3);
                }
            }

            @Override
            public void handleQuad(LDrawLineQuad quad, LDrawPoint t1, LDrawPoint t2, LDrawPoint t3, LDrawPoint t4, int colId, int pcol) {
                if (this.getFaceInvertion()) {
                    this.obj.addTri(t3, t1, t2);
                    this.obj.addTri(t2, t1, t4);
                } else {
                    this.obj.addTri(t1, t2, t3);
                    this.obj.addTri(t3, t4, t1);
                }
            }
        };
        w.work(part);
        return objMap;
    }
}

