/*
 * Decompiled with CFR 0.152.
 */
package ldinsp.check;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import ldinsp.check.LDICAuthor;
import ldinsp.check.LDICBfcs;
import ldinsp.check.LDICCollidingParts;
import ldinsp.check.LDICDispensableMeta;
import ldinsp.check.LDICFilenameGivenname;
import ldinsp.check.LDICFilenameOMR;
import ldinsp.check.LDICFiletype;
import ldinsp.check.LDICHeader;
import ldinsp.check.LDICLicenses;
import ldinsp.check.LDICMirroredParts;
import ldinsp.check.LDICMovedParts;
import ldinsp.check.LDICReferences;
import ldinsp.check.LDICRubberColor;
import ldinsp.check.LDICSubfilesUnique;
import ldinsp.check.LDICSubfilesUsed;
import ldinsp.check.LDICheck;
import ldinsp.check.LDICheckMessage;
import ldinsp.check.LDICheckSolve;
import ldinsp.check.LDICheckSolveFix;
import ldinsp.check.LDICheckState;
import ldinsp.context.LDIContext;
import ldinsp.ldraw.LDrawLine;
import ldinsp.ldraw.LDrawPart;

public class LDICAll
extends LDICheck {
    private LDICheckState resState = LDICheckState.OK;
    private String resShort;
    private String resLong;
    private HashMap<LDrawLine, ArrayList<LDICheckMessage>> partErrors;
    private ArrayList<LDICheckSolve> solver;
    private LDICheckSolve fixAll;

    public LDICAll(LDIContext ctx, LDrawPart part) {
        this(ctx, part, false);
    }

    public LDICAll(final LDIContext ctx, final LDrawPart part, boolean checkCollidingParts) {
        int done = 0;
        ArrayList<LDICheck> checks = new ArrayList<LDICheck>();
        checks.add(new LDICFiletype(ctx, part));
        checks.add(new LDICMovedParts(ctx, part));
        checks.add(new LDICReferences(ctx, part));
        checks.add(new LDICAuthor(ctx, part));
        checks.add(new LDICLicenses(ctx, part));
        checks.add(new LDICSubfilesUnique(ctx, part));
        checks.add(new LDICSubfilesUsed(ctx, part));
        checks.add(new LDICFilenameOMR(ctx, part));
        checks.add(new LDICFilenameGivenname(ctx, part));
        checks.add(new LDICRubberColor(ctx, part));
        checks.add(new LDICBfcs(ctx, part));
        checks.add(new LDICMirroredParts(ctx, part));
        checks.add(new LDICDispensableMeta(ctx, part));
        checks.add(new LDICHeader(ctx, part));
        if (checkCollidingParts) {
            checks.add(new LDICCollidingParts(ctx, part));
        }
        StringBuffer rs = new StringBuffer();
        StringBuffer rl = new StringBuffer();
        this.partErrors = new HashMap();
        this.solver = new ArrayList();
        final ArrayList<LDICheckSolve> fixer = new ArrayList<LDICheckSolve>();
        for (LDICheck c : checks) {
            List<LDICheckSolve> so;
            rs.append(c.getShortResult());
            rl.append(c.getLongResult());
            this.resState = this.resState.combine(c.getState());
            HashMap<LDrawLine, ArrayList<LDICheckMessage>> pe = c.getPartErrors();
            if (pe != null) {
                this.partErrors.putAll(pe);
            }
            if ((so = c.getSolver()) != null) {
                for (LDICheckSolve s : so) {
                    this.solver.add(s);
                    if (!s.isFix()) continue;
                    fixer.add(s);
                }
            }
            ++done;
        }
        rs.append("=> done " + done + " checks, overall rating: " + this.resState.toString() + "\n");
        this.resShort = rs.toString();
        this.resLong = rl.toString();
        if (fixer.size() > 1) {
            this.fixAll = new LDICheckSolveFix("All", "Do all possible fixes"){

                @Override
                public int fix() {
                    int cnt = 0;
                    for (LDICheckSolve f : fixer) {
                        cnt += f.fix();
                    }
                    return cnt;
                }
            };
            this.solver.add(0, this.fixAll);
            this.solver.add(0, new LDICheckSolveFix("Repeated-All", "Do all possible fixes repeatedly"){

                @Override
                public int fix() {
                    int cnt = 0;
                    for (LDICheckSolve f : fixer) {
                        cnt += f.fix();
                    }
                    int i = 0;
                    while (i < 100) {
                        LDICAll repeat = new LDICAll(ctx, part);
                        int changedThisRun = 0;
                        if (repeat.fixAll != null) {
                            changedThisRun += repeat.fixAll.fix();
                        }
                        cnt += changedThisRun;
                        if (changedThisRun == 0) break;
                        ++i;
                    }
                    return cnt;
                }
            });
        } else if (this.solver.size() == 0) {
            this.solver = null;
        }
    }

    @Override
    public LDICheckState getState() {
        return this.resState;
    }

    @Override
    public String getShortResult() {
        return this.resShort;
    }

    @Override
    public String getLongResult() {
        return this.resLong;
    }

    @Override
    public HashMap<LDrawLine, ArrayList<LDICheckMessage>> getPartErrors() {
        return this.partErrors;
    }

    @Override
    public List<LDICheckSolve> getSolver() {
        return this.solver;
    }
}

