/*
 * Decompiled with CFR 0.152.
 */
package ldinsp.base;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ldinsp.base.LDIWorker;
import ldinsp.ldraw.LDrawLineOther;
import ldinsp.ldraw.LDrawLineParMeta;
import ldinsp.ldraw.LDrawLinePartRef;
import ldinsp.ldraw.LDrawMetaDefinitions;
import ldinsp.ldraw.LDrawPart;

public abstract class LDIWorkerRefWalk
extends LDIWorker {
    private static final String PAT_SEP = "\\s+";
    private static final String PAT_COLOR = "([0-9a-fx]+)";
    private static final String PAT_FLOAT = "([-.0-9e]+)";
    private static final String PAT_STRING = "(.*)";
    private static final String PAT_LINEEND = "\\s*(//.*)?\\Z";
    private static Pattern texMapRefPattern = Pattern.compile("0\\s+!:\\s+1\\s+([0-9a-fx]+)\\s+([-.0-9e]+)\\s+([-.0-9e]+)\\s+([-.0-9e]+)\\s+([-.0-9e]+)\\s+([-.0-9e]+)\\s+([-.0-9e]+)\\s+([-.0-9e]+)\\s+([-.0-9e]+)\\s+([-.0-9e]+)\\s+([-.0-9e]+)\\s+([-.0-9e]+)\\s+([-.0-9e]+)\\s+(.*)\\s*(//.*)?\\Z", 2);

    public abstract LDrawPart usePart(String var1);

    @Override
    public void handleParMeta(LDrawLineParMeta meta) {
        String partName = LDrawMetaDefinitions.getFirstPartRefInMeta(meta);
        if (partName == null) {
            return;
        }
        LDrawPart dpart = this.usePart(partName);
        if (dpart == null) {
            return;
        }
        this.work(dpart);
    }

    @Override
    public void handleOther(LDrawLineOther comment) {
        LDrawPart owner = comment.owner;
        if (owner.subParts == null || comment.source == null || comment.source.length() == 0) {
            return;
        }
        String lc = comment.source.toLowerCase();
        Matcher matcher = texMapRefPattern.matcher(lc);
        if (matcher.matches()) {
            this.usePart(matcher.group(14));
        }
    }

    @Override
    public LDrawPart handlePartRef(LDrawLinePartRef ref, String partName, int colId, int pcol) {
        return this.usePart(partName);
    }
}

