/*
 * Decompiled with CFR 0.152.
 */
package ldinsp.base;

import ldinsp.ldraw.LDrawLine;
import ldinsp.ldraw.LDrawLineBfcCmd;
import ldinsp.ldraw.LDrawLineColor;
import ldinsp.ldraw.LDrawLineColorHint;
import ldinsp.ldraw.LDrawLineLine;
import ldinsp.ldraw.LDrawLineOther;
import ldinsp.ldraw.LDrawLineParMeta;
import ldinsp.ldraw.LDrawLinePartRef;
import ldinsp.ldraw.LDrawLineQuad;
import ldinsp.ldraw.LDrawLineStep;
import ldinsp.ldraw.LDrawLineTri;
import ldinsp.ldraw.LDrawMatrix;
import ldinsp.ldraw.LDrawPart;
import ldinsp.ldraw.LDrawPoint;

public abstract class LDIWorker {
    private LDrawPart curPart;
    private boolean invertAll;
    private boolean invertNext;
    private boolean invertExtra;

    public void setCurrentPart(LDrawPart np) {
        this.curPart = np;
    }

    public LDrawPart getCurrentPart() {
        return this.curPart;
    }

    public void setInvertAll(boolean state) {
        this.invertAll = state;
    }

    public boolean getInvertAll() {
        return this.invertAll;
    }

    public void setInvertNext(boolean state) {
        this.invertNext = state;
    }

    public boolean getInvertNext() {
        return this.invertNext;
    }

    public void setInvertExtra(boolean state) {
        this.invertExtra = state;
    }

    public boolean getInvertExtra() {
        return this.invertExtra;
    }

    public boolean getFaceInvertion() {
        return this.getCurrentPart().isCw ^ this.getInvertAll() ^ this.getInvertExtra();
    }

    public void handleColorHint(LDrawLineColorHint hint) {
    }

    public void handleColor(LDrawLineColor col) {
    }

    public void handleStep(LDrawLineStep step) {
    }

    public void handleLine(LDrawLineLine line, LDrawPoint t1, LDrawPoint t2, int colId, int pcol) {
    }

    public void handleTri(LDrawLineTri tri, LDrawPoint t1, LDrawPoint t2, LDrawPoint t3, int colId, int pcol) {
    }

    public void handleQuad(LDrawLineQuad quad, LDrawPoint t1, LDrawPoint t2, LDrawPoint t3, LDrawPoint t4, int colId, int pcol) {
    }

    public void handleInvertNext(LDrawLineBfcCmd bfc) {
        this.invertNext = true;
    }

    public void handleParMeta(LDrawLineParMeta meta) {
    }

    public void handleOther(LDrawLineOther comment) {
    }

    public abstract LDrawPart handlePartRef(LDrawLinePartRef var1, String var2, int var3, int var4);

    public void work(LDrawPart part) {
        boolean oldInvertAll = this.getInvertAll();
        boolean oldInvertNext = this.getInvertNext();
        boolean oldInvertExtra = this.getInvertExtra();
        this.work(part, LDrawMatrix.ID, 16);
        this.setInvertExtra(oldInvertExtra);
        this.setInvertNext(oldInvertNext);
        this.setInvertAll(oldInvertAll);
    }

    public void work(LDrawPart part, LDrawMatrix m, int colId) {
        if (part == null) {
            return;
        }
        LDrawPart oldPart = this.getCurrentPart();
        this.setCurrentPart(part);
        for (LDrawLine a : this.curPart.content) {
            a.work(this, m, colId);
        }
        this.setCurrentPart(oldPart);
    }
}

