/*
 * Decompiled with CFR 0.152.
 */
package ldinsp.util;

public class ColorHelper {
    public static int getRgba(int rgb, int a) {
        return (rgb << 8) + (a & 0xFF);
    }

    public static int getRgba(double r, double g, double b, double a) {
        int ri = (int)(r * 255.0 + 0.5) & 0xFF;
        int gi = (int)(g * 255.0 + 0.5) & 0xFF;
        int bi = (int)(b * 255.0 + 0.5) & 0xFF;
        int ai = (int)(a * 255.0 + 0.5) & 0xFF;
        return ri << 24 | gi << 16 | bi << 8 | ai;
    }

    public static double getR(int rgba) {
        return (double)(rgba >>> 24) / 255.0;
    }

    public static double getG(int rgba) {
        return (double)(rgba >>> 16 & 0xFF) / 255.0;
    }

    public static double getB(int rgba) {
        return (double)(rgba >>> 8 & 0xFF) / 255.0;
    }

    public static double getA(int rgba) {
        return (double)(rgba & 0xFF) / 255.0;
    }

    public static int calcEdgeForFace(int faceRgba) {
        double r = ColorHelper.getR(faceRgba);
        double g = ColorHelper.getG(faceRgba);
        double b = ColorHelper.getB(faceRgba);
        int ai = (int)(ColorHelper.getA(faceRgba) * 255.0 + 0.5);
        if (r + g + b > 0.3) {
            return ColorHelper.getRgba(0x808080, ai);
        }
        return ColorHelper.getRgba(0x333333, ai);
    }
}

