/*
 * Decompiled with CFR 0.152.
 */
package ldinsp.ldraw;

import java.util.ArrayList;
import ldinsp.ldraw.LDrawLine;
import ldinsp.ldraw.LDrawLineFile;
import ldinsp.ldraw.LDrawLineStep;
import ldinsp.ldraw.LDrawPartOrigin;

public class LDrawPart {
    public LDrawPartOrigin origin;
    public String loadedFromFilename;
    public String givenFilename;
    public String givenName;
    public String description;
    public String author;
    public String license;
    public boolean isCw;
    public ArrayList<LDrawLine> headers = new ArrayList();
    public ArrayList<LDrawLine> actions = new ArrayList();
    public ArrayList<LDrawLineStep> steps = new ArrayList();
    public LDrawPart owner;
    public ArrayList<LDrawPart> subParts;

    public String getSource() {
        StringBuilder s = new StringBuilder();
        LDrawPart.appendPart(s, this);
        if (this.subParts != null) {
            for (LDrawPart sb : this.subParts) {
                LDrawPart.appendPart(s, sb);
            }
        }
        return s.toString();
    }

    public LDrawPart copyWithoutSubs(LDrawPart newOwner, String newFilename, int lineNr) {
        LDrawPart copy = new LDrawPart();
        if (newOwner == null) {
            newOwner = copy;
        }
        copy.owner = newOwner;
        copy.givenFilename = newFilename;
        copy.origin = LDrawPartOrigin.SELF;
        copy.givenName = this.givenName;
        copy.description = this.description;
        copy.author = this.author;
        copy.license = this.license;
        copy.isCw = this.isCw;
        int startLine = this.hasFileLine() ? 1 : 0;
        copy.headers.add(new LDrawLineFile(newOwner, lineNr++, "0 FILE " + newFilename, newFilename));
        int i = startLine;
        while (i < this.headers.size()) {
            copy.headers.add(this.headers.get(i).copy(newOwner, lineNr++));
            ++i;
        }
        for (LDrawLine l : this.actions) {
            copy.actions.add(l.copy(newOwner, lineNr++));
        }
        return copy;
    }

    public String getBestFilename() {
        String filename = this.givenName;
        if (filename == null || filename.length() == 0) {
            filename = this.givenFilename;
        }
        if (filename == null || filename.length() == 0) {
            filename = this.loadedFromFilename;
        }
        return filename;
    }

    private static void appendPart(StringBuilder s, LDrawPart p) {
        for (LDrawLine l : p.headers) {
            s.append(l.source);
            s.append("\n");
        }
        for (LDrawLine l : p.actions) {
            s.append(l.source);
            s.append("\n");
        }
    }

    private boolean hasFileLine() {
        String loli;
        return this.headers.size() > 0 && (loli = this.headers.get((int)0).source.toLowerCase()).startsWith("0 file ");
    }
}

