/*
 * Decompiled with CFR 0.152.
 */
package ldinsp.ldraw;

import java.util.ArrayList;
import java.util.List;
import ldinsp.context.LDIContext;
import ldinsp.ldraw.LDrawLine;
import ldinsp.ldraw.LDrawLineFile;
import ldinsp.ldraw.LDrawLineOther;
import ldinsp.ldraw.LDrawLinePartRef;
import ldinsp.ldraw.LDrawPart;

public class LDrawEdit {
    public static final String OMR_LICENSE = "Redistributable under CCAL version 2.0 : see CAreadme.txt";

    public static int addGivenFilename(LDrawPart part, String newName) {
        if (part == null || LDrawEdit.isFile(part, 0)) {
            return 0;
        }
        part.headers.add(0, new LDrawLineFile(part, 0, "0 FILE " + newName, newName));
        part.givenFilename = newName;
        LDrawEdit.renumberLines(part);
        return 1;
    }

    public static int setGivenName(LDrawPart part, String newName) {
        if (part == null) {
            return 0;
        }
        int dest = 0;
        if (LDrawEdit.isFile(part, dest)) {
            ++dest;
        }
        if (LDrawEdit.isComment(part, dest)) {
            ++dest;
        }
        LDrawLineOther name = new LDrawLineOther(part.owner, dest, "0 Name: " + newName);
        if (!LDrawEdit.isName(part, dest)) {
            part.headers.add(dest, name);
            LDrawEdit.renumberLines(part.owner);
        } else {
            part.headers.set(dest, name);
        }
        part.givenName = newName;
        return 1;
    }

    public static int setAuthor(LDrawPart part, String newAuthor, boolean recursive, boolean overwriteExisting, boolean removeMultiple) {
        if (part == null) {
            return 0;
        }
        int cnt = LDrawEdit.doSetAuthor(part, newAuthor, overwriteExisting, removeMultiple);
        if (recursive && part.subParts != null) {
            for (LDrawPart sb : part.subParts) {
                cnt += LDrawEdit.doSetAuthor(sb, newAuthor, overwriteExisting, removeMultiple);
            }
        }
        LDrawEdit.renumberLines(part);
        return cnt;
    }

    public static int setDescription(LDrawPart part, String newDescription) {
        if (part == null) {
            return 0;
        }
        int dest = 0;
        if (LDrawEdit.isFile(part, dest)) {
            ++dest;
        }
        LDrawLineOther name = new LDrawLineOther(part.owner, dest, "0 " + newDescription);
        if (!LDrawEdit.isComment(part, dest)) {
            part.headers.add(dest, name);
            LDrawEdit.renumberLines(part.owner);
        } else {
            part.headers.set(dest, name);
        }
        part.description = newDescription;
        return 1;
    }

    public static int setLicense(LDrawPart part, String newLicense, boolean recursive, boolean overwriteExisting, boolean removeMultiple) {
        if (part == null) {
            return 0;
        }
        int cnt = LDrawEdit.doSetLicense(part, newLicense, overwriteExisting, removeMultiple);
        if (recursive && part.subParts != null) {
            for (LDrawPart sb : part.subParts) {
                cnt += LDrawEdit.doSetLicense(sb, newLicense, overwriteExisting, removeMultiple);
            }
        }
        LDrawEdit.renumberLines(part);
        return cnt;
    }

    public static int syncName(LDrawPart part, boolean recursive) {
        if (part == null) {
            return 0;
        }
        int cnt = LDrawEdit.doSyncName(part);
        if (recursive && part.subParts != null) {
            for (LDrawPart sb : part.subParts) {
                cnt += LDrawEdit.doSyncName(sb);
            }
        }
        return cnt;
    }

    public static int resolveMoved(LDrawPart part, LDIContext ctx, boolean recursive) {
        if (part == null) {
            return 0;
        }
        int cnt = LDrawEdit.doResolveMoved(part, ctx);
        if (recursive && part.subParts != null) {
            for (LDrawPart sb : part.subParts) {
                cnt += LDrawEdit.doResolveMoved(sb, ctx);
            }
        }
        return cnt;
    }

    /*
     * Unable to fully structure code
     */
    public static int embed(LDrawPart part, List<LDrawPart> toEmbed, LDIContext ctx) {
        if (part != null && toEmbed != null && toEmbed.size() != 0) ** GOTO lbl4
        return 0;
lbl-1000:
        // 1 sources

        {
            part = part.owner;
lbl4:
            // 2 sources

            ** while (part.owner != null && part.owner != part)
        }
lbl5:
        // 1 sources

        if (part.subParts == null) {
            part.subParts = new ArrayList<E>();
        }
        cnt = 0;
        lineNr = LDrawEdit.getLastLineNumber(part) + 1;
        for (LDrawPart p : toEmbed) {
            filename = p.getBestFilename();
            if (filename == null || filename.length() == 0 || LDrawEdit.hasSubPartName(part, filename)) continue;
            copy = p.copyWithoutSubs(part, filename, lineNr);
            part.subParts.add(copy);
            cnt += copy.headers.size() + copy.actions.size();
            lineNr += copy.headers.size() + copy.actions.size();
        }
        return cnt;
    }

    public static int remove(LDrawPart part, List<LDrawPart> toRemove) {
        if (part == null || part.subParts == null || toRemove == null || toRemove.size() == 0) {
            return 0;
        }
        int cnt = 0;
        for (LDrawPart r : toRemove) {
            if (!part.subParts.contains(r)) continue;
            part.subParts.remove(r);
            cnt += r.headers.size() + r.actions.size();
        }
        LDrawEdit.renumberLines(part);
        return cnt;
    }

    public static int removeRefs(LDrawPart part, List<String> toRemove, boolean recursive) {
        if (part == null || toRemove == null || toRemove.size() == 0) {
            return 0;
        }
        int cnt = LDrawEdit.doRemoveRefs(part, toRemove);
        if (recursive && part.subParts != null) {
            for (LDrawPart sb : part.subParts) {
                cnt += LDrawEdit.doRemoveRefs(sb, toRemove);
            }
        }
        LDrawEdit.renumberLines(part);
        return cnt;
    }

    public static int removeUnresolvableRefs(LDrawPart part, LDIContext ctx, boolean recursive) {
        if (part == null) {
            return 0;
        }
        int cnt = LDrawEdit.doRemoveUnresolvable(part, ctx);
        if (recursive && part.subParts != null) {
            for (LDrawPart sb : part.subParts) {
                cnt += LDrawEdit.doRemoveUnresolvable(sb, ctx);
            }
        }
        LDrawEdit.renumberLines(part);
        return cnt;
    }

    public static int exchangeRef(LDrawPart part, String oldRefname, String newRefname, boolean recursive) {
        if (part == null || oldRefname == null || oldRefname.length() == 0 || newRefname == null || newRefname.length() == 0) {
            return 0;
        }
        int cnt = LDrawEdit.doExchangeRef(part, oldRefname, newRefname);
        if (recursive && part.subParts != null) {
            for (LDrawPart sb : part.subParts) {
                cnt += LDrawEdit.doExchangeRef(sb, oldRefname, newRefname);
            }
        }
        return cnt;
    }

    public static int renamePart(LDrawPart sub, String newSubname, boolean fixRefs) {
        String oldSubname = sub.givenFilename;
        if (sub == null || oldSubname == null || oldSubname.length() == 0 || newSubname == null || newSubname.length() == 0 || !LDrawEdit.isFile(sub, 0)) {
            return 0;
        }
        if (!(sub.headers.get(0) instanceof LDrawLineFile)) {
            return 0;
        }
        LDrawLineFile fline = (LDrawLineFile)sub.headers.get(0);
        int cnt = 1;
        sub.givenFilename = newSubname;
        sub.headers.set(0, new LDrawLineFile(fline.owner, fline.lineNr, "0 FILE " + newSubname, newSubname));
        if (fixRefs) {
            cnt += LDrawEdit.exchangeRef(sub.owner, oldSubname, newSubname, true);
        }
        return cnt;
    }

    private static int getLastLineNumber(LDrawPart part) {
        if (part.subParts != null && part.subParts.size() > 0) {
            part = part.subParts.get(part.subParts.size() - 1);
        }
        if (part.actions.size() > 0) {
            return part.actions.get((int)(part.actions.size() - 1)).lineNr;
        }
        if (part.headers.size() > 0) {
            return part.headers.get((int)(part.headers.size() - 1)).lineNr;
        }
        return 0;
    }

    private static boolean hasSubPartName(LDrawPart part, String name) {
        if (part == null || part.subParts == null) {
            return false;
        }
        for (LDrawPart sb : part.subParts) {
            if (!sb.givenFilename.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    private static void renumberLines(LDrawPart part) {
        int nr = 1;
        nr = LDrawEdit.doRenumber(part, nr);
        if (part.subParts != null) {
            for (LDrawPart sb : part.subParts) {
                nr = LDrawEdit.doRenumber(sb, nr);
            }
        }
    }

    private static int doRenumber(LDrawPart part, int nr) {
        for (LDrawLine l : part.headers) {
            l.lineNr = nr++;
        }
        for (LDrawLine l : part.headers) {
            l.lineNr = nr++;
        }
        return nr;
    }

    private static int doSetAuthor(LDrawPart part, String newAuthor, boolean overwriteExisting, boolean removeMultiple) {
        int cnt = 0;
        int i = 0;
        while (i < part.headers.size()) {
            if (LDrawEdit.isAuthor(part, i)) {
                if (!overwriteExisting && !removeMultiple) {
                    return 0;
                }
                if (overwriteExisting || removeMultiple && cnt > 0) {
                    part.headers.remove(i);
                } else {
                    ++i;
                }
                ++cnt;
                continue;
            }
            ++i;
        }
        if (!overwriteExisting && cnt > 0) {
            return cnt;
        }
        if (newAuthor == null || (newAuthor = newAuthor.trim()).length() == 0) {
            part.author = null;
            return cnt;
        }
        part.author = newAuthor;
        int dest = 0;
        if (LDrawEdit.isFile(part, dest)) {
            ++dest;
        }
        if (LDrawEdit.isComment(part, dest)) {
            ++dest;
        }
        if (LDrawEdit.isName(part, dest)) {
            ++dest;
        }
        String line = "0 Author: " + newAuthor;
        part.headers.add(dest, new LDrawLineOther(part.owner, dest + 1, line));
        return ++cnt;
    }

    private static int doSetLicense(LDrawPart part, String newLicense, boolean overwriteExisting, boolean removeMultiple) {
        int cnt = 0;
        int i = 0;
        while (i < part.headers.size()) {
            if (LDrawEdit.isLicense(part, i)) {
                if (!overwriteExisting && !removeMultiple) {
                    return 0;
                }
                if (overwriteExisting || removeMultiple && cnt > 0) {
                    part.headers.remove(i);
                } else {
                    ++i;
                }
                ++cnt;
                continue;
            }
            ++i;
        }
        if (!overwriteExisting && cnt > 0) {
            return cnt;
        }
        if (newLicense == null || (newLicense = newLicense.trim()).length() == 0) {
            return cnt;
        }
        int dest = 0;
        if (LDrawEdit.isFile(part, dest)) {
            ++dest;
        }
        if (LDrawEdit.isComment(part, dest)) {
            ++dest;
        }
        if (LDrawEdit.isName(part, dest)) {
            ++dest;
        }
        while (LDrawEdit.isAuthor(part, dest)) {
            ++dest;
        }
        while (LDrawEdit.isLDrawOrg(part, dest)) {
            ++dest;
        }
        String line = "0 !LICENSE " + newLicense;
        part.headers.add(dest, new LDrawLineOther(part.owner, dest + 1, line));
        return ++cnt;
    }

    private static int doSyncName(LDrawPart part) {
        String targetName = part.givenFilename;
        if (targetName == null || targetName.length() == 0) {
            targetName = part.loadedFromFilename;
        }
        if (targetName == null || targetName.length() == 0) {
            return 0;
        }
        int dest = 0;
        if (LDrawEdit.isFile(part, dest)) {
            ++dest;
        }
        if (LDrawEdit.isComment(part, dest)) {
            ++dest;
        }
        String line = "0 Name: " + part.givenFilename;
        if (LDrawEdit.isName(part, dest)) {
            part.headers.set(2, new LDrawLineOther(part.owner, 2, line));
        } else {
            part.headers.add(2, new LDrawLineOther(part.owner, 2, line));
        }
        return 1;
    }

    private static int doResolveMoved(LDrawPart part, LDIContext ctx) {
        int cnt = 0;
        int i = 0;
        while (i < part.actions.size()) {
            LDrawLine line = part.actions.get(i);
            if (line instanceof LDrawLinePartRef) {
                LDrawPart dest;
                LDrawLinePartRef ref = (LDrawLinePartRef)line;
                LDrawPart orig = ctx.getPart(null, ref.refname, null);
                if (orig != null && (dest = ctx.getMoveCleanedPart(orig)) != orig) {
                    String source = ref.getSourceForReplacedRef(dest.loadedFromFilename);
                    ref = new LDrawLinePartRef(ref.owner, ref.lineNr, source, ref.colId, ref.trans, dest.loadedFromFilename);
                    part.actions.set(i, ref);
                    ++cnt;
                }
            }
            ++i;
        }
        return cnt;
    }

    private static int doRemoveRefs(LDrawPart part, List<String> toRemove) {
        int cnt = 0;
        int i = part.actions.size() - 1;
        while (i >= 0) {
            LDrawLine line = part.actions.get(i);
            if (line instanceof LDrawLinePartRef) {
                LDrawLinePartRef ref = (LDrawLinePartRef)line;
                if (toRemove.contains(ref.refname)) {
                    part.actions.remove(i);
                    ++cnt;
                }
            }
            --i;
        }
        return cnt;
    }

    private static int doRemoveUnresolvable(LDrawPart part, LDIContext ctx) {
        int cnt = 0;
        int i = part.actions.size() - 1;
        while (i >= 0) {
            LDrawLine line = part.actions.get(i);
            if (line instanceof LDrawLinePartRef) {
                LDrawLinePartRef ref = (LDrawLinePartRef)line;
                LDrawPart orig = ctx.getPart(ref.owner, ref.refname, null);
                if (orig == null) {
                    part.actions.remove(i);
                    ++cnt;
                }
            }
            --i;
        }
        return cnt;
    }

    private static int doExchangeRef(LDrawPart part, String oldRefname, String newRefname) {
        int cnt = 0;
        int i = part.actions.size() - 1;
        while (i >= 0) {
            LDrawLine line = part.actions.get(i);
            if (line instanceof LDrawLinePartRef) {
                LDrawLinePartRef ref = (LDrawLinePartRef)line;
                if (oldRefname.equalsIgnoreCase(ref.refname)) {
                    String source = ref.getSourceForReplacedRef(newRefname);
                    ref = new LDrawLinePartRef(ref.owner, ref.lineNr, source, ref.colId, ref.trans, newRefname);
                    part.actions.set(i, ref);
                    ++cnt;
                }
            }
            --i;
        }
        return cnt;
    }

    private static boolean isFile(LDrawPart part, int nr) {
        String loli;
        return nr + 1 < part.headers.size() && (loli = part.headers.get((int)nr).source.toLowerCase()).startsWith("0 file ");
    }

    private static boolean isComment(LDrawPart part, int nr) {
        String loli;
        return nr + 1 < part.headers.size() && (loli = part.headers.get((int)nr).source.toLowerCase()).startsWith("0 ");
    }

    private static boolean isName(LDrawPart part, int nr) {
        String loli;
        return nr + 1 < part.headers.size() && (loli = part.headers.get((int)nr).source.toLowerCase()).startsWith("0 name: ");
    }

    private static boolean isAuthor(LDrawPart part, int nr) {
        String loli;
        return nr + 1 < part.headers.size() && (loli = part.headers.get((int)nr).source.toLowerCase()).startsWith("0 author: ");
    }

    private static boolean isLDrawOrg(LDrawPart part, int nr) {
        String loli;
        return nr + 1 < part.headers.size() && (loli = part.headers.get((int)nr).source.toLowerCase()).startsWith("0 !ldraw_org ");
    }

    private static boolean isLicense(LDrawPart part, int nr) {
        String loli;
        return nr + 1 < part.headers.size() && (loli = part.headers.get((int)nr).source.toLowerCase()).startsWith("0 !license ");
    }
}

