/*
 * Decompiled with CFR 0.152.
 */
package ldinsp.gui.view;

import javafx.beans.value.ObservableValue;
import javafx.scene.control.TreeItem;
import javafx.scene.text.Font;
import ldinsp.data.LDIData;
import ldinsp.gui.LDIGui;
import ldinsp.gui.view.LDIVText;
import ldinsp.ldraw.LDrawPart;

public class LDIVTSource
extends LDIVText {
    private final LDIGui main;
    private LDIData data;
    private boolean dataValid;
    private boolean isTabSelected;

    public LDIVTSource(LDIGui imain) {
        this.main = imain;
        this.setFont(Font.font((String)"monospace"));
        this.setClearDisable(true);
        this.setAutoscroll(false);
    }

    @Override
    public void onTabSelection(boolean state) {
        if (!this.isTabSelected && state) {
            this.updateData();
        }
        this.isTabSelected = state;
    }

    @Override
    public void selUpdated(ObservableValue<? extends TreeItem<LDIData>> obs, TreeItem<LDIData> oldSel, TreeItem<LDIData> newSel, boolean active) {
        this.data = null;
        this.clear();
        if (newSel != null) {
            this.data = (LDIData)newSel.getValue();
            this.dataValid = false;
            if (this.isTabSelected) {
                this.updateData();
            }
        }
    }

    private void updateData() {
        if (this.dataValid) {
            return;
        }
        this.clear();
        this.dataValid = true;
        if (this.data == null) {
            return;
        }
        LDrawPart part = this.data.getPart(this.main.ctx);
        if (part == null) {
            return;
        }
        this.append(part.getSource());
    }
}

