/*
 * Decompiled with CFR 0.152.
 */
package ldinsp.gui.view;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeItem;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.text.Text;
import javafx.util.Callback;
import ldinsp.context.LDICColorHintSource;
import ldinsp.data.LDIDPartList;
import ldinsp.data.LDIData;
import ldinsp.ext.LDIRebrickable;
import ldinsp.gui.GuiHelper;
import ldinsp.gui.LDIGui;
import ldinsp.gui.view.LDIPartRender;
import ldinsp.gui.view.LDIPartScene;
import ldinsp.gui.view.LDIPartSceneSettings;
import ldinsp.gui.view.LDIView;
import ldinsp.ldraw.LDrawPart;
import ldinsp.ldraw.LDrawPartOrigin;
import ldinsp.util.StringNumberComparator;

public class LDIVPartList
extends BorderPane
implements LDIView {
    private static final double BUTTON_OBJ_ANGLE_STEP = 15.0;
    private static final int IMG_PREVIEW_WIDTH = 90;
    private static final int IMG_INTEGR_WIDTH = 60;
    private final LDIGui main;
    private final Tooltip colSelTooltip;
    private final ObservableList<LDIVPLEntry> entries;
    private final FilteredList<LDIVPLEntry> filteredEntries;
    private final TableColumn<LDIVPLEntry, String> amountColumn;
    private final MenuItem cleanupMovedInCS;
    private final TableView<LDIVPLEntry> tableView;
    private final LDIPartSceneSettings previewSet;
    private final LDIPartScene previewPartC;
    private final LDIPartScene previewPartU;
    private final ImageView previewImgBricklink;
    private final ImageView previewImgRebrickable;
    private final HashMap<LDIVPLEntry, LDIPartRender> cacheColored;
    private final HashMap<LDIVPLEntry, LDIPartRender> cacheUni;
    private final HashMap<LDIVPLEntry, Image> cacheIntegr;
    private final CheckBox imgConfig;
    private final TableColumn<LDIVPLEntry, Image> imgColumn;
    private final ArrayList<TableColumn<LDIVPLEntry, String>> addColumns;
    private final ComboBox<FilterConfig> filterConfig;
    private LDIData curListSource;
    private LDIDPartList curPartListSourceEditable;
    private TreeItem<LDIData> curPartListSourceItem;
    private LDIVPLEntry curTableSelect;
    private boolean isTabSelected;
    private boolean valid;

    public LDIVPartList(LDIGui imain) {
        this.main = imain;
        this.cacheColored = new HashMap();
        this.cacheUni = new HashMap();
        this.cacheIntegr = new HashMap();
        this.addColumns = new ArrayList();
        VBox controlPane = new VBox();
        controlPane.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        controlPane.setSpacing(10.0);
        controlPane.setMinSize(200.0, 100.0);
        this.setTop((Node)controlPane);
        HBox controlLineComp = new HBox();
        controlLineComp.setSpacing(10.0);
        controlLineComp.setAlignment(Pos.CENTER_LEFT);
        controlPane.getChildren().add((Object)controlLineComp);
        this.previewSet = new LDIPartSceneSettings();
        this.previewPartC = new LDIPartScene(90, 90, this.previewSet);
        this.previewPartC.axesGroup.setVisible(false);
        this.previewPartC.objectScene.setFill((Paint)Color.WHITE);
        controlLineComp.getChildren().add((Object)this.previewPartC.objectScene);
        this.previewPartU = new LDIPartScene(90, 90, this.previewSet);
        this.previewPartU.axesGroup.setVisible(false);
        this.previewPartU.objectScene.setFill((Paint)Color.WHITE);
        controlLineComp.getChildren().add((Object)this.previewPartU.objectScene);
        this.previewImgBricklink = new ImageView();
        this.previewImgBricklink.setFitWidth(90.0);
        this.previewImgBricklink.setFitHeight(90.0);
        this.previewImgBricklink.setPreserveRatio(true);
        StackPane pane = new StackPane(new Node[]{this.previewImgBricklink});
        controlLineComp.getChildren().add((Object)pane);
        pane.setAlignment(Pos.CENTER);
        pane.setPrefSize(90.0, 90.0);
        this.previewImgRebrickable = new ImageView();
        this.previewImgRebrickable.setFitWidth(90.0);
        this.previewImgRebrickable.setFitHeight(90.0);
        this.previewImgRebrickable.setPreserveRatio(true);
        pane = new StackPane(new Node[]{this.previewImgRebrickable});
        controlLineComp.getChildren().add((Object)pane);
        pane.setAlignment(Pos.CENTER);
        pane.setPrefSize(90.0, 90.0);
        VBox controlLineRight = new VBox();
        controlLineRight.setSpacing(10.0);
        controlLineComp.getChildren().add((Object)controlLineRight);
        HBox controlLine = new HBox();
        controlLine.setSpacing(10.0);
        controlLineRight.getChildren().add((Object)controlLine);
        this.imgConfig = new CheckBox("Integr. Img.");
        this.imgConfig.setAllowIndeterminate(false);
        this.imgConfig.setMaxHeight(Double.MAX_VALUE);
        controlLine.getChildren().add((Object)this.imgConfig);
        Button button = new Button("Reset View");
        button.setOnAction(event -> {
            this.previewSet.resetView();
            this.previewPartC.autoAdjustView();
        });
        button.setMaxHeight(Double.MAX_VALUE);
        controlLine.getChildren().add((Object)button);
        button = new Button("x+");
        button.setOnAction(event -> this.previewSet.objAngleX.set(this.previewSet.objAngleX.get() + 15.0));
        button.setMaxHeight(Double.MAX_VALUE);
        controlLine.getChildren().add((Object)button);
        button = new Button("x-");
        button.setOnAction(event -> this.previewSet.objAngleX.set(this.previewSet.objAngleX.get() - 15.0));
        button.setMaxHeight(Double.MAX_VALUE);
        controlLine.getChildren().add((Object)button);
        button = new Button("y+");
        button.setOnAction(event -> this.previewSet.objAngleY.set(this.previewSet.objAngleY.get() + 15.0));
        button.setMaxHeight(Double.MAX_VALUE);
        controlLine.getChildren().add((Object)button);
        button = new Button("y-");
        button.setOnAction(event -> this.previewSet.objAngleY.set(this.previewSet.objAngleY.get() - 15.0));
        button.setMaxHeight(Double.MAX_VALUE);
        controlLine.getChildren().add((Object)button);
        button = new Button("z+");
        button.setOnAction(event -> this.previewSet.objAngleZ.set(this.previewSet.objAngleZ.get() + 15.0));
        button.setMaxHeight(Double.MAX_VALUE);
        controlLine.getChildren().add((Object)button);
        button = new Button("z-");
        button.setOnAction(event -> this.previewSet.objAngleZ.set(this.previewSet.objAngleZ.get() - 15.0));
        button.setMaxHeight(Double.MAX_VALUE);
        controlLine.getChildren().add((Object)button);
        controlLine = new HBox();
        controlLine.setSpacing(10.0);
        controlLine.setMaxHeight(Double.MAX_VALUE);
        controlLineRight.getChildren().add((Object)controlLine);
        button = new Button("This@Bl");
        button.setOnAction(event -> this.getImageFromBricklink(false));
        button.setMaxHeight(Double.MAX_VALUE);
        button.setTooltip(new Tooltip("Load image for selected item from Bricklink"));
        controlLine.getChildren().add((Object)button);
        button = new Button("All@Bl");
        button.setOnAction(event -> this.getImageFromBricklink(true));
        button.setMaxHeight(Double.MAX_VALUE);
        button.setTooltip(new Tooltip("Load image for all items from Bricklink"));
        controlLine.getChildren().add((Object)button);
        button = new Button("This@Rb");
        button.setOnAction(event -> this.getImageFromRebrickable(false));
        button.setMaxHeight(Double.MAX_VALUE);
        button.setTooltip(new Tooltip("Load image for selected item from Rebrickable"));
        controlLine.getChildren().add((Object)button);
        button = new Button("All@Rb");
        button.setOnAction(event -> this.getImageFromRebrickable(true));
        button.setMaxHeight(Double.MAX_VALUE);
        button.setTooltip(new Tooltip("Load image for all items from Rebrickable"));
        controlLine.getChildren().add((Object)button);
        controlLine = new HBox();
        controlLine.setSpacing(10.0);
        controlLine.setMaxHeight(Double.MAX_VALUE);
        controlLineRight.getChildren().add((Object)controlLine);
        button = new Button("Reset Comparison");
        button.setOnAction(event -> this.resetComparison());
        button.setMaxHeight(Double.MAX_VALUE);
        controlLine.getChildren().add((Object)button);
        this.filterConfig = new ComboBox();
        this.filterConfig.getItems().addAll((Object[])FilterConfig.values());
        this.filterConfig.getSelectionModel().select((Object)FilterConfig.DEFAULT);
        this.filterConfig.setMaxHeight(Double.MAX_VALUE);
        this.filterConfig.getSelectionModel().selectedItemProperty().addListener((obs, oldVal, newVal) -> this.refreshFilterAndTable());
        controlLine.getChildren().add(this.filterConfig);
        TableColumn nameColumn = new TableColumn("Item");
        nameColumn.setCellValueFactory(param -> new ReadOnlyStringWrapper(((LDIVPLEntry)param.getValue()).name));
        nameColumn.setPrefWidth(150.0);
        nameColumn.setMinWidth(120.0);
        TableColumn originColumn = new TableColumn("Orig.");
        originColumn.setCellValueFactory(param -> {
            LDrawPartOrigin o = ((LDIVPLEntry)param.getValue()).origin;
            if (o == null) {
                o = LDrawPartOrigin.MISSING;
            }
            return new ReadOnlyStringWrapper(o.nameFull);
        });
        originColumn.setCellFactory((Callback)new Callback<TableColumn<LDIVPLEntry, String>, TableCell<LDIVPLEntry, String>>(){

            public TableCell<LDIVPLEntry, String> call(TableColumn<LDIVPLEntry, String> p) {
                return new TableCell<LDIVPLEntry, String>(){
                    private final Circle orgPreview = new Circle(8.0, (Paint)Color.WHITE);

                    protected void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null) {
                            this.setText(item);
                            LDrawPartOrigin o = LDrawPartOrigin.getByFullName(item);
                            this.orgPreview.setFill((Paint)GuiHelper.rgbaToColor(o.rgbaCol));
                            this.setGraphic((Node)this.orgPreview);
                            this.setTooltip(new Tooltip(o.explanation));
                        } else {
                            this.setText("");
                            this.setGraphic(null);
                            this.setTooltip(null);
                        }
                    }
                };
            }
        });
        originColumn.setPrefWidth(90.0);
        TableColumn descColumn = new TableColumn("Description");
        descColumn.setCellValueFactory(param -> new ReadOnlyStringWrapper(((LDIVPLEntry)param.getValue()).desc));
        descColumn.setPrefWidth(350.0);
        descColumn.setMinWidth(150.0);
        TableColumn colColumn = new TableColumn("Col");
        colColumn.setCellValueFactory(param -> {
            int colId = ((LDIVPLEntry)param.getValue()).color;
            if (colId >= 0) {
                return new ReadOnlyStringWrapper(Integer.toString(colId));
            }
            return null;
        });
        colColumn.setCellFactory((Callback)new Callback<TableColumn<LDIVPLEntry, String>, TableCell<LDIVPLEntry, String>>(){

            public TableCell<LDIVPLEntry, String> call(TableColumn<LDIVPLEntry, String> p) {
                return new TableCell<LDIVPLEntry, String>(){
                    private final Circle colPreview = new Circle(8.0, (Paint)Color.WHITE);

                    protected void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        LDIVPLEntry data = (LDIVPLEntry)this.getTableRow().getItem();
                        int colId = -1;
                        if (data != null && !empty && (colId = data.color) != -1) {
                            this.colPreview.setFill((Paint)GuiHelper.rgbaToColor((this).LDIVPartList.this.main.ctx.getRgbaColorByIds(colId, -1)));
                            this.setGraphic((Node)this.colPreview);
                            this.setText(Integer.toString(colId));
                            this.setTooltip(new Tooltip((this).LDIVPartList.this.main.ctx.getColorById((int)colId).name));
                        } else {
                            this.setBackground(null);
                            this.setText("");
                            this.setGraphic(null);
                            this.setTooltip(null);
                        }
                    }
                };
            }
        });
        colColumn.setPrefWidth(60.0);
        colColumn.setStyle("-fx-alignment: CENTER;");
        this.imgColumn = new TableColumn("Img.");
        this.imgColumn.setPrefWidth(5.0);
        this.imgColumn.setMinWidth(5.0);
        this.imgColumn.setCellValueFactory(param -> {
            LDIVPLEntry item = (LDIVPLEntry)param.getValue();
            if (item == null || !this.imgConfig.isSelected()) {
                return null;
            }
            Image img = this.cacheIntegr.get(item);
            if (img == null) {
                if (item.part != null) {
                    img = LDIPartRender.renderImage(item.part, item.color, 60, 60, this.main.ctx, this.main);
                } else if (item.imgBricklink != null) {
                    img = item.imgBricklink;
                } else if (item.imgRebrickable != null) {
                    img = item.imgRebrickable;
                } else {
                    return null;
                }
                this.cacheIntegr.put(item, img);
            }
            return new ReadOnlyObjectWrapper((Object)img);
        });
        this.imgColumn.setCellFactory((Callback)new Callback<TableColumn<LDIVPLEntry, Image>, TableCell<LDIVPLEntry, Image>>(){

            public TableCell<LDIVPLEntry, Image> call(TableColumn<LDIVPLEntry, Image> p) {
                return new TableCell<LDIVPLEntry, Image>(){
                    private ImageView iv = new ImageView();
                    {
                        this.iv.setFitWidth(60.0);
                        this.iv.setFitHeight(60.0);
                        this.iv.setPreserveRatio(true);
                    }

                    protected void updateItem(Image item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (!(this).LDIVPartList.this.imgConfig.isSelected()) {
                            this.setGraphic(null);
                            return;
                        }
                        this.setGraphic((Node)this.iv);
                        if (item == null || empty) {
                            this.iv.setImage(null);
                        } else {
                            this.iv.setImage(item);
                        }
                    }
                };
            }
        });
        descColumn.setMinWidth(150.0);
        this.amountColumn = new TableColumn();
        Label colSelLabel = new Label("CS");
        this.colSelTooltip = new Tooltip("");
        this.colSelTooltip.setWrapText(true);
        colSelLabel.setTooltip(this.colSelTooltip);
        this.amountColumn.setGraphic((Node)colSelLabel);
        this.amountColumn.setCellValueFactory(param -> {
            int amount = ((LDIVPLEntry)param.getValue()).amount;
            if (amount != 0) {
                return new ReadOnlyStringWrapper(Integer.toString(amount));
            }
            return null;
        });
        this.amountColumn.setCellFactory(TextFieldTableCell.forTableColumn());
        this.amountColumn.setEditable(false);
        this.amountColumn.setOnEditCommit(event -> {
            if (this.curPartListSourceEditable == null) {
                return;
            }
            LDIVPLEntry entry = (LDIVPLEntry)event.getRowValue();
            int newAmount = entry.amount;
            try {
                newAmount = Integer.parseInt((String)event.getNewValue());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            entry.amount = newAmount;
            this.curPartListSourceEditable.updatePart(entry.name, entry.color, newAmount, true);
            this.main.rebuildItem(this.curPartListSourceItem);
        });
        this.amountColumn.setPrefWidth(60.0);
        this.amountColumn.setStyle("-fx-alignment: CENTER-RIGHT;");
        ContextMenu cm = new ContextMenu();
        MenuItem mi = new MenuItem("Copy row");
        mi.setOnAction(event -> this.addCurSelAsCol(-1));
        cm.getItems().add((Object)mi);
        mi = new MenuItem("Create part list from items with amount>0");
        mi.setOnAction(event -> this.createPartList(-1));
        cm.getItems().add((Object)mi);
        mi = new MenuItem("Export items with amount>0 as pbg");
        mi.setOnAction(event -> this.exportPartListAsPbg(-1));
        cm.getItems().add((Object)mi);
        this.cleanupMovedInCS = new MenuItem("Resolve ~moved parts");
        this.cleanupMovedInCS.setOnAction(event -> this.resolveMoved(-1));
        cm.getItems().add((Object)this.cleanupMovedInCS);
        this.amountColumn.setContextMenu(cm);
        this.entries = FXCollections.observableArrayList();
        this.filteredEntries = new FilteredList(this.entries);
        this.tableView = new TableView();
        this.tableView.setItems(this.filteredEntries);
        this.tableView.setManaged(true);
        this.tableView.setEditable(true);
        this.tableView.setPlaceholder((Node)new Text("No item to show (selection has no or empty list or all items are filtered)"));
        nameColumn.setReorderable(false);
        originColumn.setReorderable(false);
        descColumn.setReorderable(false);
        colColumn.setReorderable(false);
        this.imgColumn.setReorderable(false);
        this.amountColumn.setReorderable(false);
        this.tableView.getColumns().add((Object)nameColumn);
        this.tableView.getColumns().add((Object)originColumn);
        this.tableView.getColumns().add((Object)descColumn);
        this.tableView.getColumns().add((Object)colColumn);
        this.tableView.getColumns().add(this.imgColumn);
        this.tableView.getColumns().add(this.amountColumn);
        this.tableView.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        this.tableView.getSelectionModel().setCellSelectionEnabled(false);
        this.tableView.getSelectionModel().selectedItemProperty().addListener((obs, oldSel, newSel) -> this.partInTableSelUpdated((ObservableValue<? extends LDIVPLEntry>)obs, (LDIVPLEntry)oldSel, (LDIVPLEntry)newSel));
        this.setCenter((Node)this.tableView);
        this.imgConfig.setOnAction(event -> {
            this.imgColumn.setPrefWidth((double)(this.imgConfig.isSelected() ? 65 : 5));
            this.tableView.refresh();
        });
    }

    @Override
    public void contextChanged() {
        this.cacheColored.clear();
        this.cacheUni.clear();
        this.cacheIntegr.clear();
        this.valid = false;
        if (this.isTabSelected) {
            this.rebuild();
        }
    }

    @Override
    public void invalidateItem(TreeItem<LDIData> invalid) {
        if (this.curListSource == null || this.curListSource != invalid) {
            return;
        }
        this.valid = false;
        if (this.isTabSelected) {
            this.rebuild();
        }
    }

    @Override
    public void onTabSelection(boolean state) {
        if (!this.isTabSelected && state && !this.valid) {
            this.rebuild();
        }
        this.isTabSelected = state;
    }

    @Override
    public void selUpdated(ObservableValue<? extends TreeItem<LDIData>> obs, TreeItem<LDIData> oldSel, TreeItem<LDIData> newSel, boolean active) {
        if (newSel == null) {
            this.curListSource = null;
            this.curPartListSourceItem = null;
            this.curPartListSourceEditable = null;
            this.amountColumn.setEditable(false);
            this.cleanupMovedInCS.setDisable(true);
        } else {
            this.curListSource = (LDIData)newSel.getValue();
            this.curPartListSourceEditable = this.main.getAsUnfixedPartList(newSel);
            if (this.curPartListSourceEditable != null) {
                this.curPartListSourceItem = newSel;
                this.amountColumn.setEditable(true);
                this.cleanupMovedInCS.setDisable(false);
            } else {
                this.curPartListSourceItem = null;
                this.amountColumn.setEditable(false);
                this.cleanupMovedInCS.setDisable(true);
            }
        }
        this.valid = false;
        if (this.isTabSelected) {
            this.rebuild();
        }
    }

    private void refreshFilterAndTable() {
        this.filteredEntries.setPredicate(null);
        FilterConfig config = (FilterConfig)((Object)this.filterConfig.getSelectionModel().getSelectedItem());
        if (config != null && config.predicate != null) {
            this.filteredEntries.setPredicate(config.predicate);
        }
        this.tableView.refresh();
    }

    private void partInTableSelUpdated(ObservableValue<? extends LDIVPLEntry> obs, LDIVPLEntry oldSel, LDIVPLEntry newSel) {
        this.curTableSelect = newSel;
        this.previewPartC.renderGroup.getChildren().clear();
        this.previewPartU.renderGroup.getChildren().clear();
        if (this.curTableSelect == null) {
            this.previewImgBricklink.setImage(null);
            this.previewImgRebrickable.setImage(null);
            return;
        }
        this.previewImgBricklink.setImage(this.curTableSelect.imgBricklink);
        this.previewImgRebrickable.setImage(this.curTableSelect.imgRebrickable);
        if (this.curTableSelect.part != null) {
            LDIPartRender lbcColored = this.cacheColored.get(this.curTableSelect);
            if (lbcColored == null) {
                this.refresh();
            } else {
                this.previewSet.resetView();
                this.previewPartC.renderGroup.getChildren().add((Object)lbcColored.dest);
                this.previewPartC.autoAdjustView();
                LDIPartRender lbcUni = this.cacheUni.get(this.curTableSelect);
                this.previewPartU.renderGroup.getChildren().add((Object)lbcUni.dest);
                this.previewPartU.autoAdjustView();
            }
        }
    }

    private void refresh() {
        this.previewPartC.renderGroup.getChildren().clear();
        this.previewPartU.renderGroup.getChildren().clear();
        LDIVPLEntry toRender = this.curTableSelect;
        LDIPartRender lbcColored = LDIPartRender.buildPartAtOrigin(this.main.ctx, toRender.part, toRender.color, -1, this.main);
        if (lbcColored != null) {
            this.cacheColored.put(toRender, lbcColored);
            LDIPartRender lbcUni = LDIPartRender.buildPartAtOrigin(this.main.ctx, toRender.part, 16, -1, this.main);
            this.cacheUni.put(toRender, lbcUni);
            this.previewSet.resetView();
            this.previewPartC.renderGroup.getChildren().add((Object)lbcColored.dest);
            this.previewPartC.autoAdjustView();
            this.previewPartU.renderGroup.getChildren().add((Object)lbcUni.dest);
        }
    }

    private void rebuild() {
        this.valid = true;
        this.colSelTooltip.setText("");
        ArrayList<LDIVPLEntry> toDel = new ArrayList<LDIVPLEntry>();
        for (LDIVPLEntry e : this.entries) {
            e.amount = 0;
            if (!LDIVPartList.allZero(e.addAmnts)) continue;
            toDel.add(e);
        }
        if (this.curListSource == null) {
            this.entries.removeAll(toDel);
            this.refreshFilterAndTable();
            return;
        }
        LDrawPart curListPart = this.curListSource.getPart(this.main.ctx);
        LDIDPartList pld = this.curListSource.getPartList(this.main.ctx);
        if (pld == null) {
            this.entries.removeAll(toDel);
            this.refreshFilterAndTable();
            return;
        }
        List<? extends LDIData> pl = pld.getSubElements(this.main.ctx);
        ArrayList<LDIVPLEntry> list = new ArrayList<LDIVPLEntry>();
        list.addAll((Collection<LDIVPLEntry>)this.entries);
        list.removeAll(toDel);
        for (LDIData data : pl) {
            int color;
            String name = data.getName();
            LDIVPLEntry e = LDIVPartList.searchEntry(list, name, color = data.getColId());
            if (e != null) {
                e.amount += data.getAmount();
                continue;
            }
            e = this.createNewEntry(name, color, data.getDescription(this.main.ctx), this.main.ctx.getPart(curListPart, name, this.main));
            e.amount = data.getAmount();
            list.add(e);
        }
        int acs = this.addColumns.size();
        for (LDIVPLEntry e : list) {
            while (e.addAmnts.size() < acs) {
                e.addAmnts.add(0);
            }
        }
        list.sort(new Comparator<LDIVPLEntry>(){

            @Override
            public int compare(LDIVPLEntry o1, LDIVPLEntry o2) {
                int nameRes = StringNumberComparator.compare(o1.name, o2.name);
                if (nameRes != 0) {
                    return nameRes;
                }
                return o1.color - o2.color;
            }
        });
        this.colSelTooltip.setText(String.valueOf(this.curListSource.getName()) + "\nRight click for actions");
        this.entries.clear();
        this.entries.addAll(list);
        this.refreshFilterAndTable();
    }

    private Image loadCachedImageSilently(String name) {
        try {
            InputStream is = this.main.ctx.loadCachedResource(name);
            if (is != null) {
                return new Image(is, 90.0, 90.0, true, true);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private static LDIVPLEntry searchEntry(List<LDIVPLEntry> list, String name, int color) {
        for (LDIVPLEntry e : list) {
            if (color != e.color || !name.equals(e.name)) continue;
            return e;
        }
        return null;
    }

    private LDIVPLEntry createNewEntry(String name, int color, String desc, LDrawPart part) {
        int rbColId;
        LDIVPLEntry e = new LDIVPLEntry();
        e.name = name;
        e.color = color;
        e.desc = desc;
        e.part = part;
        e.origin = part != null ? part.origin : LDrawPartOrigin.MISSING;
        int acs = this.addColumns.size();
        while (e.addAmnts.size() < acs) {
            e.addAmnts.add(0);
        }
        String plainName = LDIVPartList.plainName(e.name);
        int blColId = this.main.ctx.getColorFirstHintIdByLDrawId(e.color, LDICColorHintSource.BRICKLINK);
        if (blColId >= 0) {
            e.imgBricklink = this.loadCachedImageSilently("img_bl_" + plainName + "_" + blColId);
        }
        if ((rbColId = this.main.ctx.getColorFirstHintIdByLDrawId(e.color, LDICColorHintSource.REBRICKABLE)) >= 0) {
            e.imgRebrickable = this.loadCachedImageSilently("img_rb_" + plainName + "_" + rbColId);
        }
        return e;
    }

    private static boolean allZero(List<Integer> list) {
        for (int aa : list) {
            if (aa <= 0) continue;
            return false;
        }
        return true;
    }

    private void resetComparison() {
        for (TableColumn<LDIVPLEntry, String> tc : this.addColumns) {
            this.tableView.getColumns().remove(tc);
        }
        this.addColumns.clear();
        this.entries.clear();
        this.rebuild();
    }

    private void removeCol(int col) {
        if (col < 0 || col >= this.addColumns.size()) {
            return;
        }
        this.tableView.getColumns().remove(this.addColumns.remove(col));
        for (LDIVPLEntry e : this.entries) {
            e.addAmnts.remove(col);
        }
        int i = 0;
        while (i < this.addColumns.size()) {
            this.setupAddColumn(this.addColumns.get(i), i);
            ++i;
        }
        this.rebuild();
    }

    private LDIDPartList doBuildPartList(int col) {
        LDIDPartList pl = new LDIDPartList(col >= 0 ? "PL C" + (col + 1) : "PL CS");
        for (LDIVPLEntry e : this.entries) {
            int amount;
            int n = amount = col >= 0 ? e.addAmnts.get(col) : e.amount;
            if (amount <= 0) continue;
            pl.addPart(e.name, e.color, amount, e.origin, false);
        }
        return pl;
    }

    private void createPartList(int col) {
        this.main.addDataItem(this.doBuildPartList(col));
    }

    private void exportPartListAsPbg(int col) {
        LDIDPartList pl = this.doBuildPartList(col);
        this.main.exportPartListAsPbg(pl);
    }

    private void exportPartListAsXml(int col) {
        LDIDPartList pl = this.doBuildPartList(col);
        this.main.exportPartListAsXml(pl);
    }

    private void resolveMoved(int col) {
        ArrayList<LDIVPLEntry> add = col >= 0 ? new ArrayList<LDIVPLEntry>() : null;
        for (LDIVPLEntry e : this.entries) {
            LDrawPart np;
            int amount;
            int n = amount = col >= 0 ? e.addAmnts.get(col) : e.amount;
            if (amount == 0 || (np = this.main.ctx.getMoveCleanedPart(e.part)) == null || np == e.part) continue;
            if (col >= 0) {
                e.addAmnts.set(col, 0);
                LDIVPLEntry ne = LDIVPartList.searchEntry(this.entries, np.loadedFromFilename, e.color);
                if (ne == null) {
                    ne = this.createNewEntry(np.loadedFromFilename, e.color, np.description, np);
                    add.add(ne);
                }
                ne.addAmnts.set(col, amount);
                continue;
            }
            this.curPartListSourceEditable.updatePart(e.name, e.color, 0, true);
            this.curPartListSourceEditable.updatePart(np.loadedFromFilename, e.color, amount, false);
        }
        if (col >= 0) {
            this.entries.addAll(add);
        } else {
            this.main.rebuildItem(this.curPartListSourceItem);
        }
        this.rebuild();
    }

    private void addCurSelAsCol(int source) {
        if (this.curListSource == null || source >= this.addColumns.size()) {
            return;
        }
        int myOffset = this.addColumns.size();
        TableColumn tc = new TableColumn();
        this.setupAddColumn((TableColumn<LDIVPLEntry, String>)tc, myOffset);
        tc.setPrefWidth(60.0);
        tc.setStyle("-fx-alignment: CENTER-RIGHT;");
        tc.setReorderable(false);
        this.tableView.getColumns().add((Object)tc);
        this.addColumns.add((TableColumn<LDIVPLEntry, String>)tc);
        for (LDIVPLEntry e : this.entries) {
            e.addAmnts.add(source < 0 ? e.amount : e.addAmnts.get(source));
        }
        this.refreshFilterAndTable();
    }

    private void setupAddColumn(TableColumn<LDIVPLEntry, String> tc, int col) {
        Label colLabel = new Label("C" + (col + 1));
        colLabel.setTooltip(new Tooltip("Right click for actions"));
        tc.setGraphic((Node)colLabel);
        tc.setCellValueFactory(param -> {
            int amount;
            ArrayList<Integer> e = ((LDIVPLEntry)param.getValue()).addAmnts;
            int n2 = amount = e.size() > col ? e.get(col) : 0;
            if (amount != 0) {
                return new ReadOnlyStringWrapper(Integer.toString(amount));
            }
            return null;
        });
        tc.setCellFactory(TextFieldTableCell.forTableColumn());
        tc.setOnEditCommit(event -> {
            LDIVPLEntry entry = (LDIVPLEntry)event.getRowValue();
            if (col < 0 || col >= entry.addAmnts.size()) {
                return;
            }
            int newAmount = entry.addAmnts.get(col);
            try {
                newAmount = Integer.parseInt((String)event.getNewValue());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            entry.addAmnts.set(col, newAmount);
        });
        tc.setEditable(true);
        ContextMenu cm = new ContextMenu();
        MenuItem mi = new MenuItem("Copy row");
        mi.setOnAction(event -> this.addCurSelAsCol(col));
        cm.getItems().add((Object)mi);
        mi = new MenuItem("Create part list from items with amount>0");
        mi.setOnAction(event -> this.createPartList(col));
        cm.getItems().add((Object)mi);
        mi = new MenuItem("Export items with amount>0 as pbg");
        mi.setOnAction(event -> this.exportPartListAsPbg(col));
        cm.getItems().add((Object)mi);
        mi = new MenuItem("Export items with amount>0 as xml");
        mi.setOnAction(event -> this.exportPartListAsXml(col));
        cm.getItems().add((Object)mi);
        mi = new MenuItem("Resolve ~moved parts");
        mi.setOnAction(event -> this.resolveMoved(col));
        cm.getItems().add((Object)mi);
        mi = new MenuItem("Invert amounts of this row");
        mi.setOnAction(event -> this.multiplyAmounts(col, -1));
        cm.getItems().add((Object)mi);
        mi = new MenuItem("Add CS amounts to this row");
        mi.setOnAction(event -> this.addSubCurSelAsItem(col, true));
        cm.getItems().add((Object)mi);
        mi = new MenuItem("Subtract CS amounts from this row");
        mi.setOnAction(event -> this.addSubCurSelAsItem(col, false));
        cm.getItems().add((Object)mi);
        mi = new MenuItem("Dismiss row");
        mi.setOnAction(event -> this.removeCol(col));
        cm.getItems().add((Object)mi);
        tc.setContextMenu(cm);
    }

    private void multiplyAmounts(int col, int fac) {
        if (this.curListSource == null || col < 0 || col >= this.addColumns.size()) {
            return;
        }
        for (LDIVPLEntry e : this.entries) {
            e.addAmnts.set(col, e.addAmnts.get(col) * fac);
        }
        this.refreshFilterAndTable();
    }

    private void addSubCurSelAsItem(int col, boolean add) {
        if (this.curListSource == null || col < 0 || col >= this.addColumns.size()) {
            return;
        }
        for (LDIVPLEntry e : this.entries) {
            e.addAmnts.set(col, add ? e.addAmnts.get(col) + e.amount : e.addAmnts.get(col) - e.amount);
        }
        this.refreshFilterAndTable();
    }

    private static String plainName(String name) {
        if ((name = name.toLowerCase()).endsWith(".dat")) {
            name = name.substring(0, name.length() - 4);
        }
        return name;
    }

    private void getImageFromBricklink(boolean all) {
        if (all) {
            for (LDIVPLEntry e : this.filteredEntries) {
                this.doGetImageFromBricklink(e);
            }
        } else {
            this.doGetImageFromBricklink((LDIVPLEntry)this.tableView.getSelectionModel().getSelectedItem());
        }
    }

    private void doGetImageFromBricklink(final LDIVPLEntry entry) {
        if (entry == null || entry.imgBricklink != null) {
            return;
        }
        final int blColId = this.main.ctx.getColorFirstHintIdByLDrawId(entry.color, LDICColorHintSource.BRICKLINK);
        if (blColId < 0) {
            this.main.log("no Bricklink color found for " + entry.color);
            return;
        }
        final String plainName = LDIVPartList.plainName(entry.name);
        this.main.log("trying to get Bricklink image for " + entry.name + "/" + blColId);
        this.main.updateBackgroundActivityCounter(1);
        this.main.runInBackground(new Runnable(){

            @Override
            public void run() {
                Image img = null;
                try {
                    String url = "https://img.bricklink.com/ItemImage/PN/" + blColId + "/" + plainName + ".png";
                    InputStream is = LDIVPartList.this.main.ctx.loadCachedWebResource("img_bl_" + plainName + "_" + blColId, url, LDIVPartList.this.main);
                    img = new Image(is, 90.0, 90.0, true, true);
                    is.close();
                }
                catch (IOException e) {
                    try {
                        String url = "https://img.bricklink.com/P/" + blColId + "/" + plainName + ".jpg";
                        InputStream is = LDIVPartList.this.main.ctx.loadCachedWebResource("img_bl_" + plainName + "_" + blColId, url, LDIVPartList.this.main);
                        img = new Image(is, 90.0, 90.0, true, true);
                        is.close();
                    }
                    catch (IOException e2) {
                        Platform.runLater(() -> {
                            LDIVPartList.this.main.log("failed to load Bricklink image for " + lDIVPLEntry.name + "/" + blColId);
                            LDIVPartList.this.main.updateBackgroundActivityCounter(-1);
                        });
                        return;
                    }
                }
                Image fimg = img;
                if (fimg != null) {
                    Platform.runLater(() -> {
                        lDIVPLEntry.imgBricklink = fimg;
                        LDIVPartList.this.main.updateBackgroundActivityCounter(-1);
                        LDIVPartList.this.main.log("successfully loaded Bricklink image for " + lDIVPLEntry.name + "/" + blColId);
                        if (entry == LDIVPartList.this.tableView.getSelectionModel().getSelectedItem()) {
                            LDIVPartList.this.previewImgBricklink.setImage(lDIVPLEntry.imgBricklink);
                        }
                        if (LDIVPartList.this.imgConfig.isSelected()) {
                            LDIVPartList.this.tableView.refresh();
                        }
                    });
                }
            }
        });
    }

    private void getImageFromRebrickable(boolean all) {
        final ArrayList<LDIVPLEntry> todo = new ArrayList<LDIVPLEntry>();
        if (all) {
            todo.addAll((Collection<LDIVPLEntry>)this.filteredEntries);
        } else {
            todo.add((LDIVPLEntry)this.tableView.getSelectionModel().getSelectedItem());
        }
        this.main.updateBackgroundActivityCounter(todo.size());
        this.main.runInBackground(new Runnable(){

            @Override
            public void run() {
                int cnt = 0;
                for (LDIVPLEntry e : todo) {
                    if (e == null || e.imgRebrickable != null) {
                        Platform.runLater(() -> LDIVPartList.this.main.updateBackgroundActivityCounter(-1));
                        continue;
                    }
                    if (++cnt % 5 == 0) {
                        int sleep = cnt % 20 == 0 ? 3000 : 1000;
                        try {
                            Thread.sleep(sleep);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    LDIVPartList.this.doGetImageFromRebrickable(e);
                }
            }
        });
    }

    private void doGetImageFromRebrickable(LDIVPLEntry entry) {
        List<String> urls;
        int rbColId = this.main.ctx.getColorFirstHintIdByLDrawId(entry.color, LDICColorHintSource.REBRICKABLE);
        if (rbColId < 0) {
            Platform.runLater(() -> {
                this.main.updateBackgroundActivityCounter(-1);
                this.main.log("no Rebrickable color found for " + lDIVPLEntry.color);
            });
            return;
        }
        String plainName = LDIVPartList.plainName(entry.name);
        Platform.runLater(() -> this.main.log("trying to get Rebrickable image for " + lDIVPLEntry.name + "/" + rbColId));
        try {
            urls = LDIRebrickable.getImagePartURLs(plainName, rbColId);
        }
        catch (IOException ex) {
            Platform.runLater(() -> {
                this.main.updateBackgroundActivityCounter(-1);
                this.main.log("error getting Rebrickable image url for " + lDIVPLEntry.name + "/" + rbColId + ": " + ex.getClass().getName() + ": " + ex.getMessage());
            });
            return;
        }
        if (urls == null || urls.size() < 1) {
            Platform.runLater(() -> {
                this.main.updateBackgroundActivityCounter(-1);
                this.main.log("no Rebrickable image url found for " + lDIVPLEntry.name + "/" + rbColId);
            });
            return;
        }
        int index = 0;
        Image img = null;
        while (index < urls.size()) {
            try {
                InputStream is = this.main.ctx.loadCachedWebResource("img_rb_" + plainName + "_" + rbColId, urls.get(index), this.main);
                img = new Image(is, 90.0, 90.0, true, true);
                is.close();
                break;
            }
            catch (IOException e) {
                ++index;
            }
        }
        Image fimg = img;
        Platform.runLater(() -> {
            lDIVPLEntry.imgRebrickable = fimg;
            this.main.updateBackgroundActivityCounter(-1);
            if (lDIVPLEntry.imgRebrickable == null) {
                this.main.log("failed to load Rebrickable image for " + lDIVPLEntry.name + "/" + rbColId);
            } else {
                this.main.log("successfully loaded Rebrickable image for " + lDIVPLEntry.name + "/" + rbColId);
                if (entry == this.tableView.getSelectionModel().getSelectedItem()) {
                    this.previewImgRebrickable.setImage(lDIVPLEntry.imgRebrickable);
                }
            }
            if (this.imgConfig.isSelected()) {
                this.tableView.refresh();
            }
        });
    }

    private static enum FilterConfig {
        ALL("Show all", null),
        DIFF("Show diff", new Predicate<LDIVPLEntry>(){

            @Override
            public boolean test(LDIVPLEntry t) {
                if (t.addAmnts.size() == 0) {
                    return true;
                }
                for (int a : t.addAmnts) {
                    if (t.amount == a) continue;
                    return true;
                }
                return false;
            }
        }),
        SAME("Show same", new Predicate<LDIVPLEntry>(){

            @Override
            public boolean test(LDIVPLEntry t) {
                if (t.addAmnts.size() == 0) {
                    return true;
                }
                for (int a : t.addAmnts) {
                    if (t.amount == a) continue;
                    return false;
                }
                return true;
            }
        });

        public static final FilterConfig DEFAULT;
        public final String name;
        public final Predicate<LDIVPLEntry> predicate;

        static {
            DEFAULT = ALL;
        }

        private FilterConfig(String in, Predicate<LDIVPLEntry> ip) {
            this.name = in;
            this.predicate = ip;
        }

        public String toString() {
            return this.name;
        }
    }

    private static class LDIVPLEntry {
        private Image imgBricklink;
        private Image imgRebrickable;
        private String name;
        private String desc;
        private int color;
        private int amount;
        private LDrawPart part;
        private LDrawPartOrigin origin;
        private ArrayList<Integer> addAmnts = new ArrayList();

        private LDIVPLEntry() {
        }
    }
}

