/*
 * Decompiled with CFR 0.152.
 */
package ldinsp.ext;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import ldinsp.base.LDILogger;
import ldinsp.context.LDICColor;
import ldinsp.context.LDICColorHint;
import ldinsp.context.LDICColorHintSource;
import ldinsp.context.LDIContext;
import ldinsp.ext.LDIEAImage;
import ldinsp.ext.LDIEAPart;
import ldinsp.ext.LDIEARebrickableInventory;
import ldinsp.ext.LDIEARebrickablePbg;
import ldinsp.ext.LDIEARebrickableSet;
import ldinsp.ext.LDIEAWeblink;
import ldinsp.ext.LDIExternalActionResult;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class LDIRebrickable {
    /*
     * Unable to fully structure code
     */
    public static List<List<LDICColorHint>> loadColorMappingFromWeb() throws IOException {
        list = new ArrayList<List<LDICColorHint>>();
        br = new BufferedReader(new InputStreamReader(LDIContext.loadWebResource("https://rebrickable.com/colors/")));
        if (!LDIRebrickable.searchKey(br, "<tr>")) {
            throw new IOException("parsing Rebrickable color table failed: table start not found");
        }
        if (LDIRebrickable.checkHeader(br)) ** GOTO lbl11
        throw new IOException("parsing Rebrickable color table failed: header has unexpected content");
lbl-1000:
        // 1 sources

        {
            c = LDIRebrickable.evaluateColor(br);
            if (c == null) continue;
            list.add(c);
lbl11:
            // 3 sources

            ** while (LDIRebrickable.searchKey((BufferedReader)br, (String)"<tr>"))
        }
lbl12:
        // 1 sources

        br.close();
        return list;
    }

    private static boolean searchKey(BufferedReader br, String key) throws IOException {
        String line;
        while ((line = br.readLine()) != null) {
            if (!line.trim().equals(key)) continue;
            return true;
        }
        return false;
    }

    private static boolean checkHeader(BufferedReader br) throws IOException {
        return LDIRebrickable.checkNextLine(br, "<th>Img</th>") && LDIRebrickable.checkNextLine(br, "<th>ID</th>") && LDIRebrickable.checkNextLine(br, "<th>Name</th>") && LDIRebrickable.checkNextLine(br, "<th>RGB</th>") && LDIRebrickable.checkNextLine(br, "<th>Num Parts</th>") && LDIRebrickable.checkNextLine(br, "<th>Num Sets</th>") && LDIRebrickable.checkNextLine(br, "<th>First Year</th>") && LDIRebrickable.checkNextLine(br, "<th>Last Year</th>") && LDIRebrickable.checkNextLine(br, "<th>LEGO</th>") && LDIRebrickable.checkNextLine(br, "<th>LDraw</th>") && LDIRebrickable.checkNextLine(br, "<th>BrickLink</th>");
    }

    private static boolean checkNextLine(BufferedReader br, String expectation) throws IOException {
        String line = br.readLine();
        if (line == null) {
            return false;
        }
        return line.trim().equals(expectation);
    }

    private static boolean skipLine(BufferedReader br) throws IOException {
        return br.readLine() != null;
    }

    private static boolean addMultiLineMapping(BufferedReader br, ArrayList<LDICColorHint> c, LDICColorHintSource source) throws IOException {
        if (!LDIRebrickable.checkNextLine(br, "<td>")) {
            return false;
        }
        while (true) {
            int firstApo;
            String line;
            if ((line = br.readLine()) == null) {
                return false;
            }
            if ((line = line.trim()).length() == 0 || line.equals("<br>")) continue;
            if (line.equals("</td>")) break;
            int firstSpace = (line = LDIRebrickable.untagString(line)).indexOf(32);
            if (firstSpace == -1 || (firstApo = line.indexOf("&#39;")) == -1) continue;
            int secondApo = line.indexOf("&#39;", firstApo + 1);
            String idStr = line.substring(0, firstSpace);
            int id = -1;
            try {
                id = Integer.parseInt(idStr);
            }
            catch (NumberFormatException e) {
                continue;
            }
            String name = line.substring(firstApo + 5, secondApo).trim();
            c.add(new LDICColorHint(source, id, name));
        }
        return true;
    }

    private static List<LDICColorHint> evaluateColor(BufferedReader br) throws IOException {
        if (!LDIRebrickable.searchKey(br, "</td>")) {
            return null;
        }
        String idStr = LDIRebrickable.untagLine(br);
        if (idStr == null) {
            return null;
        }
        String name = LDIRebrickable.untagLine(br);
        if (name == null) {
            return null;
        }
        ArrayList<LDICColorHint> c = new ArrayList<LDICColorHint>();
        int id = -1;
        try {
            id = Integer.parseInt(idStr);
        }
        catch (NumberFormatException e) {
            return null;
        }
        c.add(new LDICColorHint(LDICColorHintSource.REBRICKABLE, id, name));
        if (!LDIRebrickable.skipLine(br)) {
            return null;
        }
        if (!LDIRebrickable.skipLine(br)) {
            return null;
        }
        if (!LDIRebrickable.skipLine(br)) {
            return null;
        }
        if (!LDIRebrickable.skipLine(br)) {
            return null;
        }
        if (!LDIRebrickable.skipLine(br)) {
            return null;
        }
        if (!LDIRebrickable.addMultiLineMapping(br, c, LDICColorHintSource.LEGO)) {
            return null;
        }
        if (!LDIRebrickable.addMultiLineMapping(br, c, LDICColorHintSource.LDRAW)) {
            return null;
        }
        if (!LDIRebrickable.addMultiLineMapping(br, c, LDICColorHintSource.BRICKLINK)) {
            return null;
        }
        return c;
    }

    private static String untagLine(BufferedReader br) throws IOException {
        String line = br.readLine();
        if (line == null) {
            return null;
        }
        return LDIRebrickable.untagString(line.trim());
    }

    private static String untagString(String line) {
        int posOpen;
        StringBuffer sb = new StringBuffer(line);
        while ((posOpen = sb.indexOf("<")) >= 0) {
            int posClose = sb.indexOf(">", posOpen);
            if (posClose == -1) break;
            sb.delete(posOpen, posClose + 1);
        }
        return sb.toString();
    }

    public static List<String> getImagePartURLs(String partName, int partCol) throws IOException {
        String line;
        ArrayList<String> res = new ArrayList<String>();
        BufferedReader br = new BufferedReader(new InputStreamReader(LDIContext.loadWebResource("https://rebrickable.com/parts/" + partName + "/x/" + partCol)));
        String lastImg = null;
        String element = null;
        String ldraw = null;
        String photo = null;
        while ((line = br.readLine()) != null) {
            if (line.startsWith("<img ")) {
                lastImg = line;
                continue;
            }
            if (line.equals("<p class=\"text-center\">Element</p>")) {
                element = LDIRebrickable.getSrc(lastImg);
                lastImg = null;
                continue;
            }
            if (line.equals("<p class=\"text-center\">LDraw</p>")) {
                ldraw = LDIRebrickable.getSrc(lastImg);
                lastImg = null;
                continue;
            }
            if (!line.equals("<p class=\"text-center\">Photo</p>")) continue;
            photo = LDIRebrickable.getSrc(lastImg);
            lastImg = null;
        }
        br.close();
        if (element != null) {
            res.add(element);
        }
        if (photo != null) {
            res.add(photo);
        }
        if (ldraw != null) {
            res.add(ldraw);
        }
        return res;
    }

    private static String getSrc(String img) {
        if (img == null) {
            return null;
        }
        int start = img.indexOf("src=\"");
        if (start == -1) {
            return null;
        }
        int end = img.indexOf(34, start += 5);
        if (end == -1) {
            return null;
        }
        String url = img.substring(start, end);
        if (url.contains("nil.png")) {
            return null;
        }
        return url;
    }

    public static List<LDIExternalActionResult> searchSet(String set, LDIContext ctx, LDILogger logger) {
        ArrayList<LDIExternalActionResult> res = new ArrayList<LDIExternalActionResult>();
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(ctx.loadCachedWebResource("rbss_" + set, "https://rebrickable.com/sets/" + set, logger)));
            String inventory = null;
            boolean nextIsName = false;
            String name = null;
            while ((line = br.readLine()) != null) {
                int end;
                int start = line.indexOf("load_inventory(\"/inventory/");
                if (start > 0 && (end = line.indexOf(47, start + 27)) > 0) {
                    inventory = line.substring(start + 27, end);
                    continue;
                }
                if (line.equals("<td>Name</td>")) {
                    nextIsName = true;
                    continue;
                }
                if (!nextIsName) continue;
                nextIsName = false;
                if (!line.startsWith("<td>") || !line.endsWith("</td>")) continue;
                name = line.substring(4, line.length() - 5);
            }
            br.close();
            if (inventory != null) {
                LDIExternalActionResult ear = new LDIExternalActionResult(String.format("RB %s: %s %s", inventory, set, name != null ? name : "(no name)"));
                ear.actions.add(new LDIEARebrickablePbg("https://rebrickable.com/inventory/" + inventory + "/parts/?format=ldcadpbg&inc_spares=0"));
                ear.actions.add(new LDIEARebrickableInventory(inventory));
                ear.actions.add(new LDIEAWeblink("https://rebrickable.com/sets/" + set));
                res.add(ear);
            }
            if (logger != null && res.size() == 0) {
                logger.log(String.format("Rebrickable set search: set %s not found", set));
            }
            return res;
        }
        catch (IOException e) {
            if (logger != null) {
                logger.log("Rebrickable set search: exception: " + e.getClass().getName() + ": " + e.getMessage());
            }
            return null;
        }
    }

    public static List<LDIExternalActionResult> getInventory(String inventory, LDIContext ctx, LDILogger logger) {
        ArrayList<LDIExternalActionResult> res = new ArrayList<LDIExternalActionResult>();
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(ctx.loadCachedWebResource("rbiv_" + inventory, "https://rebrickable.com/inventory/" + inventory + "/parts/?format=table&", logger)));
            int trState = -1;
            String img = null;
            String part = null;
            int amount = -1;
            String color = null;
            String description = null;
            block16: while ((line = br.readLine()) != null) {
                block2 : switch (trState) {
                    case -1: 
                    case 0: {
                        if (!line.equals("<tr>")) continue block16;
                        trState = 1;
                        break;
                    }
                    case 1: {
                        if (line.equals("<td>")) {
                            ++trState;
                            break;
                        }
                        trState = -1;
                        break;
                    }
                    case 2: {
                        img = line;
                        ++trState;
                        break;
                    }
                    case 3: {
                        if (line.equals("</td>")) {
                            ++trState;
                            break;
                        }
                        trState = -1;
                        break;
                    }
                    default: {
                        if (!line.startsWith("<td>") || !line.endsWith("</td>")) continue block16;
                        String elem = line.substring(4, line.length() - 5);
                        switch (trState) {
                            case 4: {
                                part = elem;
                                ++trState;
                                break block2;
                            }
                            case 5: {
                                try {
                                    amount = Integer.parseInt(elem);
                                    ++trState;
                                }
                                catch (NumberFormatException e) {
                                    trState = -1;
                                }
                                continue block16;
                            }
                            case 6: {
                                color = elem;
                                ++trState;
                                break block2;
                            }
                            case 7: {
                                description = elem;
                                LDIExternalActionResult ear = new LDIExternalActionResult(String.valueOf(amount) + "x " + part + " in " + color + ": " + description);
                                ear.actions.add(new LDIEAImage(LDIRebrickable.getDelimitedString(img, "data-src=\"", "?")));
                                LDICColor col = ctx.getColorByFirstHintName(color, LDICColorHintSource.REBRICKABLE);
                                int colId = col == null ? 16 : col.id;
                                ear.actions.add(new LDIEAPart(String.valueOf(part) + ".dat", description, colId, amount));
                                res.add(ear);
                            }
                        }
                        trState = -1;
                    }
                }
            }
            br.close();
            return res;
        }
        catch (IOException e) {
            if (logger != null) {
                logger.log("Rebrickable get inventory: exception: " + e.getClass().getName() + ": " + e.getMessage());
            }
            return null;
        }
    }

    public static List<LDIExternalActionResult> quickSearch(String key, LDIContext ctx, LDILogger logger) {
        ArrayList<LDIExternalActionResult> res = new ArrayList<LDIExternalActionResult>();
        try {
            JSONTokener t = new JSONTokener(ctx.loadCachedWebResource("rbqs_" + key, "https://rebrickable.com/search/suggest/?q=" + LDIRebrickable.httpCleanup(key), logger));
            JSONArray pa = new JSONArray(t);
            boolean foundOne = false;
            for (Object e : pa) {
                if (!(e instanceof JSONObject)) continue;
                foundOne = true;
                JSONObject eo = (JSONObject)e;
                String id = eo.getString("id");
                String name = eo.getString("name");
                String url = eo.getString("url");
                String img = LDIRebrickable.getDelimitedString(name, "img src=\"", "\"");
                int lastClose = name.lastIndexOf(62);
                if (lastClose == -1) continue;
                String desc = name.substring(lastClose + 1).trim();
                LDIExternalActionResult ear = new LDIExternalActionResult(String.format("RBq: %s", desc));
                if (img != null && img.length() > 0 && !img.endsWith("nil.png")) {
                    ear.actions.add(img.startsWith("http") ? new LDIEAImage(img) : new LDIEAImage("https://rebrickable.com" + img));
                }
                if (url != null && url.startsWith("/sets/")) {
                    ear.actions.add(new LDIEARebrickableSet(id));
                }
                ear.actions.add(new LDIEAWeblink("https://rebrickable.com" + url));
                res.add(ear);
            }
            if (!foundOne && logger != null) {
                logger.log("Rebrickable quick search: result was empty");
            }
            return res;
        }
        catch (IOException | JSONException e) {
            if (logger != null) {
                logger.log("Rebrickable quick search: exception: " + e.getClass().getName() + ": " + e.getMessage());
            }
            return null;
        }
    }

    private static String httpCleanup(String data) {
        data = data.replaceAll("\\+", "%2B");
        data = data.replaceAll("\\\\", "%5C");
        data = data.replaceAll("\\/", "%2F");
        data = data.replaceAll("\\&", "%26");
        data = data.replace(' ', '+');
        return data;
    }

    private static String getDelimitedString(String data, String before, String after) {
        int end;
        int start = data.indexOf(before);
        if (start == -1) {
            return null;
        }
        start += before.length();
        if (after == null) {
            end = data.length();
        } else {
            end = data.indexOf(after, start);
            if (end == -1) {
                return null;
            }
        }
        return data.substring(start, end).trim();
    }
}

