/*
 * Decompiled with CFR 0.152.
 */
package ldinsp.ext;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ldinsp.base.LDILogger;
import ldinsp.context.LDIContext;
import ldinsp.ext.LDIEAWeblink;
import ldinsp.ext.LDIExternalActionResult;

public class LDILDraw {
    private static final Pattern VALID_ITEM = Pattern.compile("<td>(.*)</td><td>(.*)</td><td>(.*)</td><td>(.*)</td><td>(.*)</td>", 2);
    private static final Pattern LINK = Pattern.compile("<a href=\"(.*)\">(.*)</a>", 2);

    public static List<LDIExternalActionResult> searchOMR(String key, LDIContext ctx, LDILogger logger) {
        key = LDILDraw.httpCleanup(key);
        ArrayList<LDIExternalActionResult> res = new ArrayList<LDIExternalActionResult>();
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(ctx.loadCachedWebResource("omrs_" + key, "https://omr.ldraw.org/files/ajax/table?search=" + key, logger)));
            String item = "";
            boolean inBody = false;
            while ((line = br.readLine()) != null) {
                String loli = line.toLowerCase();
                if (inBody) {
                    if (loli.contains("</tbody>")) {
                        inBody = false;
                        break;
                    }
                    if (loli.contains("<tr>")) continue;
                    if (loli.contains("</tr>")) {
                        LDIExternalActionResult set = LDILDraw.handleItem(item);
                        if (set != null) {
                            res.add(set);
                        }
                        item = "";
                        continue;
                    }
                    item = String.valueOf(item) + line.trim();
                    continue;
                }
                if (!loli.contains("<tbody>")) continue;
                inBody = true;
            }
            br.close();
            if (logger != null && res.size() == 0) {
                logger.log(String.format("OMR set search did not found anything for: %s", key));
            }
            return res;
        }
        catch (IOException e) {
            if (logger != null) {
                logger.log("OMR set search: exception: " + e.getClass().getName() + ": " + e.getMessage());
            }
            return null;
        }
    }

    private static String httpCleanup(String data) {
        data = data.replaceAll("\\+", "%2B");
        data = data.replaceAll("\\\\", "%5C");
        data = data.replaceAll("\\/", "%2F");
        data = data.replaceAll("\\&", "%26");
        data = data.replace(' ', '+');
        return data;
    }

    private static LDIExternalActionResult handleItem(String item) {
        Matcher matcher = VALID_ITEM.matcher(item);
        if (!matcher.matches()) {
            return null;
        }
        String set = matcher.group(1);
        Matcher link = LINK.matcher(set);
        String url = null;
        if (link.matches()) {
            set = link.group(2);
            url = "https://omr.ldraw.org" + link.group(1);
        }
        String description = String.format("%s (%s, theme: %s, author: %s)", LDILDraw.unHtml(set), matcher.group(2), matcher.group(3), matcher.group(4));
        LDIExternalActionResult res = new LDIExternalActionResult(description);
        if (url != null) {
            res.actions.add(new LDIEAWeblink(url));
        }
        return res;
    }

    private static String unHtml(String s) {
        if (!s.contains("&")) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s);
        int pos = 0;
        while ((pos = sb.indexOf("&#", pos)) >= 0) {
            int end = sb.indexOf(";", pos + 1);
            if (end < 0 || end > pos + 6) {
                pos += 2;
                continue;
            }
            try {
                int c = Integer.parseInt(sb.substring(pos + 2, end));
                sb.delete(pos, end + 1);
                sb.insert(pos, (char)c);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            pos = end + 1;
        }
        return sb.toString();
    }
}

