/*
 * Decompiled with CFR 0.152.
 */
package ldinsp.data;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import ldinsp.base.LDILogger;
import ldinsp.base.LDIWorker;
import ldinsp.context.LDIContext;
import ldinsp.data.LDIDLooseItem;
import ldinsp.data.LDIData;
import ldinsp.data.LDIDataSaveable;
import ldinsp.ldraw.LDrawLinePartRef;
import ldinsp.ldraw.LDrawPart;
import ldinsp.ldraw.LDrawPartOrigin;
import ldinsp.util.StringNumberComparator;

public class LDIDPartList
implements LDIDataSaveable {
    private String id;
    private String explDescription;
    private boolean fixed;
    private ArrayList<LDIDLooseItem> parts = new ArrayList();
    private static final Comparator<LDIData> LIST_COMP = new Comparator<LDIData>(){

        @Override
        public int compare(LDIData o1, LDIData o2) {
            int diff = o1.getColId() - o2.getColId();
            if (diff != 0) {
                return diff;
            }
            return StringNumberComparator.compare(o1.getName(), o2.getName());
        }
    };

    public LDIDPartList() {
    }

    public LDIDPartList(String iid) {
        this.id = iid;
    }

    public LDIDPartList(final LDIContext ctx, String iid, LDrawPart part) {
        if (part == null) {
            throw new NullPointerException();
        }
        this.id = iid;
        LDIWorker w = new LDIWorker(){

            @Override
            public LDrawPart handlePartRef(LDrawLinePartRef ref, String partName, int colId, int pcol) {
                String lcn = partName.toLowerCase();
                if (!lcn.endsWith(".dat")) {
                    return ctx.getPart(ref.owner, partName, null);
                }
                LDrawPart dest = ctx.getPart(ref.owner, partName, null);
                LDIDPartList.this.internAddIncPart(partName, colId != 16 ? colId : pcol, 1, dest == null ? LDrawPartOrigin.UNRESOLVED : dest.origin);
                return null;
            }
        };
        w.work(part, false);
        this.sortParts();
    }

    @Override
    public String getSaveString() {
        return this.id;
    }

    @Override
    public boolean needsSubPartSaving() {
        return true;
    }

    @Override
    public void restoreFromSaveString(int colId, int amount, String data, LDILogger logger) {
        this.id = data;
        this.parts.clear();
    }

    @Override
    public boolean restoreSubElements(List<LDIData> subs, LDILogger logger) {
        boolean res = true;
        for (LDIData sub : subs) {
            if (sub instanceof LDIDLooseItem) {
                this.parts.add((LDIDLooseItem)sub);
                continue;
            }
            res = false;
            logger.log("PartList.restoreSubElements accepts only LDIDLooseItem");
        }
        return res;
    }

    public void setDescription(String nd) {
        this.explDescription = nd;
    }

    public boolean addEmptyPart() {
        if (this.fixed) {
            return false;
        }
        this.parts.add(new LDIDLooseItem("!new", 0, 1, LDrawPartOrigin.UNRESOLVED));
        this.sortParts();
        return true;
    }

    public boolean addPart(String partName, int col, int amount, LDrawPartOrigin origin, boolean fixAfterwards) {
        if (this.fixed) {
            return false;
        }
        this.internAddIncPart(partName, col, amount, origin);
        this.sortParts();
        if (fixAfterwards) {
            this.fixed = true;
        }
        return true;
    }

    public boolean addPartList(LDIDPartList pl, boolean fixAfterwards) {
        if (this.fixed) {
            return false;
        }
        if (pl == null) {
            return false;
        }
        for (LDIData lDIData : pl.parts) {
            this.internAddIncPart(lDIData.getName(), lDIData.getColId(), lDIData.getAmount(), LDrawPartOrigin.UNRESOLVED);
        }
        this.sortParts();
        if (fixAfterwards) {
            this.fixed = true;
        }
        return true;
    }

    public boolean updatePart(String partName, int col, int amount, boolean set) {
        if (this.fixed) {
            return false;
        }
        if (set) {
            this.internUpdatePart(partName, col, amount);
        } else {
            this.internAddIncPart(partName, col, amount, LDrawPartOrigin.UNRESOLVED);
        }
        this.sortParts();
        return true;
    }

    public boolean removePart(LDIData item) {
        if (this.fixed || item == null) {
            return false;
        }
        return this.internRemovePart(item.getName(), item.getColId());
    }

    public int resolveMoved(LDIContext ctx) {
        if (this.fixed) {
            return 0;
        }
        int cnt = 0;
        for (LDIDLooseItem li : this.parts) {
            LDrawPart lim;
            LDrawPart lip = li.getPart(ctx);
            if (lip == (lim = ctx.getMoveCleanedPart(lip))) continue;
            li.setName(lip.loadedFromFilename);
            ++cnt;
        }
        return cnt;
    }

    public void fix() {
        this.fixed = true;
    }

    public boolean isFixed() {
        return this.fixed;
    }

    public void sortParts() {
        this.parts.sort(LIST_COMP);
    }

    @Override
    public void refresh() {
        for (LDIData lDIData : this.parts) {
            lDIData.refresh();
        }
    }

    @Override
    public boolean isRenderable(LDIContext ctx) {
        return false;
    }

    @Override
    public boolean isRenameable() {
        return true;
    }

    @Override
    public void setName(String name) {
        this.id = name;
    }

    @Override
    public String getName() {
        return this.id;
    }

    @Override
    public String getDescription(LDIContext ctx) {
        if (this.explDescription != null) {
            return this.explDescription;
        }
        return "PL " + this.id;
    }

    @Override
    public LDrawPart getPart(LDIContext ctx) {
        return null;
    }

    @Override
    public LDIDPartList getPartList(LDIContext ctx) {
        return this;
    }

    @Override
    public boolean isAdjustable() {
        return false;
    }

    @Override
    public void setColId(int col) {
    }

    @Override
    public int getColId() {
        return -1;
    }

    @Override
    public void setAmount(int amount) {
    }

    @Override
    public int getAmount() {
        return 0;
    }

    @Override
    public LDrawPartOrigin getPartOrigin(LDIContext ctx) {
        return null;
    }

    @Override
    public boolean hasSubElements(LDIContext ctx) {
        return true;
    }

    @Override
    public List<? extends LDIData> getSubElements(LDIContext ctx) {
        return this.parts;
    }

    private void internAddIncPart(String partName, int col, int amount, LDrawPartOrigin origin) {
        int count = amount;
        for (LDIDLooseItem li : this.parts) {
            if (!li.getName().equals(partName) || li.getColId() != col) continue;
            count += li.getAmount();
            this.parts.remove(li);
            break;
        }
        this.parts.add(new LDIDLooseItem(partName, col, count, origin));
    }

    private void internUpdatePart(String partName, int col, int amount) {
        LDrawPartOrigin origin = LDrawPartOrigin.UNRESOLVED;
        for (LDIDLooseItem li : this.parts) {
            if (!li.getName().equals(partName) || li.getColId() != col) continue;
            origin = li.getPartOrigin(null);
            this.parts.remove(li);
            break;
        }
        if (amount != 0) {
            this.parts.add(new LDIDLooseItem(partName, col, amount, origin));
        }
    }

    private boolean internRemovePart(String partName, int col) {
        LDIDLooseItem remove = null;
        for (LDIDLooseItem li : this.parts) {
            if (!li.getName().equals(partName) || li.getColId() != col) continue;
            remove = li;
            break;
        }
        if (remove == null) {
            return false;
        }
        this.parts.remove(remove);
        return true;
    }
}

