/*
 * Decompiled with CFR 0.152.
 */
package ldinsp.context;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import ldinsp.base.LDILogger;
import ldinsp.base.LDIWorker;
import ldinsp.base.LDIWorkerColor;
import ldinsp.context.LDICColor;
import ldinsp.context.LDICColorHint;
import ldinsp.context.LDICColorHintSource;
import ldinsp.context.LDICColorProp;
import ldinsp.context.LDICPDir;
import ldinsp.context.LDICPTest;
import ldinsp.context.LDICPZip;
import ldinsp.context.LDICPartSource;
import ldinsp.data.LDIData;
import ldinsp.data.LDIDataSaveable;
import ldinsp.ldraw.LDrawFiles;
import ldinsp.ldraw.LDrawLineParMeta;
import ldinsp.ldraw.LDrawLinePartRef;
import ldinsp.ldraw.LDrawPart;
import ldinsp.ldraw.LDrawPartOrigin;
import ldinsp.util.ColorHelper;

public class LDIContext {
    public static String defaultContextFilename = "LDInspector.ldi";
    private static final LDICColor DEFBLACK = new LDICColor(0, 85138943, 0x595959FF, LDICColorProp.SOLID, "Black");
    private ArrayList<LDICPartSource> parts = new ArrayList();
    private String webCachePrefix = null;
    private String defaultAuthor = null;
    private boolean useInternalColors;
    private ArrayList<LDICColor> colors = new ArrayList();

    public static LDrawPart loadDefaultContextFile() {
        try {
            BufferedReader br = new BufferedReader(new FileReader(defaultContextFilename));
            LDrawPart rp = LDrawFiles.parseDef("LDInspector.ldi", br, LDrawPartOrigin.SELF, null);
            br.close();
            return rp;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public LDIContext() {
        this.colors.add(DEFBLACK);
    }

    public void dismissPartCache() {
        for (LDICPartSource s : this.parts) {
            s.dismissPartCache();
        }
    }

    public void addSource(LDICPartSource s) {
        if (!this.parts.contains(s)) {
            this.parts.add(s);
        }
    }

    public void removeSource(LDICPartSource s) {
        this.parts.remove(s);
    }

    public void removeAllSources() {
        this.parts.clear();
    }

    public List<LDICPartSource> getSources() {
        return this.parts;
    }

    public LDrawPart getPart(LDrawPart forPart, String name, LDILogger logger) {
        if (forPart != null && forPart.subParts != null) {
            for (LDrawPart sp : forPart.subParts) {
                if (!sp.givenFilename.equalsIgnoreCase(name)) continue;
                return sp;
            }
        }
        for (LDICPartSource s : this.parts) {
            LDrawPart p = s.lookupPart(name, logger);
            if (p == null) continue;
            return p;
        }
        return null;
    }

    public List<LDrawPart> getAllPartHeaders(LDILogger logger) {
        ArrayList<LDrawPart> list = new ArrayList<LDrawPart>();
        for (LDICPartSource s : this.parts) {
            s.addAllPartHeaders(list, logger);
        }
        return list;
    }

    public LDrawPart getMoveCleanedPart(LDrawPart part) {
        while (part != null && part.description != null && part.description.toLowerCase().startsWith("~moved to ")) {
            LDrawPart newPart = this.getPart(null, String.valueOf(part.description.substring(10).trim()) + ".dat", null);
            if (newPart == null) break;
            part = newPart;
        }
        return part;
    }

    public void setWebCache(String path) {
        this.webCachePrefix = path;
    }

    public String getWebCache() {
        return this.webCachePrefix;
    }

    public void setDefaultAuthor(String author) {
        this.defaultAuthor = author;
    }

    public String getDefaultAuthor() {
        return this.defaultAuthor;
    }

    public InputStream loadCachedResource(String cacheName) throws IOException {
        if (this.webCachePrefix == null || cacheName == null || cacheName.length() == 0) {
            return null;
        }
        File file = new File(String.valueOf(this.webCachePrefix) + cacheName);
        if (!file.exists()) {
            return null;
        }
        return new FileInputStream(file);
    }

    public void saveWebResource(File toFile, String webUrl) throws IOException {
        int curLen;
        InputStream is = LDIContext.loadWebResource(webUrl);
        FileOutputStream os = new FileOutputStream(toFile);
        byte[] buffer = new byte[1024];
        while ((curLen = is.read(buffer, 0, buffer.length)) != -1) {
            ((OutputStream)os).write(buffer, 0, curLen);
        }
        ((OutputStream)os).close();
        is.close();
    }

    public InputStream loadCachedWebResource(String cacheName, String webUrl, LDILogger logger) throws IOException {
        if (this.webCachePrefix == null || cacheName == null || cacheName.length() == 0) {
            return LDIContext.loadWebResource(webUrl);
        }
        File file = new File(String.valueOf(this.webCachePrefix) + cacheName);
        try {
            if (!file.exists()) {
                this.saveWebResource(file, webUrl);
            }
            return new FileInputStream(file);
        }
        catch (IOException e) {
            if (logger != null) {
                logger.log("cache access exception: " + e.getClass().getName() + ": " + e.getMessage());
            }
            return LDIContext.loadWebResource(webUrl);
        }
    }

    public static InputStream loadWebResource(String webUrl) throws IOException {
        URL url = new URL(webUrl);
        URLConnection c = url.openConnection();
        c.setUseCaches(false);
        c.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.95 Safari/537.11");
        c.connect();
        return c.getInputStream();
    }

    public void activateInternalColors() {
        this.useInternalColors = true;
        this.colors.clear();
        this.colors.addAll(LDICColor.getPredefinedColors());
        this.sortColors();
    }

    public boolean getInternalColorsState() {
        return this.useInternalColors;
    }

    public void addReplaceColor(LDICColor c) {
        this.useInternalColors = false;
        this.doRemoveColor(c.id);
        this.colors.add(c);
        this.sortColors();
    }

    public void addReplaceAllColors(List<LDICColor> cl) {
        this.useInternalColors = false;
        for (LDICColor c : cl) {
            this.doRemoveColor(c.id);
            this.colors.add(c);
        }
        this.sortColors();
    }

    private void doRemoveColor(int id) {
        int i = this.colors.size() - 1;
        while (i >= 0) {
            if (this.colors.get((int)i).id == id) {
                this.colors.remove(i);
            }
            --i;
        }
    }

    public void removeColor(LDICColor c) {
        this.useInternalColors = false;
        this.colors.remove(c);
        if (this.colors.size() == 0) {
            this.colors.add(DEFBLACK);
        }
    }

    public void removeAllColors() {
        this.useInternalColors = false;
        this.colors.clear();
        this.colors.add(DEFBLACK);
    }

    public List<LDICColor> getColors() {
        return this.colors;
    }

    public LDICColor getColorById(int id) {
        for (LDICColor bc : this.colors) {
            if (bc.id != id) continue;
            return bc;
        }
        if ((id & 0xFF000000) == 0x2000000) {
            int rgba = ColorHelper.getRgba(id & 0xFFFFFF, 255);
            LDICColor me = new LDICColor(id, rgba, ColorHelper.calcEdgeForFace(rgba), LDICColorProp.SOLID, "direct-" + Integer.toHexString(id));
            this.colors.add(me);
            return me;
        }
        return this.colors.get(0);
    }

    public int getRgbaColorByIds(int id, int pid) {
        if (pid != -1) {
            if (id == 24) {
                return this.getColorById((int)pid).rgbaEdge;
            }
            if (id == 16) {
                return this.getColorById((int)pid).rgbaFace;
            }
        }
        return this.getColorById((int)id).rgbaFace;
    }

    public int getColorFirstHintIdByLDrawId(int id, LDICColorHintSource source) {
        int hintColId;
        LDICColorHint hint;
        LDICColor color = this.getColorById(id);
        if (color == null || (hint = color.getFirstHint(source)) == null || (hintColId = hint.id) < 0) {
            return -1;
        }
        return hintColId;
    }

    public LDICColor getColorByFirstHintId(int hintColId, LDICColorHintSource source) {
        for (LDICColor bc : this.colors) {
            LDICColorHint hint = bc.getFirstHint(source);
            if (hint == null || hint.id != hintColId) continue;
            return bc;
        }
        return null;
    }

    public LDICColor getColorByFirstHintName(String hintColName, LDICColorHintSource source) {
        for (LDICColor bc : this.colors) {
            LDICColorHint hint = bc.getFirstHint(source);
            if (hint == null || !hint.name.equalsIgnoreCase(hintColName)) continue;
            return bc;
        }
        return null;
    }

    public void save(PrintWriter w, List<LDIData> items, LDILogger logger) throws IOException {
        w.print("0 FILE LDIContext.ldi\n0 LDInspector context configuration\n0 Name: LDIContext.ldi\n0 Author: LDInspector\n\n");
        for (LDICPartSource ps : this.parts) {
            w.printf("0 %s %s [%s=%s] [%s=%s] [%s=%s]\n", "!LDINSP", "PART_SOURCE", "type", ps.getType(), "origin", ps.origin.nameShort, "dest", ps.getDest());
        }
        w.println();
        if (this.webCachePrefix != null) {
            w.printf("0 %s %s [%s=%s]\n\n", "!LDINSP", "WEB_CACHE", "dest", this.webCachePrefix);
        }
        if (this.defaultAuthor != null) {
            w.printf("0 %s %s [%s=%s]\n\n", "!LDINSP", "DEF_AUTHOR", "data", LDIContext.escape(this.defaultAuthor));
        }
        if (this.useInternalColors) {
            w.printf("0 %s %s\n", "!LDINSP", "INT_COLORS");
        } else {
            for (LDICColor c : this.colors) {
                LDICColorHintSource[] lDICColorHintSourceArray = LDICColorHintSource.values();
                int n = lDICColorHintSourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    LDICColorHintSource s = lDICColorHintSourceArray[n2];
                    String hint = LDICColorHint.hintsToString(c.hints, s);
                    if (hint != null && hint.length() > 0) {
                        w.printf("0                // %s\n", hint);
                    }
                    ++n2;
                }
                w.printf("0 !COLOUR %-53s CODE %3d    VALUE #%06X   EDGE #%06X", c.name.replace(' ', '_'), c.id, c.rgbaFace >>> 8, c.rgbaEdge >>> 8);
                int alpha = c.rgbaFace & 0xFF;
                if (alpha != 255) {
                    w.printf("   ALPHA %d", alpha);
                }
                if (c.prop != LDICColorProp.SOLID) {
                    w.printf("   %s", c.prop.name());
                }
                w.println();
            }
        }
        w.println();
        ArrayList<LDIDataSaveable> needsSubPartSaving = new ArrayList<LDIDataSaveable>();
        if (items != null) {
            for (LDIData item : items) {
                LDIContext.saveItem(w, item, needsSubPartSaving, logger);
            }
        }
        w.println();
        int cnt = 0;
        while (cnt < needsSubPartSaving.size()) {
            LDIDataSaveable saveable = (LDIDataSaveable)needsSubPartSaving.get(cnt);
            String subfilename = "LIST" + ++cnt;
            w.print("0 FILE " + subfilename + "\n" + "0 LDInspector list definition\n" + "0 Name: " + subfilename + "\n" + "0 Author: LDInspector\n");
            List<? extends LDIData> subs = saveable.getSubElements(this);
            for (LDIData lDIData : subs) {
                LDIContext.saveItem(w, lDIData, needsSubPartSaving, logger);
            }
            w.println();
        }
    }

    private static void saveItem(PrintWriter w, LDIData item, ArrayList<LDIDataSaveable> todo, LDILogger logger) {
        if (!(item instanceof LDIDataSaveable)) {
            if (logger != null) {
                logger.log("unsaveable element: " + item.getName());
            }
            return;
        }
        LDIDataSaveable saveable = (LDIDataSaveable)item;
        if (saveable.needsSubPartSaving()) {
            todo.add(saveable);
            int cnt = todo.size();
            w.printf("0 %s %s [%s=%s] [%s=%d] [%s=%d] [%s=LIST%d] [%s=%s]\n", "!LDINSP", "DATA_LIST", "type", item.getClass().getSimpleName(), "colId", item.getColId(), "amount", item.getAmount(), "source", cnt, "data", saveable.getSaveString());
        } else {
            w.printf("0 %s %s [%s=%s] [%s=%d] [%s=%d] [%s=%s]\n", "!LDINSP", "DATA_ITEM", "type", item.getClass().getSimpleName(), "colId", item.getColId(), "amount", item.getAmount(), "data", saveable.getSaveString());
        }
    }

    public static LDIContext load(LDrawPart from, LDILogger logger) {
        final LDIContext me = new LDIContext();
        me.activateInternalColors();
        LDIWorkerColor w = new LDIWorkerColor(logger){

            @Override
            public void handleWorkedColor(LDICColor c) {
                if (me.useInternalColors) {
                    me.colors.clear();
                    me.useInternalColors = false;
                }
                me.doRemoveColor(c.id);
                me.colors.add(c);
            }

            @Override
            public void handleParMeta(LDrawLineParMeta meta) {
                if (!"!LDINSP".equals(meta.system)) {
                    return;
                }
                switch (meta.type) {
                    case "WEB_CACHE": {
                        String dest = meta.options.get("dest");
                        if (dest == null) {
                            return;
                        }
                        me.setWebCache(dest);
                        return;
                    }
                    case "DEF_AUTHOR": {
                        String dest = meta.options.get("data");
                        if (dest == null) {
                            return;
                        }
                        me.setDefaultAuthor(LDIContext.unescape(dest));
                        return;
                    }
                    case "INT_COLORS": {
                        me.activateInternalColors();
                        return;
                    }
                    case "PART_SOURCE": {
                        String type = meta.options.get("type");
                        String origin = meta.options.get("origin");
                        String dest = meta.options.get("dest");
                        if (type == null || origin == null || dest == null) {
                            return;
                        }
                        LDrawPartOrigin originObj = LDrawPartOrigin.getByShortName(origin);
                        switch (type) {
                            case "ZIP": {
                                me.parts.add(new LDICPZip(dest, originObj));
                                break;
                            }
                            case "Directory": {
                                me.parts.add(new LDICPDir(dest, originObj));
                                break;
                            }
                            case "Test": {
                                me.parts.add(new LDICPTest(originObj));
                            }
                        }
                        return;
                    }
                }
            }
        };
        w.work(from, true);
        if (!me.useInternalColors) {
            me.sortColors();
        }
        return me;
    }

    public List<LDIData> getDataItems(LDrawPart from, LDILogger logger) {
        return this.getDataItems(from, from, logger);
    }

    private List<LDIData> getDataItems(LDrawPart from, final LDrawPart root, final LDILogger logger) {
        final ArrayList<LDIData> res = new ArrayList<LDIData>();
        LDIWorker w = new LDIWorker(){

            private LDrawPart getNamedPart(String name) {
                if (name == null || root == null || root.subParts == null) {
                    return null;
                }
                for (LDrawPart sub : root.subParts) {
                    if (!name.equals(sub.givenFilename)) continue;
                    return sub;
                }
                return null;
            }

            @Override
            public LDrawPart handlePartRef(LDrawLinePartRef ref, String partName, int colId, int pcol) {
                return this.getNamedPart(partName);
            }

            @Override
            public void handleParMeta(LDrawLineParMeta meta) {
                block23: {
                    if (!"!LDINSP".equals(meta.system)) {
                        return;
                    }
                    try {
                        boolean list;
                        String listName = null;
                        switch (meta.type) {
                            case "DATA_LIST": {
                                list = true;
                                listName = meta.options.get("source");
                                if (listName != null) break;
                                throw new IllegalArgumentException("missing source listName");
                            }
                            case "DATA_ITEM": {
                                list = false;
                                break;
                            }
                            default: {
                                return;
                            }
                        }
                        String clssName = meta.options.get("type");
                        String colIdStr = meta.options.get("colId");
                        String amountStr = meta.options.get("amount");
                        int colId = colIdStr != null ? Integer.parseInt(colIdStr) : -1;
                        int amount = amountStr != null ? Integer.parseInt(amountStr) : 0;
                        String saveString = meta.options.get("data");
                        if (clssName == null || saveString == null) {
                            throw new IllegalArgumentException("missing type clssName / data saveString");
                        }
                        Class<?> clss = Class.forName("ldinsp.data." + clssName);
                        Object rest = clss.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        if (!(rest instanceof LDIDataSaveable)) {
                            throw new IllegalArgumentException("class does not implement LDIDataSaveable");
                        }
                        LDIDataSaveable item = (LDIDataSaveable)rest;
                        item.restoreFromSaveString(colId, amount, saveString, logger);
                        res.add(item);
                        if (list) {
                            LDrawPart sub = this.getNamedPart(listName);
                            if (sub == null) {
                                if (logger != null) {
                                    logger.log("missing subfile " + listName);
                                }
                            } else {
                                List<LDIData> subs = LDIContext.this.getDataItems(sub, root, logger);
                                if (subs == null) {
                                    if (logger != null) {
                                        logger.log("error restoring subfile " + listName);
                                    }
                                } else if (!item.restoreSubElements(subs, logger) && logger != null) {
                                    logger.log("internal error in subfile " + listName);
                                }
                            }
                        }
                    }
                    catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                        if (logger == null) break block23;
                        logger.log("error during instantiation of LDIData: " + e.getClass().getName() + ": " + e.getMessage());
                    }
                }
            }
        };
        w.work(from, true);
        return res;
    }

    private void sortColors() {
        this.colors.sort(new Comparator<LDICColor>(){

            @Override
            public int compare(LDICColor o1, LDICColor o2) {
                return o1.id - o2.id;
            }
        });
    }

    private static String escape(String s) {
        if (s == null) {
            return null;
        }
        if (!(s.contains("&") || s.contains("[") || s.contains("]"))) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s);
        int i = 0;
        while (i < sb.length()) {
            switch (sb.charAt(i)) {
                case '&': {
                    sb.insert(i++, '&');
                    break;
                }
                case '[': {
                    sb.insert(i++, '&');
                    sb.setCharAt(i, '(');
                    break;
                }
                case ']': {
                    sb.insert(i++, '&');
                    sb.setCharAt(i, ')');
                }
            }
            ++i;
        }
        return sb.toString();
    }

    private static String unescape(String s) {
        if (s == null) {
            return null;
        }
        if (!s.contains("&")) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s);
        int i = 0;
        while (i + 1 < sb.length()) {
            if (sb.charAt(i) == '&') {
                sb.deleteCharAt(i);
                switch (sb.charAt(i)) {
                    case '(': {
                        sb.setCharAt(i, '[');
                        break;
                    }
                    case ')': {
                        sb.setCharAt(i, ']');
                    }
                }
            }
            ++i;
        }
        return sb.toString();
    }
}

