/*
 * Decompiled with CFR 0.152.
 */
package ldinsp.context;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import ldinsp.base.LDILogger;
import ldinsp.context.LDICFile;
import ldinsp.ldraw.LDrawFiles;
import ldinsp.ldraw.LDrawPart;
import ldinsp.ldraw.LDrawPartOrigin;

public class LDICPZip
extends LDICFile {
    public static final String TYPE = "ZIP";
    private final String filename;

    public LDICPZip(String zipfile, LDrawPartOrigin iorigin) {
        super(iorigin);
        this.filename = zipfile;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public String getDest() {
        return this.filename;
    }

    @Override
    LDrawPart loadPartFromFile(String name, LDILogger logger) throws IOException {
        LDrawPart me = null;
        String parts1 = "ldraw/parts/" + name;
        String p1 = "ldraw/p/" + name;
        String parts2 = "parts/" + name;
        String p2 = "p/" + name;
        ZipFile zip = new ZipFile(this.filename);
        Enumeration<? extends ZipEntry> en = zip.entries();
        while (en.hasMoreElements()) {
            String key;
            ZipEntry ze = en.nextElement();
            if (ze.isDirectory() || !(key = ze.getName().toLowerCase()).equals(parts1) && !key.equals(p1) && !key.equals(parts2) && !key.equals(p2)) continue;
            BufferedReader br = new BufferedReader(new InputStreamReader(zip.getInputStream(ze)));
            me = LDrawFiles.parseDef(ze.getName(), br, this.origin, logger);
            br.close();
            break;
        }
        zip.close();
        return me;
    }

    @Override
    public void addAllPartHeaders(ArrayList<LDrawPart> list, LDILogger logger) {
        block6: {
            LDrawPart me = null;
            String parts1 = "ldraw/parts/";
            String parts2 = "parts/";
            ZipFile zip = null;
            try {
                zip = new ZipFile(this.filename);
                Enumeration<? extends ZipEntry> en = zip.entries();
                while (en.hasMoreElements()) {
                    String key;
                    ZipEntry ze = en.nextElement();
                    if (ze.isDirectory() || (!(key = ze.getName().toLowerCase()).startsWith(parts1) || key.indexOf(47, parts1.length()) != -1) && (!key.startsWith(parts2) || key.indexOf(47, parts2.length()) != -1)) continue;
                    BufferedReader br = new BufferedReader(new InputStreamReader(zip.getInputStream(ze)));
                    me = LDrawFiles.parseDef(ze.getName(), br, this.origin, logger, true);
                    br.close();
                    list.add(me);
                }
                zip.close();
            }
            catch (IOException e) {
                if (logger != null) {
                    logger.log("addAll-ZIP had I/O exception: " + e.getClass().getName() + ": " + e.getMessage());
                }
                if (zip == null) break block6;
                try {
                    zip.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

