/*
 * Decompiled with CFR 0.152.
 */
package ldinsp.colldet;

import java.util.ArrayList;
import ldinsp.colldet.Bound;
import ldinsp.colldet.Line;
import ldinsp.colldet.LineSeg;
import ldinsp.colldet.Tri;
import ldinsp.colldet.UnexpectedCaseException;
import ldinsp.ldraw.LDrawPoint;

public class Object3D {
    private final ArrayList<Tri> faces = new ArrayList();
    private final Bound bound = new Bound();

    public void addTri(LDrawPoint v1, LDrawPoint v2, LDrawPoint v3) {
        Tri face = new Tri(v1, v2, v3);
        this.faces.add(face);
        this.bound.addBound(face.bound);
    }

    public int countIntersectingFaces(Object3D object, double tolerance) {
        int count = 0;
        if (this.bound.overlap(object.bound, tolerance)) {
            for (Tri face1 : this.faces) {
                if (!face1.bound.overlap(object.bound, tolerance)) continue;
                for (Tri face2 : object.faces) {
                    int signFace2Vert3;
                    int signFace2Vert2;
                    int signFace2Vert1;
                    int signFace1Vert3;
                    int signFace1Vert2;
                    int signFace1Vert1;
                    if (!face1.bound.overlap(face2.bound, tolerance)) continue;
                    double distFace1Vert1 = this.computeDistance(face1.v1, face2);
                    double distFace1Vert2 = this.computeDistance(face1.v2, face2);
                    double distFace1Vert3 = this.computeDistance(face1.v3, face2);
                    int n = distFace1Vert1 > tolerance ? 1 : (signFace1Vert1 = distFace1Vert1 < -tolerance ? -1 : 0);
                    int n2 = distFace1Vert2 > tolerance ? 1 : (signFace1Vert2 = distFace1Vert2 < -tolerance ? -1 : 0);
                    int n3 = distFace1Vert3 > tolerance ? 1 : (signFace1Vert3 = distFace1Vert3 < -tolerance ? -1 : 0);
                    if ((signFace1Vert1 ^ signFace1Vert2) != -2 && (signFace1Vert2 ^ signFace1Vert3) != -2 && (signFace1Vert1 ^ signFace1Vert3) != -2) continue;
                    double distFace2Vert1 = this.computeDistance(face2.v1, face1);
                    double distFace2Vert2 = this.computeDistance(face2.v2, face1);
                    double distFace2Vert3 = this.computeDistance(face2.v3, face1);
                    int n4 = distFace2Vert1 > tolerance ? 1 : (signFace2Vert1 = distFace2Vert1 < -tolerance ? -1 : 0);
                    int n5 = distFace2Vert2 > tolerance ? 1 : (signFace2Vert2 = distFace2Vert2 < -tolerance ? -1 : 0);
                    int n6 = distFace2Vert3 > tolerance ? 1 : (signFace2Vert3 = distFace2Vert3 < -tolerance ? -1 : 0);
                    if ((signFace2Vert1 ^ signFace2Vert2) != -2 && (signFace2Vert2 ^ signFace2Vert3) != -2 && (signFace2Vert1 ^ signFace2Vert3) != -2) continue;
                    try {
                        Line line = new Line(face1, face2);
                        LineSeg segment1 = new LineSeg(line, face1, signFace1Vert1, signFace1Vert2, signFace1Vert3);
                        LineSeg segment2 = new LineSeg(line, face2, signFace2Vert1, signFace2Vert2, signFace2Vert3);
                        if (!this.intersects(segment1, segment2, tolerance)) continue;
                        ++count;
                    }
                    catch (UnexpectedCaseException e) {
                        System.err.println("intersectingFaces reported unexpected case");
                    }
                }
            }
        }
        return count;
    }

    private double computeDistance(LDrawPoint vertex, Tri face) {
        LDrawPoint normal = face.normal;
        return normal.dot(vertex) - normal.dot(face.v1);
    }

    private boolean intersects(LineSeg s1, LineSeg s2, double tolerance) {
        return s1.getEndDistance() > s2.getStartDistance() + tolerance && s1.getStartDistance() < s2.getEndDistance() - tolerance;
    }
}

