/*
 * Decompiled with CFR 0.152.
 */
package ldinsp.check;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import ldinsp.base.LDIWorkerRefWalk;
import ldinsp.check.LDICheck;
import ldinsp.check.LDICheckSolve;
import ldinsp.check.LDICheckSolveFix;
import ldinsp.check.LDICheckState;
import ldinsp.context.LDIContext;
import ldinsp.ldraw.LDrawEdit;
import ldinsp.ldraw.LDrawPart;

public class LDICSubfilesUsed
extends LDICheck {
    private LDICheckState resState = LDICheckState.OK;
    private String resShort;
    private String resLong;
    private ArrayList<LDICheckSolve> solver;

    public LDICSubfilesUsed(LDIContext ctx, final LDrawPart part) {
        if (part.subParts == null) {
            this.resState = LDICheckState.IGN;
            this.resShort = " ign : file does not contain subparts, so no subpart usage check\n";
            this.resLong = "";
            return;
        }
        final HashSet used = new HashSet();
        LDIWorkerRefWalk w = new LDIWorkerRefWalk(){

            @Override
            public LDrawPart usePart(String partName) {
                LDrawPart dest = null;
                for (LDrawPart sp : part.subParts) {
                    if (!sp.givenFilename.equalsIgnoreCase(partName)) continue;
                    dest = sp;
                    break;
                }
                if (dest == null || used.contains(dest)) {
                    return null;
                }
                used.add(dest);
                return dest;
            }
        };
        w.work(part, false);
        StringBuffer lrsb = new StringBuffer();
        final ArrayList<LDrawPart> remove = new ArrayList<LDrawPart>();
        for (LDrawPart sb : part.subParts) {
            if (used.contains(sb)) continue;
            this.resState = LDICheckState.WARN;
            lrsb.append("subpart " + sb.givenName + " (" + sb.description + ") is embedded but not used, starting in line " + this.getFirstLineNr(sb) + "\n");
            remove.add(sb);
        }
        if (this.resState == LDICheckState.OK) {
            this.resShort = "  ok : subfiles are all used\n";
        } else {
            this.resShort = " warn: at least one (sub)file is unused\n";
            this.solver = new ArrayList();
            this.solver.add(new LDICheckSolveFix("Unused", "Remove all " + remove.size() + " unused subfiles", false){

                @Override
                public int fix() {
                    return LDrawEdit.remove(part, remove);
                }
            });
        }
        this.resLong = lrsb.toString();
    }

    @Override
    public LDICheckState getState() {
        return this.resState;
    }

    @Override
    public String getShortResult() {
        return this.resShort;
    }

    @Override
    public String getLongResult() {
        return this.resLong;
    }

    @Override
    public List<LDICheckSolve> getSolver() {
        return this.solver;
    }

    private int getFirstLineNr(LDrawPart p) {
        if (p.headers != null && p.headers.size() > 0) {
            return p.headers.get((int)0).lineNr;
        }
        if (p.actions != null && p.actions.size() > 0) {
            return p.actions.get((int)0).lineNr;
        }
        return 0;
    }
}

