/*
 * Decompiled with CFR 0.152.
 */
package ldinsp.check;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import ldinsp.base.LDIWorker;
import ldinsp.check.LDICheck;
import ldinsp.check.LDICheckMessage;
import ldinsp.check.LDICheckSolve;
import ldinsp.check.LDICheckSolveFix;
import ldinsp.check.LDICheckSolveHint;
import ldinsp.check.LDICheckState;
import ldinsp.context.LDIContext;
import ldinsp.ldraw.LDrawEdit;
import ldinsp.ldraw.LDrawLine;
import ldinsp.ldraw.LDrawLinePartRef;
import ldinsp.ldraw.LDrawPart;
import ldinsp.ldraw.LDrawPartOrigin;

public class LDICReferences
extends LDICheck {
    private LDICheckState resState = LDICheckState.OK;
    private String resShort;
    private String resLong;
    private HashMap<LDrawLine, ArrayList<LDICheckMessage>> partErrors;
    private ArrayList<LDICheckSolve> solver;

    public LDICReferences(final LDIContext ctx, final LDrawPart part) {
        final StringBuffer rl = new StringBuffer();
        final ArrayList toEmbed = new ArrayList();
        final ArrayList toRemove = new ArrayList();
        LDIWorker w = new LDIWorker(){
            private HashSet<String> checked = new HashSet();

            @Override
            public LDrawPart handlePartRef(LDrawLinePartRef ref, String partName, int colId, int pcol) {
                if (this.checked.contains(partName)) {
                    return null;
                }
                LDrawPart res = ctx.getPart(ref.owner, partName, null);
                this.checked.add(partName);
                if (res == null) {
                    LDICReferences.this.resState = LDICheckState.ERROR;
                    rl.append("part " + partName + " referenced in line " + ref.lineNr + " could not be resolved\n");
                    LDICReferences.this.partErrors = LDICReferences.addPartError(LDICReferences.this.partErrors, ref, "part " + partName + " is not resolvable", 4);
                    toRemove.add(partName);
                    return null;
                }
                if (res.origin == LDrawPartOrigin.UNOFFICIAL) {
                    toEmbed.add(res);
                    LDICReferences.this.resState = LDICReferences.this.resState.combine(LDICheckState.WARN);
                    rl.append("part " + partName + " referenced in line " + ref.lineNr + " is marked as unofficial\n");
                    LDICReferences.this.partErrors = LDICReferences.addPartError(LDICReferences.this.partErrors, ref, "part " + partName + " is unofficial", 2);
                }
                if (res.origin != LDrawPartOrigin.SELF) {
                    return null;
                }
                return res;
            }
        };
        w.work(part, false);
        if (this.resState == LDICheckState.OK) {
            this.resShort = "  ok : all referenced parts are official\n";
        } else {
            this.solver = new ArrayList();
            if (toEmbed.size() > 0) {
                this.solver.add(new LDICheckSolveFix("Unoffical", "Embed " + toEmbed.size() + " unofficial parts", true){

                    @Override
                    public int fix() {
                        return LDrawEdit.embed(part, toEmbed, ctx);
                    }
                });
            }
            if (this.resState == LDICheckState.WARN) {
                this.resShort = " warn: unofficial parts used\n";
            } else {
                this.resShort = "error: contains unresolvable references\n";
                this.solver.add(new LDICheckSolveHint("Refs.", "Embed parts or remove unresolvable references"));
                this.solver.add(new LDICheckSolveFix("Rem.Un.Refs.", "Remove references to all " + toRemove.size() + " unresolvable parts", false){

                    @Override
                    public int fix() {
                        return LDrawEdit.removeRefs(part, toRemove, true);
                    }
                });
            }
        }
        this.resLong = rl.toString();
    }

    @Override
    public LDICheckState getState() {
        return this.resState;
    }

    @Override
    public String getShortResult() {
        return this.resShort;
    }

    @Override
    public String getLongResult() {
        return this.resLong;
    }

    @Override
    public List<LDICheckSolve> getSolver() {
        return this.solver;
    }

    @Override
    public HashMap<LDrawLine, ArrayList<LDICheckMessage>> getPartErrors() {
        return this.partErrors;
    }
}

