/*
 * Decompiled with CFR 0.152.
 */
package ldinsp.check;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import ldinsp.base.LDIWorker;
import ldinsp.check.LDICheck;
import ldinsp.check.LDICheckMessage;
import ldinsp.check.LDICheckSolve;
import ldinsp.check.LDICheckSolveHint;
import ldinsp.check.LDICheckState;
import ldinsp.context.LDIContext;
import ldinsp.ldraw.LDrawLine;
import ldinsp.ldraw.LDrawLinePartRef;
import ldinsp.ldraw.LDrawPart;

public class LDICMirroredParts
extends LDICheck {
    private LDICheckState resState = LDICheckState.OK;
    private String resShort;
    private String resLong;
    private HashMap<LDrawLine, ArrayList<LDICheckMessage>> partErrors;
    private ArrayList<LDICheckSolve> solver;

    public LDICMirroredParts(LDIContext ctx, LDrawPart part) {
        boolean skipPrinted = false;
        if (this.isDat(part)) {
            this.resState = LDICheckState.IGN;
            this.resShort = " ign : file ends with .dat and is therefore not checked for mirrored parts\n";
            this.resLong = "";
            return;
        }
        StringBuffer lrsb = new StringBuffer();
        this.checkPart(ctx, part, lrsb);
        if (part.subParts != null) {
            for (LDrawPart sb : part.subParts) {
                if (this.isDat(sb)) {
                    if (skipPrinted) continue;
                    lrsb.append("skipped mirror check for .dat-subparts\n");
                    skipPrinted = true;
                    continue;
                }
                this.checkPart(ctx, sb, lrsb);
            }
        }
        if (this.resState == LDICheckState.OK) {
            this.resShort = "  ok : no mirrored parts\n";
        } else {
            this.resShort = "error: contains mirrored parts\n";
            this.solver = new ArrayList();
            this.solver.add(new LDICheckSolveHint("Mirrored", "Replace mirrored parts by un-mirrored ones"));
        }
        this.resLong = lrsb.toString();
    }

    @Override
    public LDICheckState getState() {
        return this.resState;
    }

    @Override
    public String getShortResult() {
        return this.resShort;
    }

    @Override
    public String getLongResult() {
        return this.resLong;
    }

    @Override
    public List<LDICheckSolve> getSolver() {
        return this.solver;
    }

    @Override
    public HashMap<LDrawLine, ArrayList<LDICheckMessage>> getPartErrors() {
        return this.partErrors;
    }

    private boolean isDat(LDrawPart part) {
        return part.loadedFromFilename != null && part.loadedFromFilename.toLowerCase().endsWith(".dat") || part.givenFilename != null && part.givenFilename.toLowerCase().endsWith(".dat");
    }

    private void checkPart(LDIContext ctx, LDrawPart part, final StringBuffer lrsb) {
        LDIWorker w = new LDIWorker(){

            @Override
            public LDrawPart handlePartRef(LDrawLinePartRef ref, String partName, int colId, int pcol) {
                if (ref.trans.det < 0.0) {
                    LDICMirroredParts.this.resState = LDICheckState.ERROR;
                    lrsb.append("part " + partName + " referenced in line " + ref.lineNr + " is mirrored\n");
                    LDICMirroredParts.this.partErrors = LDICMirroredParts.addPartError(LDICMirroredParts.this.partErrors, ref, "mirrored", 4);
                }
                return null;
            }
        };
        w.work(part, false);
    }
}

