/*
 * Decompiled with CFR 0.152.
 */
package ldinsp.check;

import java.util.ArrayList;
import java.util.List;
import ldinsp.check.LDICheck;
import ldinsp.check.LDICheckSolve;
import ldinsp.check.LDICheckSolveFix;
import ldinsp.check.LDICheckSolveHint;
import ldinsp.check.LDICheckState;
import ldinsp.context.LDIContext;
import ldinsp.ldraw.LDrawEdit;
import ldinsp.ldraw.LDrawPart;

public class LDICIsMpd
extends LDICheck {
    private LDICheckState resState = LDICheckState.OK;
    private String resShort;
    private String resLong;
    private ArrayList<LDICheckSolve> solver;

    public LDICIsMpd(LDIContext ctx, final LDrawPart part) {
        StringBuffer lrsb = new StringBuffer();
        final String chkFilename = part.loadedFromFilename != null ? part.loadedFromFilename : part.givenFilename;
        this.solver = new ArrayList();
        if (chkFilename.toLowerCase().endsWith(".mpd")) {
            if (part.givenFilename == null) {
                this.resState = LDICheckState.WARN;
                this.resShort = " warn: rename file to .mpd\n";
                lrsb.append("filename ends with .mpd, but main model header has no FILE attribute\n");
                this.solver.add(new LDICheckSolveFix("Insert FILE", "Insert FILE attribute in header", false){

                    @Override
                    public int fix() {
                        int lastDot;
                        String targetname = part.givenName;
                        if (targetname == null || targetname.length() == 0) {
                            targetname = LDICIsMpd.this.getLeafFilename(chkFilename);
                        }
                        if ((lastDot = targetname.lastIndexOf(46)) > 0 && lastDot >= targetname.length() - 4) {
                            targetname = targetname.substring(0, lastDot);
                        }
                        targetname = String.valueOf(targetname) + ".ldr";
                        return LDrawEdit.addGivenFilename(part, targetname);
                    }
                });
            } else {
                this.resShort = "  ok : file is .mpd\n";
            }
        } else {
            this.resState = LDICheckState.HINT;
            lrsb.append("filename does not end with .mpd, which is very unlikely for OMR files\n");
            this.solver.add(new LDICheckSolveHint("Rename file", "Please rename the file to have .mpd ending"));
            if (part.givenFilename != null || part.subParts != null && part.subParts.size() > 0) {
                this.resState = LDICheckState.ERROR;
                this.resShort = "error: file contains sub-parts, but filename does not end with .mpd\n";
                lrsb.append("file has sub-parts but filename does not end with .mpd\n");
            } else {
                this.resShort = " hint: filename does not end with .mpd\n";
            }
        }
        if (this.solver.size() == 0) {
            this.solver = null;
        }
        this.resLong = lrsb.toString();
    }

    @Override
    public LDICheckState getState() {
        return this.resState;
    }

    @Override
    public String getShortResult() {
        return this.resShort;
    }

    @Override
    public String getLongResult() {
        return this.resLong;
    }

    @Override
    public List<LDICheckSolve> getSolver() {
        return this.solver;
    }

    private String getLeafFilename(String filename) {
        int lastSlash = filename.replace('\\', '/').lastIndexOf(47);
        if (lastSlash < 0) {
            return filename;
        }
        return filename.substring(lastSlash + 1);
    }
}

